/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yang.store.impl.YangStoreSnapshotImpl;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class YangStoreCache {
    private static final Logger logger = LoggerFactory.getLogger(YangStoreCache.class);
    @GuardedBy(value="this")
    private Set<URL> cachedUrls = null;
    @GuardedBy(value="this")
    private Optional<YangStoreSnapshot> cachedYangStoreSnapshot = this.getInitialSnapshot();
    @GuardedBy(value="this")
    private Collection<URL> inconsistentURLsForReporting = Collections.emptySet();

    YangStoreCache() {
    }

    synchronized Optional<YangStoreSnapshot> getSnapshotIfPossible(Multimap<Bundle, URL> bundlesToYangURLs) {
        Set<URL> urls = YangStoreCache.setFromMultimapValues(bundlesToYangURLs);
        if (this.cachedUrls == null || this.cachedUrls.equals(urls)) {
            Preconditions.checkState((boolean)this.cachedYangStoreSnapshot.isPresent());
            YangStoreSnapshotImpl freshSnapshot = YangStoreSnapshotImpl.copy((YangStoreSnapshot)this.cachedYangStoreSnapshot.get());
            if (this.inconsistentURLsForReporting.size() > 0) {
                logger.warn("Some yang URLs are ignored: {}", this.inconsistentURLsForReporting);
            }
            return Optional.of((Object)freshSnapshot);
        }
        return Optional.absent();
    }

    private static Set<URL> setFromMultimapValues(Multimap<Bundle, URL> bundlesToYangURLs) {
        HashSet urls = Sets.newHashSet((Iterable)bundlesToYangURLs.values());
        Preconditions.checkState((bundlesToYangURLs.size() == urls.size() ? 1 : 0) != 0);
        return urls;
    }

    synchronized void cacheYangStore(Multimap<Bundle, URL> urls, YangStoreSnapshot yangStoreSnapshot) {
        this.cachedUrls = YangStoreCache.setFromMultimapValues(urls);
        this.cachedYangStoreSnapshot = Optional.of((Object)yangStoreSnapshot);
    }

    synchronized void invalidate() {
        this.cachedUrls.clear();
        if (this.cachedYangStoreSnapshot.isPresent()) {
            ((YangStoreSnapshot)this.cachedYangStoreSnapshot.get()).close();
            this.cachedYangStoreSnapshot = Optional.absent();
        }
    }

    public synchronized void setInconsistentURLsForReporting(Collection<URL> urls) {
        this.inconsistentURLsForReporting = urls;
    }

    private Optional<YangStoreSnapshot> getInitialSnapshot() {
        YangStoreSnapshot initialSnapshot = new YangStoreSnapshot(){

            public Map<String, Map<String, ModuleMXBeanEntry>> getModuleMXBeanEntryMap() {
                return Collections.emptyMap();
            }

            public Map<QName, Map<String, ModuleMXBeanEntry>> getQNamesToIdentitiesToModuleMXBeanEntries() {
                return Collections.emptyMap();
            }

            public Set<Module> getModules() {
                return Collections.emptySet();
            }

            public Map<Module, String> getModulesToSources() {
                return Collections.emptyMap();
            }

            public String getModuleSource(Module module) {
                throw new IllegalArgumentException("Cannot get sources in empty snapshot");
            }

            public int countModuleMXBeanEntries() {
                return 0;
            }

            public void close() {
            }
        };
        return Optional.of((Object)initialSnapshot);
    }
}

