/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import com.google.common.base.Optional;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.opendaylight.controller.config.yang.store.api.YangStoreService;
import org.opendaylight.controller.config.yang.store.impl.ExtenderYangTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangStoreActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(YangStoreActivator.class);

    public void start(BundleContext context) throws Exception {
        Optional maybeBlacklistPattern = Optional.absent();
        String blacklist = context.getProperty("yangstore.blacklist");
        if (blacklist != null) {
            try {
                maybeBlacklistPattern = Optional.of((Object)Pattern.compile(blacklist));
            }
            catch (RuntimeException e) {
                logger.error("Cannot parse blacklist regex " + blacklist, (Throwable)e);
                throw e;
            }
        }
        ExtenderYangTracker extenderYangTracker = new ExtenderYangTracker((Optional<Pattern>)maybeBlacklistPattern, context);
        Hashtable properties = new Hashtable();
        context.registerService(YangStoreService.class, (Object)extenderYangTracker, properties);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

