/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.opendaylight.controller.config.yang.store.api.YangStoreException;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangModelParser;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;

public class YangParserWrapper {
    public static SchemaContext parseYangFiles(Collection<? extends InputStream> yangFilesAsInputStreams) {
        YangParserImpl parser = YangParserWrapper.getYangParserInstance();
        Map<InputStream, Module> mappedYangModules = null;
        try {
            mappedYangModules = YangParserWrapper.parseYangFiles((YangModelParser)parser, yangFilesAsInputStreams);
        }
        catch (YangStoreException e) {
            throw new IllegalStateException("Unable to parse yang files", e);
        }
        return YangParserWrapper.getSchemaContextFromModules((YangModelParser)parser, mappedYangModules);
    }

    static YangParserImpl getYangParserInstance() {
        return new YangParserImpl();
    }

    static SchemaContext getSchemaContextFromModules(YangModelParser parser, Map<InputStream, Module> allYangModules) {
        return parser.resolveSchemaContext((Set)Sets.newHashSet(allYangModules.values()));
    }

    static Map<InputStream, Module> parseYangFiles(YangModelParser parser, Collection<? extends InputStream> allInput) throws YangStoreException {
        ArrayList<ByteArrayInputStream> bufferedInputStreams = new ArrayList<ByteArrayInputStream>();
        for (InputStream inputStream : allInput) {
            String content;
            try {
                content = IOUtils.toString((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new YangStoreException("Can not get yang as String from " + inputStream, (Throwable)e);
            }
            ByteArrayInputStream buf = new ByteArrayInputStream(content.getBytes());
            bufferedInputStreams.add(buf);
        }
        return parser.parseYangModelsFromStreamsMapped(bufferedInputStreams);
    }
}

