/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.opendaylight.controller.config.yang.store.api.YangStoreException;
import org.opendaylight.controller.config.yang.store.impl.YangParserWrapper;
import org.opendaylight.controller.config.yang.store.impl.YangStoreSnapshotImpl;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.PackageTranslator;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangModelParser;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MbeParser {
    private static final Logger logger = LoggerFactory.getLogger(MbeParser.class);

    public YangStoreSnapshotImpl parseYangFiles(Collection<? extends InputStream> allInput) throws YangStoreException {
        YangParserImpl parser = YangParserWrapper.getYangParserInstance();
        Map<InputStream, Module> allYangModules = YangParserWrapper.parseYangFiles((YangModelParser)parser, allInput);
        SchemaContext resolveSchemaContext = YangParserWrapper.getSchemaContextFromModules((YangModelParser)parser, allYangModules);
        logger.trace("Resolved modules:{}", (Object)resolveSchemaContext.getModules());
        HashMap namespaceToPackageMapping = Maps.newHashMap();
        PackageTranslator packageTranslator = new PackageTranslator((Map)namespaceToPackageMapping);
        HashMap qNamesToSIEs = new HashMap();
        HashMap knownSEITracker = new HashMap();
        for (Module module : resolveSchemaContext.getModules()) {
            String packageName = packageTranslator.getPackageName(module);
            Map namesToSIEntries = ServiceInterfaceEntry.create((Module)module, (String)packageName, knownSEITracker);
            for (Map.Entry sieEntry : namesToSIEntries.entrySet()) {
                if (!qNamesToSIEs.containsKey(sieEntry.getKey())) {
                    qNamesToSIEs.put(sieEntry.getKey(), sieEntry.getValue());
                    continue;
                }
                throw new IllegalStateException("Cannot add two SIE with same qname " + sieEntry.getValue());
            }
        }
        HashMap moduleMXBeanEntryMap = Maps.newHashMap();
        HashMap<Module, String> modulesToSources = new HashMap<Module, String>();
        HashMap<QName, Map<String, ModuleMXBeanEntry>> qNamesToIdentitiesToModuleMXBeanEntries = new HashMap<QName, Map<String, ModuleMXBeanEntry>>();
        for (Map.Entry<InputStream, Module> moduleEntry : allYangModules.entrySet()) {
            Module module = moduleEntry.getValue();
            String packageName = packageTranslator.getPackageName(module);
            TypeProviderWrapper typeProviderWrapper = new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(resolveSchemaContext));
            String yangAsString = this.reReadInputStream(moduleEntry);
            QName qName = new QName(module.getNamespace(), module.getRevision(), module.getName());
            Map namesToMBEs = Collections.unmodifiableMap(ModuleMXBeanEntry.create((Module)module, qNamesToSIEs, (SchemaContext)resolveSchemaContext, (TypeProviderWrapper)typeProviderWrapper, (String)packageName));
            moduleMXBeanEntryMap.put(module.getNamespace().toString(), namesToMBEs);
            modulesToSources.put(module, yangAsString);
            qNamesToIdentitiesToModuleMXBeanEntries.put(qName, namesToMBEs);
        }
        return new YangStoreSnapshotImpl(moduleMXBeanEntryMap, modulesToSources, qNamesToIdentitiesToModuleMXBeanEntries);
    }

    private String reReadInputStream(Map.Entry<InputStream, Module> moduleEntry) {
        String yangAsString;
        try {
            moduleEntry.getKey().reset();
            yangAsString = IOUtils.toString((InputStream)moduleEntry.getKey());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot reread " + moduleEntry.getValue(), e);
        }
        return yangAsString;
    }

    @Deprecated
    public Map<Module, String> parseYangFilesToString(Collection<? extends InputStream> allYangs) {
        logger.error("Using deprecated method that will be removed soon", (Throwable)new UnsupportedOperationException("Deprecated"));
        YangParserImpl parser = YangParserWrapper.getYangParserInstance();
        Map allYangModules = parser.parseYangModelsFromStreamsMapped((List)Lists.newArrayList(allYangs));
        HashMap<Module, String> retVal = new HashMap<Module, String>();
        for (Map.Entry entry : allYangModules.entrySet()) {
            try {
                retVal.put((Module)entry.getValue(), IOUtils.toString((InputStream)((InputStream)entry.getKey())));
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not create string from yang file.");
            }
        }
        return retVal;
    }
}

