/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.config.yang.store.api.YangStoreException;
import org.opendaylight.controller.config.yang.store.api.YangStoreService;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yang.store.impl.MbeParser;
import org.opendaylight.controller.config.yang.store.impl.YangStoreCache;
import org.opendaylight.controller.config.yang.store.impl.YangStoreSnapshotImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtenderYangTracker
extends BundleTracker<Object>
implements YangStoreService,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ExtenderYangTracker.class);
    private final Multimap<Bundle, URL> consistentBundlesToYangURLs = HashMultimap.create();
    private final Multimap<Bundle, URL> inconsistentBundlesToYangURLs = HashMultimap.create();
    private final YangStoreCache cache = new YangStoreCache();
    private final MbeParser mbeParser;
    @GuardedBy(value="this")
    private Optional<Pattern> maybeBlacklist;

    public ExtenderYangTracker(Optional<Pattern> maybeBlacklist, BundleContext bundleContext) {
        this(new MbeParser(), maybeBlacklist, bundleContext);
    }

    @VisibleForTesting
    ExtenderYangTracker(MbeParser mbeParser, Optional<Pattern> maybeBlacklist, BundleContext bundleContext) {
        super(bundleContext, 96, null);
        this.mbeParser = mbeParser;
        this.maybeBlacklist = maybeBlacklist;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object addingBundle(Bundle bundle, BundleEvent event) {
        Matcher m;
        if (bundle.getBundleId() == 0L) {
            return bundle;
        }
        if (this.maybeBlacklist.isPresent() && (m = ((Pattern)this.maybeBlacklist.get()).matcher(bundle.getSymbolicName())).matches()) {
            logger.debug("Ignoring {} because it is in blacklist {}", (Object)bundle, this.maybeBlacklist);
            return bundle;
        }
        Enumeration enumeration = bundle.findEntries("META-INF/yang", "*.yang", false);
        if (enumeration != null && enumeration.hasMoreElements()) {
            ExtenderYangTracker extenderYangTracker = this;
            synchronized (extenderYangTracker) {
                ArrayList<URL> addedURLs = new ArrayList<URL>();
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    addedURLs.add(url);
                }
                logger.trace("Bundle {} has event {}, bundle state {}, URLs {}", new Object[]{bundle, event, bundle.getState(), addedURLs});
                HashMultimap proposedNewState = HashMultimap.create(this.consistentBundlesToYangURLs);
                proposedNewState.putAll(this.inconsistentBundlesToYangURLs);
                proposedNewState.putAll((Object)bundle, addedURLs);
                Preconditions.checkArgument((addedURLs.size() > 0 ? 1 : 0) != 0, (Object)"No change can occur when no URLs are changed");
                try (YangStoreSnapshotImpl snapshot = ExtenderYangTracker.createSnapshot(this.mbeParser, (Multimap<Bundle, URL>)proposedNewState);){
                    this.onSnapshotSuccess((Multimap<Bundle, URL>)proposedNewState, snapshot);
                }
                catch (YangStoreException e) {
                    this.onSnapshotFailure(bundle, addedURLs, (Exception)((Object)e));
                }
            }
        }
        return bundle;
    }

    private synchronized void onSnapshotFailure(Bundle bundle, List<URL> addedURLs, Exception failureReason) {
        this.inconsistentBundlesToYangURLs.putAll((Object)bundle, addedURLs);
        logger.debug("Yang store is falling back to last consistent state containing {}, inconsistent yang files {}", new Object[]{this.consistentBundlesToYangURLs, this.inconsistentBundlesToYangURLs, failureReason});
        logger.info("Yang store is falling back to last consistent state containing {} files, keeping {} inconsistent yang files due to {}", new Object[]{this.consistentBundlesToYangURLs.size(), this.inconsistentBundlesToYangURLs.size(), failureReason.toString()});
        this.cache.setInconsistentURLsForReporting(this.inconsistentBundlesToYangURLs.values());
    }

    private synchronized void onSnapshotSuccess(Multimap<Bundle, URL> proposedNewState, YangStoreSnapshotImpl snapshot) {
        this.consistentBundlesToYangURLs.clear();
        this.consistentBundlesToYangURLs.putAll(proposedNewState);
        logger.debug("Yang store updated to new consistent state containing {}", this.consistentBundlesToYangURLs);
        if (!this.inconsistentBundlesToYangURLs.isEmpty()) {
            this.inconsistentBundlesToYangURLs.clear();
            logger.info("Yang store updated to new consistent state containing {} yang files", (Object)this.consistentBundlesToYangURLs.size());
        }
        this.updateCache(snapshot);
        this.cache.setInconsistentURLsForReporting(Collections.emptySet());
    }

    private synchronized void updateCache(YangStoreSnapshotImpl snapshot) {
        this.cache.cacheYangStore(this.consistentBundlesToYangURLs, snapshot);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        logger.debug("Modified bundle {} {} {}", new Object[]{bundle, event, object});
    }

    public synchronized void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        logger.debug("Removed bundle {} {} {}", new Object[]{bundle, event, object});
        this.inconsistentBundlesToYangURLs.removeAll((Object)bundle);
        this.consistentBundlesToYangURLs.removeAll((Object)bundle);
    }

    public synchronized YangStoreSnapshot getYangStoreSnapshot() throws YangStoreException {
        Optional<YangStoreSnapshot> yangStoreOpt = this.cache.getSnapshotIfPossible(this.consistentBundlesToYangURLs);
        if (yangStoreOpt.isPresent()) {
            logger.debug("Returning cached yang store {}", yangStoreOpt.get());
            return (YangStoreSnapshot)yangStoreOpt.get();
        }
        YangStoreSnapshotImpl snapshot = ExtenderYangTracker.createSnapshot(this.mbeParser, this.consistentBundlesToYangURLs);
        this.updateCache(snapshot);
        return snapshot;
    }

    private static YangStoreSnapshotImpl createSnapshot(MbeParser mbeParser, Multimap<Bundle, URL> multimap) throws YangStoreException {
        try {
            YangStoreSnapshotImpl yangStoreSnapshot = mbeParser.parseYangFiles(ExtenderYangTracker.fromUrlsToInputStreams(multimap));
            logger.trace("{} module entries parsed successfully from {} yang files", (Object)yangStoreSnapshot.countModuleMXBeanEntries(), (Object)multimap.values().size());
            return yangStoreSnapshot;
        }
        catch (RuntimeException e) {
            StringBuffer causeStr = new StringBuffer();
            Throwable cause = e;
            while (cause != null) {
                causeStr.append(e.getMessage());
                causeStr.append("\n");
                cause = e.getCause();
            }
            throw new YangStoreException("Unable to parse yang files. \n" + causeStr.toString() + "URLs: " + multimap, (Throwable)e);
        }
    }

    private static Collection<InputStream> fromUrlsToInputStreams(Multimap<Bundle, URL> multimap) {
        return Collections2.transform((Collection)multimap.values(), (Function)new Function<URL, InputStream>(){

            public InputStream apply(URL url) {
                try {
                    return url.openStream();
                }
                catch (IOException e) {
                    logger.warn("Unable to open stream from {}", (Object)url);
                    throw new IllegalStateException("Unable to open stream from " + url, e);
                }
            }
        });
    }

    public synchronized void setMaybeBlacklist(Optional<Pattern> maybeBlacklistPattern) {
        this.maybeBlacklist = maybeBlacklistPattern;
        this.cache.invalidate();
    }
}

