/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.opendaylight.controller.usermanager.ISessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements ISessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private Map<ServletContext, Set<HttpSession>> sessionMap = new HashMap<ServletContext, Set<HttpSession>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent se) {
        ServletContext ctx = se.getSession().getServletContext();
        String path = ctx.getContextPath();
        logger.debug("Servlet Context Path created {}", (Object)path);
        logger.debug("Session Id created for ctxt path {}", (Object)se.getSession().getId());
        Map<ServletContext, Set<HttpSession>> map = this.sessionMap;
        synchronized (map) {
            Set<HttpSession> set = this.sessionMap.get(ctx);
            if (set == null) {
                set = new HashSet<HttpSession>();
                this.sessionMap.put(ctx, set);
            }
            set.add(se.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        ServletContext ctx = se.getSession().getServletContext();
        String path = ctx.getContextPath();
        logger.debug("Servlet Context Path of destroyed session - {}", (Object)path);
        logger.debug("Session Id destroyed {}", (Object)se.getSession().getId());
        Map<ServletContext, Set<HttpSession>> map = this.sessionMap;
        synchronized (map) {
            Set<HttpSession> set = this.sessionMap.get(ctx);
            if (set != null) {
                set.remove(se.getSession());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSessions(String username, String sessionId) {
        Map<ServletContext, Set<HttpSession>> map = this.sessionMap;
        synchronized (map) {
            ArrayList<HttpSession> sessionsList = new ArrayList<HttpSession>();
            for (Map.Entry<ServletContext, Set<HttpSession>> val : this.sessionMap.entrySet()) {
                Iterator<HttpSession> sessIterator = val.getValue().iterator();
                while (sessIterator.hasNext()) {
                    HttpSession session = sessIterator.next();
                    if (session != null && sessionId != null && session.getId() != null && !session.getId().equals(sessionId)) {
                        sessionsList.add(session);
                        sessIterator.remove();
                        continue;
                    }
                    logger.debug(" session or sessionId is null ");
                }
            }
            Iterator sessionIt = sessionsList.iterator();
            while (sessionIt.hasNext()) {
                HttpSession session = (HttpSession)sessionIt.next();
                sessionIt.remove();
                session.invalidate();
            }
        }
    }
}

