/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.sal.authorization.AuthResultEnum;
import org.opendaylight.controller.sal.authorization.IResourceAuthorization;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.usermanager.AuthResponse;
import org.opendaylight.controller.usermanager.AuthenticatedUser;
import org.opendaylight.controller.usermanager.AuthorizationConfig;
import org.opendaylight.controller.usermanager.IAAAProvider;
import org.opendaylight.controller.usermanager.ISessionManager;
import org.opendaylight.controller.usermanager.IUserManager;
import org.opendaylight.controller.usermanager.ServerConfig;
import org.opendaylight.controller.usermanager.UserConfig;
import org.opendaylight.controller.usermanager.security.SessionManager;
import org.opendaylight.controller.usermanager.security.UserSecurityContextRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.context.SecurityContextRepository;

public class UserManager
implements IUserManager,
IObjectReader,
IConfigurationAware,
CommandProvider,
AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(UserManager.class);
    private static final String DEFAULT_ADMIN = "admin";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";
    private static final String DEFAULT_ADMIN_ROLE = UserLevel.NETWORKADMIN.toString();
    private static final String USERS_FILE_NAME = "users.conf";
    private static final String SERVERS_FILE_NAME = "servers.conf";
    private static final String AUTH_FILE_NAME = "authorization.conf";
    private static final String RECOVERY_FILE = "NETWORK_ADMIN_PASSWORD_RECOVERY";
    private ConcurrentMap<String, UserConfig> localUserConfigList;
    private ConcurrentMap<String, ServerConfig> remoteServerConfigList;
    private ConcurrentMap<String, AuthorizationConfig> authorizationConfList;
    private ConcurrentMap<String, AuthenticatedUser> activeUsers;
    private ConcurrentMap<String, IAAAProvider> authProviders;
    private IClusterGlobalServices clusterGlobalService = null;
    private IConfigurationService configurationService;
    private SecurityContextRepository securityContextRepo = new UserSecurityContextRepository();
    private IContainerAuthorization containerAuthorizationClient;
    private Set<IResourceAuthorization> applicationAuthorizationClients;
    private ISessionManager sessionMgr = new SessionManager();

    public boolean addAAAProvider(IAAAProvider provider) {
        if (provider == null || provider.getName() == null || provider.getName().trim().isEmpty()) {
            return false;
        }
        if (this.authProviders.get(provider.getName()) != null) {
            return false;
        }
        this.authProviders.put(provider.getName(), provider);
        return true;
    }

    public void removeAAAProvider(IAAAProvider provider) {
        this.authProviders.remove(provider.getName());
    }

    public IAAAProvider getAAAProvider(String name) {
        return (IAAAProvider)this.authProviders.get(name);
    }

    public Set<String> getAAAProviderNames() {
        return this.authProviders.keySet();
    }

    private void allocateCaches() {
        this.applicationAuthorizationClients = Collections.synchronizedSet(new HashSet());
        if (this.clusterGlobalService == null) {
            logger.error("un-initialized clusterGlobalService, can't create cache");
            return;
        }
        try {
            this.clusterGlobalService.createCache("usermanager.localUserConfigList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterGlobalService.createCache("usermanager.remoteServerConfigList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterGlobalService.createCache("usermanager.authorizationConfList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterGlobalService.createCache("usermanager.activeUsers", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache configuration invalid - check cache mode");
        }
        catch (CacheExistException ce) {
            logger.debug("Skipping cache creation as already present");
        }
    }

    private void retrieveCaches() {
        if (this.clusterGlobalService == null) {
            logger.error("un-initialized clusterService, can't retrieve cache");
            return;
        }
        this.activeUsers = this.clusterGlobalService.getCache("usermanager.activeUsers");
        if (this.activeUsers == null) {
            logger.error("Failed to get cache for activeUsers");
        }
        this.localUserConfigList = this.clusterGlobalService.getCache("usermanager.localUserConfigList");
        if (this.localUserConfigList == null) {
            logger.error("Failed to get cache for localUserConfigList");
        }
        this.remoteServerConfigList = this.clusterGlobalService.getCache("usermanager.remoteServerConfigList");
        if (this.remoteServerConfigList == null) {
            logger.error("Failed to get cache for remoteServerConfigList");
        }
        this.authorizationConfList = this.clusterGlobalService.getCache("usermanager.authorizationConfList");
        if (this.authorizationConfList == null) {
            logger.error("Failed to get cache for authorizationConfList");
        }
    }

    private void loadConfigurations() {
        this.loadSecurityKeys();
        this.loadUserConfig();
        this.loadServerConfig();
        this.loadAuthConfig();
    }

    private void loadSecurityKeys() {
    }

    private void checkDefaultNetworkAdmin() {
        if (!this.localUserConfigList.containsKey("admin")) {
            ArrayList<String> roles = new ArrayList<String>(1);
            roles.add(DEFAULT_ADMIN_ROLE);
            UserConfig defaultAdmin = UserConfig.getUncheckedUserConfig((String)"admin", (String)"admin", roles);
            this.localUserConfigList.put("admin", defaultAdmin);
        }
    }

    private void checkPasswordRecovery() {
        String fileDescription = "Default Network Administrator password recovery file";
        try {
            FileInputStream fis = new FileInputStream(RECOVERY_FILE);
            this.localUserConfigList.remove("admin");
            logger.info("Default Network Administrator password has been reset to factory default.");
            logger.info("Please change the default Network Administrator password as soon as possible");
            File filePointer = new File(RECOVERY_FILE);
            boolean status = filePointer.delete();
            if (!status) {
                logger.warn("Failed to delete {}", (Object)"Default Network Administrator password recovery file");
            } else {
                logger.trace("{} deleted", (Object)"Default Network Administrator password recovery file");
            }
            fis.close();
        }
        catch (FileNotFoundException fnf) {
            logger.trace("{} not present", (Object)"Default Network Administrator password recovery file");
        }
        catch (IOException e) {
            logger.warn("Failed to close file stream for {}", (Object)"Default Network Administrator password recovery file");
        }
    }

    public AuthResultEnum authenticate(String userName, String password) {
        AuthResponse rcResponse = null;
        boolean remotelyAuthenticated = false;
        boolean authorizationInfoIsPresent = false;
        boolean authorized = false;
        for (ServerConfig aaaServer : this.remoteServerConfigList.values()) {
            String protocol = aaaServer.getProtocol();
            IAAAProvider aaaClient = this.getAAAProvider(protocol);
            if (aaaClient == null) continue;
            rcResponse = aaaClient.authService(userName, password, aaaServer.getAddress(), aaaServer.getSecret());
            if (rcResponse.getStatus() == AuthResultEnum.AUTH_ACCEPT) {
                logger.trace("Remote Authentication Succeeded for User: \"{}\", by Server: {}", (Object)userName, (Object)aaaServer.getAddress());
                remotelyAuthenticated = true;
                break;
            }
            if (rcResponse.getStatus() == AuthResultEnum.AUTH_REJECT) {
                logger.trace("Remote Authentication Rejected User: \"{}\", from Server: {}, Reason:{}", new Object[]{userName, aaaServer.getAddress(), rcResponse.getStatus().toString()});
                continue;
            }
            logger.trace("Remote Authentication Failed for User: \"{}\", from Server: {}, Reason:{}", new Object[]{userName, aaaServer.getAddress(), rcResponse.getStatus().toString()});
        }
        if (!remotelyAuthenticated) {
            UserConfig localUser = (UserConfig)this.localUserConfigList.get(userName);
            if (localUser == null) {
                logger.info("Local Authentication Failed for User:\"{}\", Reason: user not found in Local Database", (Object)userName);
                return AuthResultEnum.AUTH_INVALID_LOC_USER;
            }
            rcResponse = localUser.authenticate(password);
            if (rcResponse.getStatus() != AuthResultEnum.AUTH_ACCEPT_LOC) {
                logger.info("Local Authentication Failed for User: \"{}\", Reason: {}", (Object)userName, (Object)rcResponse.getStatus().toString());
                return rcResponse.getStatus();
            }
            logger.info("Local Authentication Succeeded for User: \"{}\"", (Object)userName);
        }
        AuthenticatedUser result = new AuthenticatedUser(userName);
        String attributes = rcResponse.getData() != null && !rcResponse.getData().isEmpty() ? (String)rcResponse.getData().get(0) : null;
        authorizationInfoIsPresent = this.checkAuthorizationInfo(attributes);
        if (remotelyAuthenticated && !authorizationInfoIsPresent) {
            logger.info("No Remote Authorization Info provided by Server for User: \"{}\"", (Object)userName);
            logger.info("Looking for Local Authorization Info for User: \"{}\"", (Object)userName);
            AuthorizationConfig resource = (AuthorizationConfig)this.authorizationConfList.get(userName);
            if (resource != null) {
                logger.info("Found Local Authorization Info for User: \"{}\"", (Object)userName);
                attributes = resource.getRolesString();
            }
            authorizationInfoIsPresent = this.checkAuthorizationInfo(attributes);
        }
        if (authorizationInfoIsPresent) {
            result.setRoleList(attributes.split(" "));
            authorized = true;
        } else {
            logger.info("Not able to find Authorization Info for User: \"{}\"", (Object)userName);
        }
        this.putUserInActiveList(userName, result);
        if (authorized) {
            logger.info("User \"{}\" authorized for the following role(s): {}", (Object)userName, (Object)result.getUserRoles());
        } else {
            logger.info("User \"{}\" Not Authorized for any role ", (Object)userName);
        }
        return rcResponse.getStatus();
    }

    private boolean checkAuthorizationInfo(String attributes) {
        return attributes != null && !attributes.isEmpty();
    }

    private void putUserInActiveList(String user, AuthenticatedUser result) {
        this.activeUsers.put(user, result);
    }

    private void removeUserFromActiveList(String user) {
        if (!this.activeUsers.containsKey(user)) {
            return;
        }
        this.activeUsers.remove(user);
    }

    public Status saveLocalUserList() {
        return this.saveLocalUserListInternal();
    }

    private Status saveLocalUserListInternal() {
        return this.configurationService.persistConfiguration(new ArrayList(this.localUserConfigList.values()), USERS_FILE_NAME);
    }

    public Status saveAAAServerList() {
        return this.saveAAAServerListInternal();
    }

    private Status saveAAAServerListInternal() {
        return this.configurationService.persistConfiguration(new ArrayList(this.remoteServerConfigList.values()), SERVERS_FILE_NAME);
    }

    public Status saveAuthorizationList() {
        return this.saveAuthorizationListInternal();
    }

    private Status saveAuthorizationListInternal() {
        return this.configurationService.persistConfiguration(new ArrayList(this.authorizationConfList.values()), AUTH_FILE_NAME);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    private void loadUserConfig() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, USERS_FILE_NAME)) {
            this.addRemoveLocalUserInternal((UserConfig)conf, false);
        }
    }

    private void loadServerConfig() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, SERVERS_FILE_NAME)) {
            this.addAAAServer((ServerConfig)conf);
        }
    }

    private void loadAuthConfig() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, AUTH_FILE_NAME)) {
            this.addAuthInfo((AuthorizationConfig)conf);
        }
    }

    private Status changeLocalUser(UserConfig AAAconf, Command command) {
        Status validCheck = AAAconf.validate();
        if (!validCheck.isSuccess()) {
            return validCheck;
        }
        String user = AAAconf.getUser();
        if (user.equals("admin")) {
            String msg = String.format("Invalid Request: Default Network Admin  User cannot be %s", command.getPostAction());
            logger.debug(msg);
            return new Status(StatusCode.NOTALLOWED, msg);
        }
        UserConfig currentAAAconf = (UserConfig)this.localUserConfigList.get(user);
        StatusCode statusCode = null;
        String reason = null;
        switch (command) {
            case ADD: {
                if (currentAAAconf == null) break;
                reason = "already present";
                statusCode = StatusCode.CONFLICT;
                break;
            }
            case MODIFY: 
            case REMOVE: {
                if (currentAAAconf != null) break;
                reason = "not found";
                statusCode = StatusCode.NOTFOUND;
                break;
            }
        }
        if (statusCode != null) {
            String action = String.format("Failed to %s user %s: ", command.getAction(), user);
            String msg = String.format("User %s %s in configuration database", user, reason);
            logger.debug(action + msg);
            return new Status(statusCode, msg);
        }
        switch (command) {
            case ADD: {
                return this.addRemoveLocalUserInternal(AAAconf, false);
            }
            case MODIFY: {
                this.addRemoveLocalUserInternal(currentAAAconf, true);
                return this.addRemoveLocalUserInternal(AAAconf, false);
            }
            case REMOVE: {
                return this.addRemoveLocalUserInternal(AAAconf, true);
            }
        }
        return new Status(StatusCode.INTERNALERROR, "Unknown action");
    }

    private Status addRemoveLocalUserInternal(UserConfig AAAconf, boolean delete) {
        if (delete) {
            this.localUserConfigList.remove(AAAconf.getUser());
            this.removeUserFromActiveList(AAAconf.getUser());
        } else {
            this.localUserConfigList.put(AAAconf.getUser(), AAAconf);
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status addRemoveAAAServer(ServerConfig AAAconf, boolean delete) {
        if (!AAAconf.isValid()) {
            String msg = "Invalid Server configuration";
            logger.warn(msg);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        if (delete) {
            this.remoteServerConfigList.remove(AAAconf.getAddress());
        } else {
            this.remoteServerConfigList.put(AAAconf.getAddress(), AAAconf);
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status addRemoveAuthInfo(AuthorizationConfig AAAconf, boolean delete) {
        Status configCheck = AAAconf.validate();
        if (!configCheck.isSuccess()) {
            String msg = "Invalid Authorization configuration: " + configCheck.getDescription();
            logger.warn(msg);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        if (delete) {
            this.authorizationConfList.remove(AAAconf.getUser());
        } else {
            this.authorizationConfList.put(AAAconf.getUser(), AAAconf);
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status addLocalUser(UserConfig AAAconf) {
        return this.changeLocalUser(AAAconf, Command.ADD);
    }

    public Status modifyLocalUser(UserConfig AAAconf) {
        return this.changeLocalUser(AAAconf, Command.MODIFY);
    }

    public Status removeLocalUser(UserConfig AAAconf) {
        return this.changeLocalUser(AAAconf, Command.REMOVE);
    }

    public Status removeLocalUser(String userName) {
        if (userName == null || userName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid user name");
        }
        if (!this.localUserConfigList.containsKey(userName)) {
            return new Status(StatusCode.NOTFOUND, "User does not exist");
        }
        return this.changeLocalUser((UserConfig)this.localUserConfigList.get(userName), Command.REMOVE);
    }

    public Status addAAAServer(ServerConfig AAAconf) {
        return this.addRemoveAAAServer(AAAconf, false);
    }

    public Status removeAAAServer(ServerConfig AAAconf) {
        return this.addRemoveAAAServer(AAAconf, true);
    }

    public Status addAuthInfo(AuthorizationConfig AAAconf) {
        return this.addRemoveAuthInfo(AAAconf, false);
    }

    public Status removeAuthInfo(AuthorizationConfig AAAconf) {
        return this.addRemoveAuthInfo(AAAconf, true);
    }

    public List<UserConfig> getLocalUserList() {
        return new ArrayList<UserConfig>(this.localUserConfigList.values());
    }

    public List<ServerConfig> getAAAServerList() {
        return new ArrayList<ServerConfig>(this.remoteServerConfigList.values());
    }

    public List<AuthorizationConfig> getAuthorizationList() {
        return new ArrayList<AuthorizationConfig>(this.authorizationConfList.values());
    }

    public Status changeLocalUserPassword(String user, String curPassword, String newPassword) {
        UserConfig targetConfigEntry = null;
        targetConfigEntry = (UserConfig)this.localUserConfigList.get(user);
        if (targetConfigEntry == null) {
            return new Status(StatusCode.NOTFOUND, "User not found");
        }
        Status status = targetConfigEntry.update(curPassword, newPassword, null);
        if (!status.isSuccess()) {
            return status;
        }
        this.localUserConfigList.put(user, targetConfigEntry);
        logger.trace("Password changed for User \"{}\"", (Object)user);
        return status;
    }

    public void userLogout(String userName) {
        this.removeUserFromActiveList(userName);
        logger.trace("User \"{}\" logged out", (Object)userName);
    }

    public void userTimedOut(String userName) {
        this.removeUserFromActiveList(userName);
        logger.trace("User \"{}\" timed out", (Object)userName);
    }

    public String getAccessDate(String user) {
        return ((AuthenticatedUser)this.activeUsers.get(user)).getAccessDate();
    }

    public synchronized Map<String, List<String>> getUserLoggedIn() {
        HashMap<String, List<String>> loggedInList = new HashMap<String, List<String>>();
        for (Map.Entry user : this.activeUsers.entrySet()) {
            String userNameShow = (String)user.getKey();
            loggedInList.put(userNameShow, ((AuthenticatedUser)user.getValue()).getUserRoles());
        }
        return loggedInList;
    }

    public void _umAddUser(CommandInterpreter ci) {
        String userName = ci.nextArgument();
        String password = ci.nextArgument();
        String role = ci.nextArgument();
        ArrayList<String> roles = new ArrayList<String>();
        while (role != null) {
            if (!role.trim().isEmpty()) {
                roles.add(role);
            }
            role = ci.nextArgument();
        }
        if (userName == null || userName.trim().isEmpty() || password == null || password.trim().isEmpty() || roles.isEmpty()) {
            ci.println((Object)"Invalid Arguments");
            ci.println((Object)"umAddUser <user_name> <password> <user_role>");
            return;
        }
        ci.print((Object)this.addLocalUser(new UserConfig(userName, password, roles)));
    }

    public void _umRemUser(CommandInterpreter ci) {
        String userName = ci.nextArgument();
        if (userName == null || userName.trim().isEmpty()) {
            ci.println((Object)"Invalid Arguments");
            ci.println((Object)"umRemUser <user_name>");
            return;
        }
        UserConfig target = (UserConfig)this.localUserConfigList.get(userName);
        if (target == null) {
            ci.println((Object)"User not found");
            return;
        }
        ci.println((Object)this.removeLocalUser(target));
    }

    public void _umGetUsers(CommandInterpreter ci) {
        for (UserConfig conf : this.getLocalUserList()) {
            ci.println((Object)(conf.getUser() + " " + conf.getRoles()));
        }
    }

    public void _addAAAServer(CommandInterpreter ci) {
        String server = ci.nextArgument();
        String secret = ci.nextArgument();
        String protocol = ci.nextArgument();
        if (server == null || secret == null || protocol == null) {
            ci.println((Object)"Usage : addAAAServer <server> <secret> <protocol>");
            return;
        }
        ServerConfig s = new ServerConfig(server, secret, protocol);
        this.addAAAServer(s);
    }

    public void _removeAAAServer(CommandInterpreter ci) {
        String server = ci.nextArgument();
        String secret = ci.nextArgument();
        String protocol = ci.nextArgument();
        if (server == null || secret == null || protocol == null) {
            ci.println((Object)"Usage : addAAAServer <server> <secret> <protocol>");
            return;
        }
        ServerConfig s = new ServerConfig(server, secret, protocol);
        this.removeAAAServer(s);
    }

    public void _printAAAServers(CommandInterpreter ci) {
        for (ServerConfig aaaServer : this.remoteServerConfigList.values()) {
            ci.println((Object)(aaaServer.getAddress() + "-" + aaaServer.getProtocol()));
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        return help.toString();
    }

    void setClusterGlobalService(IClusterGlobalServices s) {
        logger.debug("Cluster Service Global set");
        this.clusterGlobalService = s;
    }

    void unsetClusterGlobalService(IClusterGlobalServices s) {
        if (this.clusterGlobalService == s) {
            logger.debug("Cluster Service Global removed!");
            this.clusterGlobalService = null;
        }
    }

    public void setConfigurationService(IConfigurationService service) {
        logger.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationService(IConfigurationService service) {
        logger.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    void unsetContainerAuthClient(IContainerAuthorization s) {
        if (this.containerAuthorizationClient == s) {
            this.containerAuthorizationClient = null;
        }
    }

    void setContainerAuthClient(IContainerAuthorization s) {
        this.containerAuthorizationClient = s;
    }

    void setAppAuthClient(IResourceAuthorization s) {
        this.applicationAuthorizationClients.add(s);
    }

    void unsetAppAuthClient(IResourceAuthorization s) {
        this.applicationAuthorizationClients.remove(s);
    }

    void init() {
    }

    void destroy() {
    }

    void start() {
        this.authProviders = new ConcurrentHashMap<String, IAAAProvider>();
        this.allocateCaches();
        this.retrieveCaches();
        this.loadConfigurations();
        this.checkPasswordRecovery();
        this.checkDefaultNetworkAdmin();
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    void stop() {
    }

    public List<String> getUserRoles(String userName) {
        List roles = null;
        if (userName != null) {
            if (this.activeUsers.containsKey(userName)) {
                roles = ((AuthenticatedUser)this.activeUsers.get(userName)).getUserRoles();
            } else if (this.localUserConfigList.containsKey(userName)) {
                roles = ((UserConfig)this.localUserConfigList.get(userName)).getRoles();
            } else if (this.authorizationConfList.containsKey(userName)) {
                roles = ((AuthorizationConfig)this.authorizationConfList.get(userName)).getRoles();
            }
        }
        return roles == null ? new ArrayList(0) : roles;
    }

    public UserLevel getUserLevel(String username) {
        List<String> rolesNames = this.getUserRoles(username);
        if (rolesNames.isEmpty()) {
            return UserLevel.NOUSER;
        }
        if (rolesNames.contains(UserLevel.SYSTEMADMIN.toString())) {
            return UserLevel.SYSTEMADMIN;
        }
        if (rolesNames.contains(UserLevel.NETWORKADMIN.toString())) {
            return UserLevel.NETWORKADMIN;
        }
        if (rolesNames.contains(UserLevel.NETWORKOPERATOR.toString())) {
            return UserLevel.NETWORKOPERATOR;
        }
        if (this.containerAuthorizationClient != null) {
            for (String roleName : rolesNames) {
                if (!this.containerAuthorizationClient.isApplicationRole(roleName)) continue;
                return UserLevel.CONTAINERUSER;
            }
        }
        if (this.applicationAuthorizationClients != null) {
            for (String roleName : rolesNames) {
                for (IResourceAuthorization client : this.applicationAuthorizationClients) {
                    if (!client.isApplicationRole(roleName)) continue;
                    return UserLevel.APPUSER;
                }
            }
        }
        return UserLevel.NOUSER;
    }

    public List<UserLevel> getUserLevels(String username) {
        List<String> rolesNames = this.getUserRoles(username);
        ArrayList<UserLevel> levels = new ArrayList<UserLevel>();
        if (rolesNames.isEmpty()) {
            return levels;
        }
        if (rolesNames.contains(UserLevel.SYSTEMADMIN.toString())) {
            levels.add(UserLevel.SYSTEMADMIN);
        }
        if (rolesNames.contains(UserLevel.NETWORKADMIN.toString())) {
            levels.add(UserLevel.NETWORKADMIN);
        }
        if (rolesNames.contains(UserLevel.NETWORKOPERATOR.toString())) {
            levels.add(UserLevel.NETWORKOPERATOR);
        }
        if (this.containerAuthorizationClient != null) {
            for (String roleName : rolesNames) {
                if (!this.containerAuthorizationClient.isApplicationRole(roleName)) continue;
                levels.add(UserLevel.CONTAINERUSER);
                break;
            }
        }
        if (this.applicationAuthorizationClients != null) {
            block1: for (String roleName : rolesNames) {
                for (IResourceAuthorization client : this.applicationAuthorizationClients) {
                    if (!client.isApplicationRole(roleName)) continue;
                    levels.add(UserLevel.APPUSER);
                    continue block1;
                }
            }
        }
        return levels;
    }

    public Status saveConfiguration() {
        boolean success = true;
        Status ret = this.saveLocalUserList();
        if (!ret.isSuccess()) {
            success = false;
        }
        if (!(ret = this.saveAAAServerList()).isSuccess()) {
            success = false;
        }
        if (!(ret = this.saveAuthorizationList()).isSuccess()) {
            success = false;
        }
        if (success) {
            return new Status(StatusCode.SUCCESS);
        }
        return new Status(StatusCode.INTERNALERROR, "Failed to save user configurations");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        AuthenticatedUser user = (AuthenticatedUser)this.activeUsers.get(username);
        if (user != null) {
            boolean enabled = true;
            boolean accountNonExpired = true;
            boolean credentialsNonExpired = true;
            boolean accountNonLocked = true;
            return new User(username, ((UserConfig)this.localUserConfigList.get(username)).getPassword(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, (Collection)user.getGrantedAuthorities(this.getUserLevel(username)));
        }
        throw new UsernameNotFoundException("User not found " + username);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public SecurityContextRepository getSecurityContextRepo() {
        return this.securityContextRepo;
    }

    public void setSecurityContextRepo(SecurityContextRepository securityContextRepo) {
        this.securityContextRepo = securityContextRepo;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)((String)authentication.getCredentials())) || StringUtils.isBlank((CharSequence)((String)authentication.getPrincipal()))) {
            throw new BadCredentialsException("Username or credentials did not match");
        }
        AuthResultEnum result = this.authenticate((String)authentication.getPrincipal(), (String)authentication.getCredentials());
        if (result.equals((Object)AuthResultEnum.AUTHOR_PASS) || result.equals((Object)AuthResultEnum.AUTH_ACCEPT_LOC) || result.equals((Object)AuthResultEnum.AUTH_ACCEPT)) {
            AuthenticatedUser user = (AuthenticatedUser)this.activeUsers.get(authentication.getPrincipal().toString());
            if (user == null) {
                throw new AuthenticationServiceException("Authentication Failure");
            }
            authentication = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), (Collection)user.getGrantedAuthorities(this.getUserLevel(authentication.getName())));
            return authentication;
        }
        throw new BadCredentialsException("Username or credentials did not match");
    }

    void setLocalUserConfigList(ConcurrentMap<String, UserConfig> ucl) {
        if (ucl != null) {
            this.localUserConfigList = ucl;
        }
    }

    void setRemoteServerConfigList(ConcurrentMap<String, ServerConfig> scl) {
        if (scl != null) {
            this.remoteServerConfigList = scl;
        }
    }

    void setAuthorizationConfList(ConcurrentMap<String, AuthorizationConfig> acl) {
        if (acl != null) {
            this.authorizationConfList = acl;
        }
    }

    void setActiveUsers(ConcurrentMap<String, AuthenticatedUser> au) {
        if (au != null) {
            this.activeUsers = au;
        }
    }

    void setAuthProviders(ConcurrentMap<String, IAAAProvider> ap) {
        if (ap != null) {
            this.authProviders = ap;
        }
    }

    public ISessionManager getSessionManager() {
        return this.sessionMgr;
    }

    public void setSessionMgr(ISessionManager sessionMgr) {
        this.sessionMgr = sessionMgr;
    }

    public String getPassword(String username) {
        return ((UserConfig)this.localUserConfigList.get(username)).getPassword();
    }

    public boolean isRoleInUse(String role) {
        if (role == null || role.isEmpty()) {
            return false;
        }
        if (role.equals(UserLevel.SYSTEMADMIN.toString()) || role.equals(UserLevel.NETWORKADMIN.toString()) || role.equals(UserLevel.NETWORKOPERATOR.toString())) {
            return true;
        }
        if (this.containerAuthorizationClient != null && this.containerAuthorizationClient.isApplicationRole(role)) {
            return true;
        }
        if (this.applicationAuthorizationClients != null) {
            for (IResourceAuthorization client : this.applicationAuthorizationClients) {
                if (!client.isApplicationRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    protected static enum Command {
        ADD("add", "added"),
        MODIFY("modify", "modified"),
        REMOVE("remove", "removed");

        private String action;
        private String postAction;

        private Command(String action, String postAction) {
            this.action = action;
            this.postAction = postAction;
        }

        public String getAction() {
            return this.action;
        }

        public String getPostAction() {
            return this.postAction;
        }
    }
}

