/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connection.implementation.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.connection.IConnectionListener;
import org.opendaylight.controller.sal.connection.IConnectionService;
import org.opendaylight.controller.sal.connection.IPluginInConnectionService;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService
implements IPluginOutConnectionService,
IConnectionService {
    protected static final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    private IConnectionListener connectionListener;
    private ConcurrentMap<String, IPluginInConnectionService> pluginService = new ConcurrentHashMap<String, IPluginInConnectionService>();

    void setPluginService(Map props, IPluginInConnectionService s) {
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a PluginInConnectionService without any protocolPluginType provided");
        } else {
            this.pluginService.put(type, s);
        }
    }

    void unsetPluginService(Map props, IPluginInConnectionService s) {
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a PluginInConnectionService without any protocolPluginType provided");
        } else if (((IPluginInConnectionService)this.pluginService.get(type)).equals(s)) {
            this.pluginService.remove(type);
        }
    }

    void setListener(IConnectionListener s) {
        this.connectionListener = s;
    }

    void unsetListener(IConnectionListener s) {
        if (this.connectionListener == s) {
            this.connectionListener = null;
        }
    }

    void init() {
    }

    void destroy() {
        this.connectionListener = null;
        if (this.pluginService != null) {
            this.pluginService.clear();
        }
    }

    public boolean isLocal(Node node) {
        if (this.connectionListener == null) {
            return false;
        }
        return this.connectionListener.isLocal(node);
    }

    public ConnectionLocality getLocalityStatus(Node node) {
        if (this.connectionListener == null) {
            return ConnectionLocality.NOT_CONNECTED;
        }
        return this.connectionListener.getLocalityStatus(node);
    }

    public Node connect(String type, String connectionIdentifier, Map<ConnectionConstants, String> params) {
        IPluginInConnectionService s = (IPluginInConnectionService)this.pluginService.get(type);
        if (s != null) {
            return s.connect(connectionIdentifier, params);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node connect(String connectionIdentifier, Map<ConnectionConstants, String> params) {
        ConcurrentMap<String, IPluginInConnectionService> concurrentMap = this.pluginService;
        synchronized (concurrentMap) {
            for (String pluginType : this.pluginService.keySet()) {
                IPluginInConnectionService s = (IPluginInConnectionService)this.pluginService.get(pluginType);
                Node node = s.connect(connectionIdentifier, params);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public Status disconnect(Node node) {
        IPluginInConnectionService s = (IPluginInConnectionService)this.pluginService.get(node.getType());
        if (s != null) {
            return s.disconnect(node);
        }
        return new Status(StatusCode.NOTFOUND);
    }

    public void notifyClusterViewChanged() {
        for (String pluginType : this.pluginService.keySet()) {
            IPluginInConnectionService s = (IPluginInConnectionService)this.pluginService.get(pluginType);
            s.notifyClusterViewChanged();
        }
    }

    public void notifyNodeDisconnectFromMaster(Node node) {
        for (String pluginType : this.pluginService.keySet()) {
            IPluginInConnectionService s = (IPluginInConnectionService)this.pluginService.get(pluginType);
            s.notifyNodeDisconnectFromMaster(node);
        }
    }
}

