/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.validator;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParserBaseListener;
import org.opendaylight.yangtools.yang.validator.BasicValidations;
import org.opendaylight.yangtools.yang.validator.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangModelBasicValidationListener
extends YangParserBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(YangModelBasicValidationListener.class);
    private final DateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final Set<String> uniquePrefixes = Sets.newHashSet();
    private final Set<String> uniqueImports = Sets.newHashSet();
    private final Set<String> uniqueIncludes = Sets.newHashSet();
    private String globalModuleId;
    private static final Set<String> PERMITTED_ORDER_BY_ARGS = Sets.newHashSet((Object[])new String[]{"system", "user"});
    private static final Set<String> PERMITTED_BOOLEAN_ARGS = Sets.newHashSet((Object[])new String[]{"true", "false"});
    private static final Set<String> PERMITTED_STATUS_ARGS = Sets.newHashSet((Object[])new String[]{"current", "deprecated", "obsolete"});

    YangModelBasicValidationListener() {
    }

    @Override
    public void enterModule_stmt(YangParser.Module_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Module_header_stmtsContext.class, true);
        String moduleName = ValidationUtil.getName((ParseTree)ctx);
        BasicValidations.checkOnlyOneModulePresent(moduleName, this.globalModuleId);
        this.globalModuleId = moduleName;
    }

    @Override
    public void enterSubmodule_stmt(YangParser.Submodule_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Submodule_header_stmtsContext.class, true);
        String submoduleName = ValidationUtil.getName((ParseTree)ctx);
        BasicValidations.checkOnlyOneModulePresent(submoduleName, this.globalModuleId);
        this.globalModuleId = submoduleName;
    }

    @Override
    public void enterSubmodule_header_stmts(YangParser.Submodule_header_stmtsContext ctx) {
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Belongs_to_stmtContext.class, true);
        try {
            BasicValidations.checkPresentYangVersion((ParseTree)ctx, ValidationUtil.getRootParentName((ParseTree)ctx));
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
    }

    @Override
    public void enterModule_header_stmts(YangParser.Module_header_stmtsContext ctx) {
        String moduleName = ValidationUtil.getRootParentName((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Namespace_stmtContext.class, true);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Prefix_stmtContext.class, true);
        try {
            BasicValidations.checkPresentYangVersion((ParseTree)ctx, moduleName);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
    }

    @Override
    public void enterRevision_stmt(YangParser.Revision_stmtContext ctx) {
        BasicValidations.checkDateFormat((ParseTree)ctx, this.SIMPLE_DATE_FORMAT);
    }

    @Override
    public void enterBelongs_to_stmt(YangParser.Belongs_to_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Prefix_stmtContext.class, true);
    }

    @Override
    public void enterNamespace_stmt(YangParser.Namespace_stmtContext ctx) {
        String namespaceName = ValidationUtil.getName((ParseTree)ctx);
        String rootParentName = ValidationUtil.getRootParentName((ParseTree)ctx);
        try {
            new URI(namespaceName);
        }
        catch (URISyntaxException e) {
            ValidationUtil.ex(ValidationUtil.f("(In module:%s) Namespace:%s cannot be parsed as URI", rootParentName, namespaceName));
        }
    }

    @Override
    public void enterImport_stmt(YangParser.Import_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkUniquenessInNamespace((ParseTree)ctx, this.uniqueImports);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Prefix_stmtContext.class, true);
    }

    @Override
    public void enterRevision_date_stmt(YangParser.Revision_date_stmtContext ctx) {
        BasicValidations.checkDateFormat((ParseTree)ctx, this.SIMPLE_DATE_FORMAT);
    }

    @Override
    public void enterInclude_stmt(YangParser.Include_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkUniquenessInNamespace((ParseTree)ctx, this.uniqueIncludes);
    }

    @Override
    public void enterYang_version_stmt(YangParser.Yang_version_stmtContext ctx) {
        String version = ValidationUtil.getName((ParseTree)ctx);
        String rootParentName = ValidationUtil.getRootParentName((ParseTree)ctx);
        if (!version.equals("1")) {
            ValidationUtil.ex(ValidationUtil.f("(In (sub)module:%s) Unsupported yang version:%s, supported version:%s", rootParentName, version, "1"));
        }
    }

    @Override
    public void enterPrefix_stmt(YangParser.Prefix_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkUniquenessInNamespace((ParseTree)ctx, this.uniquePrefixes);
    }

    @Override
    public void enterTypedef_stmt(YangParser.Typedef_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Type_stmtContext.class, true);
    }

    @Override
    public void enterType_stmt(YangParser.Type_stmtContext ctx) {
        BasicValidations.checkPrefixedIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterContainer_stmt(YangParser.Container_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterLeaf_stmt(YangParser.Leaf_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Type_stmtContext.class, true);
        BasicValidations.checkNotPresentBoth((ParseTree)ctx, YangParser.Mandatory_stmtContext.class, YangParser.Default_stmtContext.class);
    }

    @Override
    public void enterLeaf_list_stmt(YangParser.Leaf_list_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkPresentChildOfType((ParseTree)ctx, YangParser.Type_stmtContext.class, true);
    }

    @Override
    public void enterOrdered_by_arg(YangParser.Ordered_by_argContext ctx) {
        BasicValidations.checkOnlyPermittedValues((ParseTree)ctx, PERMITTED_ORDER_BY_ARGS);
    }

    @Override
    public void enterList_stmt(YangParser.List_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterKey_stmt(YangParser.Key_stmtContext ctx) {
        BasicValidations.getAndCheckUniqueKeys((ParseTree)ctx);
    }

    @Override
    public void enterUnique_stmt(YangParser.Unique_stmtContext ctx) {
        BasicValidations.getAndCheckUniqueKeys((ParseTree)ctx);
    }

    @Override
    public void enterChoice_stmt(YangParser.Choice_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
        BasicValidations.checkNotPresentBoth((ParseTree)ctx, YangParser.Mandatory_stmtContext.class, YangParser.Default_stmtContext.class);
    }

    @Override
    public void enterCase_stmt(YangParser.Case_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterMandatory_arg(YangParser.Mandatory_argContext ctx) {
        BasicValidations.checkOnlyPermittedValues((ParseTree)ctx, PERMITTED_BOOLEAN_ARGS);
    }

    @Override
    public void enterAnyxml_stmt(YangParser.Anyxml_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterGrouping_stmt(YangParser.Grouping_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterUses_stmt(YangParser.Uses_stmtContext ctx) {
        BasicValidations.checkPrefixedIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterRefine_stmt(YangParser.Refine_stmtContext ctx) {
        BasicValidations.checkSchemaNodeIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterRpc_stmt(YangParser.Rpc_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterNotification_stmt(YangParser.Notification_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterAugment_stmt(YangParser.Augment_stmtContext ctx) {
        BasicValidations.checkSchemaNodeIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterIdentity_stmt(YangParser.Identity_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterBase_stmt(YangParser.Base_stmtContext ctx) {
        BasicValidations.checkPrefixedIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterYin_element_arg(YangParser.Yin_element_argContext ctx) {
        BasicValidations.checkOnlyPermittedValues((ParseTree)ctx, PERMITTED_BOOLEAN_ARGS);
    }

    @Override
    public void enterExtension_stmt(YangParser.Extension_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterArgument_stmt(YangParser.Argument_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterFeature_stmt(YangParser.Feature_stmtContext ctx) {
        BasicValidations.checkIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterIf_feature_stmt(YangParser.If_feature_stmtContext ctx) {
        BasicValidations.checkPrefixedIdentifier((ParseTree)ctx);
    }

    @Override
    public void enterDeviation_stmt(YangParser.Deviation_stmtContext ctx) {
        BasicValidations.checkSchemaNodeIdentifier((ParseTree)ctx);
        HashSet types = Sets.newHashSet();
        types.add(YangParser.Deviate_add_stmtContext.class);
        types.add(YangParser.Deviate_add_stmtContext.class);
        BasicValidations.checkPresentChildOfTypes((ParseTree)ctx, types, false);
    }

    @Override
    public void enterConfig_arg(YangParser.Config_argContext ctx) {
        BasicValidations.checkOnlyPermittedValues((ParseTree)ctx, PERMITTED_BOOLEAN_ARGS);
    }

    @Override
    public void enterStatus_arg(YangParser.Status_argContext ctx) {
        BasicValidations.checkOnlyPermittedValues((ParseTree)ctx, PERMITTED_STATUS_ARGS);
    }
}

