/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.parser.util.ParserListenerUtils;
import org.opendaylight.yangtools.yang.parser.util.YangValidationException;

final class ValidationUtil {
    private ValidationUtil() {
    }

    static void ex(String message) {
        throw new YangValidationException(message);
    }

    static Set<String> getDuplicates(Collection<String> keyList) {
        HashSet<String> all = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (String key : keyList) {
            if (all.add(key)) continue;
            duplicates.add(key);
        }
        return duplicates;
    }

    static List<String> listKeysFromId(String keys) {
        return Arrays.asList(keys.split(" "));
    }

    static String getRootParentName(ParseTree ctx) {
        ParseTree root = ValidationUtil.getRootParent(ctx);
        return ValidationUtil.getName(root);
    }

    private static ParseTree getRootParent(ParseTree ctx) {
        ParseTree root = ctx;
        while (root.getParent() != null && !root.getClass().equals(YangParser.Module_stmtContext.class) && !root.getClass().equals(YangParser.Submodule_stmtContext.class)) {
            root = root.getParent();
        }
        return root;
    }

    static String getName(ParseTree child) {
        return ParserListenerUtils.stringFromNode(child);
    }

    static String f(String base, Object ... args) {
        return String.format(base, args);
    }

    static String getSimpleStatementName(Class<? extends ParseTree> typeOfStatement) {
        String className = typeOfStatement.getSimpleName();
        int lastIndexOf = className.indexOf(36);
        className = lastIndexOf == -1 ? className : className.substring(lastIndexOf + 1);
        int indexOfStmt = className.indexOf("_stmt");
        int index = indexOfStmt == -1 ? className.indexOf("_arg") : indexOfStmt;
        return className.substring(0, index).replace('_', '-');
    }

    static int countPresentChildrenOfType(ParseTree parent, Set<Class<? extends ParseTree>> expectedChildTypes) {
        int foundChildrenOfType = 0;
        for (Class<? extends ParseTree> type : expectedChildTypes) {
            foundChildrenOfType += ValidationUtil.countPresentChildrenOfType(parent, type);
        }
        return foundChildrenOfType;
    }

    static int countPresentChildrenOfType(ParseTree parent, Class<? extends ParseTree> expectedChildType) {
        int foundChildrenOfType = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            ParseTree child = parent.getChild(i);
            if (!expectedChildType.isInstance(child)) continue;
            ++foundChildrenOfType;
        }
        return foundChildrenOfType;
    }
}

