/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.UnknownType;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.TypeConstraints;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static void resolveType(TypeAwareBuilder nodeToResolve, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        int line = nodeToResolve.getLine();
        TypeDefinition<?> nodeToResolveType = nodeToResolve.getType();
        QName unknownTypeQName = nodeToResolveType.getBaseType().getQName();
        ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, unknownTypeQName.getPrefix(), line);
        TypeDefinitionBuilder resolvedType = TypeUtils.findUnknownTypeDefinition(nodeToResolve, dependentModuleBuilder, modules, module);
        nodeToResolve.setTypedef(resolvedType);
    }

    public static void resolveTypeWithContext(TypeAwareBuilder nodeToResolve, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        int line = nodeToResolve.getLine();
        TypeDefinition<?> nodeToResolveType = nodeToResolve.getType();
        QName unknownTypeQName = nodeToResolveType.getBaseType().getQName();
        ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, unknownTypeQName.getPrefix(), line);
        if (dependentModuleBuilder == null) {
            Module dependentModule = ParserUtils.findModuleFromContext(context, module, unknownTypeQName.getPrefix(), line);
            Set types = dependentModule.getTypeDefinitions();
            TypeDefinition<?> type = TypeUtils.findTypeByName(types, unknownTypeQName.getLocalName());
            if (nodeToResolveType instanceof ExtendedType) {
                ExtendedType extType = (ExtendedType)nodeToResolveType;
                TypeDefinitionBuilder newType = TypeUtils.extendedTypeWithNewBase(null, type, extType, modules, module, nodeToResolve.getLine());
                nodeToResolve.setTypedef(newType);
            } else {
                if (nodeToResolve instanceof TypeDefinitionBuilder) {
                    TypeDefinitionBuilder tdb = (TypeDefinitionBuilder)nodeToResolve;
                    TypeConstraints tc = TypeUtils.findConstraintsFromTypeBuilder(nodeToResolve, new TypeConstraints(module.getName(), nodeToResolve.getLine()), modules, module, context);
                    tdb.setLengths(tc.getLength());
                    tdb.setPatterns(tc.getPatterns());
                    tdb.setRanges(tc.getRange());
                    tdb.setFractionDigits(tc.getFractionDigits());
                }
                nodeToResolve.setType(type);
            }
        } else {
            TypeDefinitionBuilder resolvedType = TypeUtils.findUnknownTypeDefinition(nodeToResolve, dependentModuleBuilder, modules, module);
            nodeToResolve.setTypedef(resolvedType);
        }
    }

    public static void resolveTypeUnion(UnionTypeBuilder union, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder builder) {
        List unionTypes = union.getTypes();
        ArrayList toRemove = new ArrayList();
        for (TypeDefinition<?> typeDefinition : unionTypes) {
            if (typeDefinition instanceof UnknownType) {
                ModuleBuilder dependentModule = ParserUtils.findModuleFromBuilders(modules, builder, typeDefinition.getQName().getPrefix(), union.getLine());
                TypeDefinitionBuilder resolvedType = TypeUtils.findTypeDefinitionBuilder(union, dependentModule, typeDefinition.getQName().getLocalName(), builder.getName(), union.getLine());
                union.setTypedef(resolvedType);
                toRemove.add(typeDefinition);
                continue;
            }
            if (!(typeDefinition instanceof ExtendedType) || !(typeDefinition.getBaseType() instanceof UnknownType)) continue;
            UnknownType ut = (UnknownType)typeDefinition.getBaseType();
            ModuleBuilder dependentModule = ParserUtils.findModuleFromBuilders(modules, builder, ut.getQName().getPrefix(), union.getLine());
            TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(union, dependentModule, ut.getQName().getLocalName(), builder.getName(), union.getLine());
            TypeDefinitionBuilder newType = TypeUtils.extendedTypeWithNewBase(targetTypeBuilder, null, (ExtendedType)typeDefinition, modules, builder, union.getLine());
            union.setTypedef(newType);
            toRemove.add(typeDefinition);
        }
        unionTypes.removeAll(toRemove);
    }

    public static void resolveTypeUnionWithContext(UnionTypeBuilder union, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        List unionTypes = union.getTypes();
        ArrayList toRemove = new ArrayList();
        for (TypeDefinition<?> typeDefinition : unionTypes) {
            if (typeDefinition instanceof UnknownType) {
                TypeUtils.resolveUnionUnknownType(union, (UnknownType)typeDefinition, modules, module, context);
                toRemove.add(typeDefinition);
                continue;
            }
            if (!(typeDefinition instanceof ExtendedType) || !(typeDefinition.getBaseType() instanceof UnknownType)) continue;
            TypeUtils.resolveUnionUnknownType(union, (ExtendedType)typeDefinition, modules, module, context);
            toRemove.add(typeDefinition);
        }
        unionTypes.removeAll(toRemove);
    }

    private static void resolveUnionUnknownType(UnionTypeBuilder union, UnknownType ut, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        int line = union.getLine();
        QName utQName = ut.getQName();
        ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, utQName.getPrefix(), line);
        if (dependentModuleBuilder == null) {
            Module dependentModule = ParserUtils.findModuleFromContext(context, module, utQName.getPrefix(), line);
            Set types = dependentModule.getTypeDefinitions();
            TypeDefinition<?> type = TypeUtils.findTypeByName(types, utQName.getLocalName());
            union.setType(type);
        } else {
            TypeDefinitionBuilder resolvedType = TypeUtils.findTypeDefinitionBuilder(union, dependentModuleBuilder, utQName.getLocalName(), module.getName(), union.getLine());
            union.setTypedef(resolvedType);
        }
    }

    private static void resolveUnionUnknownType(UnionTypeBuilder union, ExtendedType extType, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        int line = union.getLine();
        TypeDefinition extTypeBase = extType.getBaseType();
        UnknownType ut = (UnknownType)extTypeBase;
        QName utQName = ut.getQName();
        ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, utQName.getPrefix(), line);
        if (dependentModuleBuilder == null) {
            Module dependentModule = ParserUtils.findModuleFromContext(context, module, utQName.getPrefix(), line);
            Set types = dependentModule.getTypeDefinitions();
            TypeDefinition<?> type = TypeUtils.findTypeByName(types, utQName.getLocalName());
            TypeDefinitionBuilder newType = TypeUtils.extendedTypeWithNewBase(null, type, extType, modules, module, 0);
            union.setTypedef(newType);
        } else {
            TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(union, dependentModuleBuilder, utQName.getLocalName(), module.getName(), line);
            TypeDefinitionBuilder newType = TypeUtils.extendedTypeWithNewBase(targetTypeBuilder, null, extType, modules, module, line);
            union.setTypedef(newType);
        }
    }

    private static TypeDefinitionBuilder findUnknownTypeDefinition(TypeAwareBuilder nodeToResolve, ModuleBuilder dependentModuleBuilder, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        TypeDefinitionBuilder resolvedType;
        int line = nodeToResolve.getLine();
        TypeDefinition<?> nodeToResolveType = nodeToResolve.getType();
        QName unknownTypeQName = nodeToResolveType.getBaseType().getQName();
        TypeDefinitionBuilder targetTypeBuilder = TypeUtils.findTypeDefinitionBuilder(nodeToResolve, dependentModuleBuilder, unknownTypeQName.getLocalName(), module.getName(), line);
        if (nodeToResolveType instanceof ExtendedType) {
            ExtendedType extType = (ExtendedType)nodeToResolveType;
            resolvedType = TypeUtils.extendedTypeWithNewBase(targetTypeBuilder, null, extType, modules, module, nodeToResolve.getLine());
        } else {
            resolvedType = targetTypeBuilder;
        }
        TypeConstraints constraints = TypeUtils.findConstraintsFromTypeBuilder(nodeToResolve, new TypeConstraints(module.getName(), nodeToResolve.getLine()), modules, module, null);
        constraints.validateConstraints();
        return resolvedType;
    }

    private static TypeDefinitionBuilder findTypedefBuilderByName(Set<TypeDefinitionBuilder> types, String name) {
        for (TypeDefinitionBuilder td : types) {
            if (!td.getQName().getLocalName().equals(name)) continue;
            return td;
        }
        return null;
    }

    private static TypeDefinition<?> findTypeByName(Set<TypeDefinition<?>> types, String typeName) {
        for (TypeDefinition<?> type : types) {
            if (!type.getQName().getLocalName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    private static TypeConstraints mergeConstraints(TypeDefinition<?> type, TypeConstraints constraints) {
        if (type instanceof DecimalTypeDefinition) {
            constraints.addRanges(((DecimalTypeDefinition)type).getRangeConstraints());
            constraints.addFractionDigits(((DecimalTypeDefinition)type).getFractionDigits());
        } else if (type instanceof IntegerTypeDefinition) {
            constraints.addRanges(((IntegerTypeDefinition)type).getRangeConstraints());
        } else if (type instanceof UnsignedIntegerTypeDefinition) {
            constraints.addRanges(((UnsignedIntegerTypeDefinition)type).getRangeConstraints());
        } else if (type instanceof StringTypeDefinition) {
            constraints.addPatterns(((StringTypeDefinition)type).getPatternConstraints());
            constraints.addLengths(((StringTypeDefinition)type).getLengthConstraints());
        } else if (type instanceof BinaryTypeDefinition) {
            constraints.addLengths(((BinaryTypeDefinition)type).getLengthConstraints());
        } else if (type instanceof ExtendedType) {
            constraints.addFractionDigits(((ExtendedType)type).getFractionDigits());
            constraints.addLengths(((ExtendedType)type).getLengthConstraints());
            constraints.addPatterns(((ExtendedType)type).getPatternConstraints());
            constraints.addRanges(((ExtendedType)type).getRangeConstraints());
        }
        return constraints;
    }

    private static TypeDefinitionBuilder extendedTypeWithNewBase(TypeDefinitionBuilder newBaseTypeBuilder, TypeDefinition<?> newBaseType, ExtendedType oldExtendedType, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, int line) {
        TypeConstraints constraints;
        if (newBaseTypeBuilder == null && newBaseType == null || newBaseTypeBuilder != null && newBaseType != null) {
            throw new YangParseException(module.getName(), line, "only one of newBaseTypeBuilder or newBaseType can be specified");
        }
        TypeDefinitionBuilderImpl newType = new TypeDefinitionBuilderImpl(module.getModuleName(), line, oldExtendedType.getQName(), oldExtendedType.getPath());
        TypeConstraints tc = new TypeConstraints(module.getName(), line);
        if (newBaseType == null) {
            tc.addFractionDigits(oldExtendedType.getFractionDigits());
            tc.addLengths(oldExtendedType.getLengthConstraints());
            tc.addPatterns(oldExtendedType.getPatternConstraints());
            tc.addRanges(oldExtendedType.getRangeConstraints());
            constraints = TypeUtils.findConstraintsFromTypeBuilder(newBaseTypeBuilder, tc, modules, module, null);
            newType.setTypedef(newBaseTypeBuilder);
        } else {
            constraints = TypeUtils.findConstraintsFromTypeDefinition(newBaseType, tc);
            newType.setType(newBaseType);
        }
        newType.setDescription(oldExtendedType.getDescription());
        newType.setReference(oldExtendedType.getReference());
        newType.setStatus(oldExtendedType.getStatus());
        newType.setLengths(constraints.getLength());
        newType.setPatterns(constraints.getPatterns());
        newType.setRanges(constraints.getRange());
        newType.setFractionDigits(constraints.getFractionDigits());
        newType.setUnits(oldExtendedType.getUnits());
        newType.setDefaultValue(oldExtendedType.getDefaultValue());
        return newType;
    }

    private static TypeConstraints findConstraintsFromTypeDefinition(TypeDefinition<?> typeToResolve, TypeConstraints constraints) {
        if (typeToResolve instanceof UnionTypeDefinition) {
            return constraints;
        }
        if (typeToResolve instanceof ExtendedType) {
            ExtendedType extType = (ExtendedType)typeToResolve;
            constraints.addFractionDigits(extType.getFractionDigits());
            constraints.addLengths(extType.getLengthConstraints());
            constraints.addPatterns(extType.getPatternConstraints());
            constraints.addRanges(extType.getRangeConstraints());
            return TypeUtils.findConstraintsFromTypeDefinition(extType.getBaseType(), constraints);
        }
        TypeUtils.mergeConstraints(typeToResolve, constraints);
        return constraints;
    }

    private static TypeConstraints findConstraintsFromTypeBuilder(TypeAwareBuilder nodeToResolve, TypeConstraints constraints, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder builder, SchemaContext context) {
        TypeDefinition<?> type;
        if (nodeToResolve instanceof UnionTypeBuilder || nodeToResolve instanceof IdentityrefTypeBuilder) {
            return constraints;
        }
        if (nodeToResolve instanceof TypeDefinitionBuilder) {
            TypeDefinitionBuilder typedefToResolve = (TypeDefinitionBuilder)nodeToResolve;
            constraints.addFractionDigits(typedefToResolve.getFractionDigits());
            constraints.addLengths(typedefToResolve.getLengths());
            constraints.addPatterns(typedefToResolve.getPatterns());
            constraints.addRanges(typedefToResolve.getRanges());
        }
        if ((type = nodeToResolve.getType()) == null) {
            return TypeUtils.findConstraintsFromTypeBuilder(nodeToResolve.getTypedef(), constraints, modules, builder, context);
        }
        QName qname = type.getQName();
        if (type instanceof UnknownType) {
            ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, builder, qname.getPrefix(), nodeToResolve.getLine());
            if (dependentModuleBuilder == null) {
                if (context == null) {
                    throw new YangParseException(builder.getName(), nodeToResolve.getLine(), "Failed to resolved type constraints.");
                }
                Module dm = ParserUtils.findModuleFromContext(context, builder, qname.getPrefix(), nodeToResolve.getLine());
                TypeDefinition<?> t = TypeUtils.findTypeByName(dm.getTypeDefinitions(), qname.getLocalName());
                return TypeUtils.mergeConstraints(t, constraints);
            }
            TypeDefinitionBuilder tdb = TypeUtils.findTypeDefinitionBuilder(nodeToResolve, dependentModuleBuilder, qname.getLocalName(), builder.getName(), nodeToResolve.getLine());
            return TypeUtils.findConstraintsFromTypeBuilder(tdb, constraints, modules, dependentModuleBuilder, context);
        }
        if (type instanceof ExtendedType) {
            TypeUtils.mergeConstraints(type, constraints);
            TypeDefinition base = ((ExtendedType)type).getBaseType();
            if (base instanceof UnknownType) {
                ModuleBuilder dependentModule = ParserUtils.findModuleFromBuilders(modules, builder, base.getQName().getPrefix(), nodeToResolve.getLine());
                TypeDefinitionBuilder tdb = TypeUtils.findTypeDefinitionBuilder(nodeToResolve, dependentModule, base.getQName().getLocalName(), builder.getName(), nodeToResolve.getLine());
                return TypeUtils.findConstraintsFromTypeBuilder(tdb, constraints, modules, dependentModule, context);
            }
            return TypeUtils.mergeConstraints(type, constraints);
        }
        return TypeUtils.mergeConstraints(type, constraints);
    }

    private static TypeDefinitionBuilder findTypeDefinitionBuilder(TypeAwareBuilder nodeToResolve, ModuleBuilder dependentModule, String typeName, String currentModuleName, int line) {
        Set<TypeDefinitionBuilder> typedefs = dependentModule.getTypeDefinitionBuilders();
        TypeDefinitionBuilder result = TypeUtils.findTypedefBuilderByName(typedefs, typeName);
        if (result != null) {
            return result;
        }
        for (Builder parent = nodeToResolve.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof DataNodeContainerBuilder) {
                typedefs = ((DataNodeContainerBuilder)parent).getTypeDefinitionBuilders();
            } else if (parent instanceof RpcDefinitionBuilder) {
                typedefs = ((RpcDefinitionBuilder)parent).getTypeDefinitions();
            }
            result = TypeUtils.findTypedefBuilderByName(typedefs, typeName);
            if (result != null) break;
        }
        if (result == null) {
            throw new YangParseException(currentModuleName, line, "Referenced type '" + typeName + "' not found.");
        }
        return result;
    }
}

