/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;
import org.opendaylight.yangtools.yang.parser.util.UnknownBoundaryNumber;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class TypeConstraints {
    private final String moduleName;
    private final int line;
    private final List<List<RangeConstraint>> ranges = new ArrayList<List<RangeConstraint>>();
    private final List<List<LengthConstraint>> lengths = new ArrayList<List<LengthConstraint>>();
    private final List<List<PatternConstraint>> patterns = new ArrayList<List<PatternConstraint>>();
    private final List<Integer> fractionDigits = new ArrayList<Integer>();

    public TypeConstraints(String moduleName, int line) {
        this.moduleName = moduleName;
        this.line = line;
    }

    public List<RangeConstraint> getRange() {
        if (this.ranges.size() < 2) {
            return Collections.emptyList();
        }
        List<RangeConstraint> resolved = this.ranges.get(0);
        RangeConstraint firstRange = resolved.get(0);
        RangeConstraint lastRange = resolved.get(resolved.size() - 1);
        Number min = firstRange.getMin();
        Number max = lastRange.getMax();
        if (!(min instanceof UnknownBoundaryNumber) && !(max instanceof UnknownBoundaryNumber)) {
            if (this.ranges.size() > 1) {
                this.validateRange(resolved);
            }
            return resolved;
        }
        if (firstRange.equals(lastRange)) {
            if (min instanceof UnknownBoundaryNumber) {
                min = this.resolveMinRange(min);
            }
            if (max instanceof UnknownBoundaryNumber) {
                max = this.resolveMaxRange(max);
            }
            firstRange = BaseConstraints.rangeConstraint((Number)min, (Number)max, (String)firstRange.getDescription(), (String)firstRange.getReference());
            resolved.set(0, firstRange);
            lastRange = BaseConstraints.rangeConstraint((Number)min, (Number)max, (String)lastRange.getDescription(), (String)lastRange.getReference());
            resolved.set(resolved.size() - 1, lastRange);
        } else {
            if (min instanceof UnknownBoundaryNumber) {
                min = this.resolveMinRange(min);
                firstRange = BaseConstraints.rangeConstraint((Number)min, (Number)firstRange.getMax(), (String)firstRange.getDescription(), (String)firstRange.getReference());
                resolved.set(0, firstRange);
            }
            if (max instanceof UnknownBoundaryNumber) {
                max = this.resolveMaxRange(max);
                lastRange = BaseConstraints.rangeConstraint((Number)lastRange.getMin(), (Number)max, (String)lastRange.getDescription(), (String)lastRange.getReference());
                resolved.set(resolved.size() - 1, lastRange);
            }
        }
        if (this.ranges.size() > 1) {
            this.validateRange(resolved);
        }
        return resolved;
    }

    private Number resolveMinRange(Number min) {
        int i = 1;
        Number newMin = min;
        while (newMin instanceof UnknownBoundaryNumber) {
            List<RangeConstraint> act = this.ranges.get(i);
            newMin = act.get(0).getMin();
            ++i;
        }
        return newMin;
    }

    private Number resolveMaxRange(Number max) {
        int i = 1;
        Number newMax = max;
        while (newMax instanceof UnknownBoundaryNumber) {
            List<RangeConstraint> act = this.ranges.get(i);
            newMax = act.get(act.size() - 1).getMax();
            ++i;
        }
        return newMax;
    }

    public void addRanges(List<RangeConstraint> ranges) {
        if (ranges != null && !ranges.isEmpty()) {
            this.ranges.add(ranges);
        }
    }

    public List<List<LengthConstraint>> getAllLengths() {
        return this.lengths;
    }

    public List<LengthConstraint> getLength() {
        if (this.lengths.size() < 2) {
            return Collections.emptyList();
        }
        List<LengthConstraint> resolved = this.lengths.get(0);
        LengthConstraint firstLength = resolved.get(0);
        LengthConstraint lastLength = resolved.get(resolved.size() - 1);
        Number min = firstLength.getMin();
        Number max = lastLength.getMax();
        if (!(min instanceof UnknownBoundaryNumber) && !(max instanceof UnknownBoundaryNumber)) {
            if (this.lengths.size() > 1) {
                this.validateLength(resolved);
            }
            return resolved;
        }
        if (firstLength.equals(lastLength)) {
            if (min instanceof UnknownBoundaryNumber) {
                min = this.resolveMinLength(min);
            }
            if (max instanceof UnknownBoundaryNumber) {
                max = this.resolveMaxLength(max);
            }
            firstLength = BaseConstraints.lengthConstraint((Number)min, (Number)max, (String)firstLength.getDescription(), (String)firstLength.getReference());
            resolved.set(0, firstLength);
            lastLength = BaseConstraints.lengthConstraint((Number)min, (Number)max, (String)lastLength.getDescription(), (String)lastLength.getReference());
            resolved.set(resolved.size() - 1, lastLength);
        } else {
            if (min instanceof UnknownBoundaryNumber) {
                min = this.resolveMinLength(min);
                firstLength = BaseConstraints.lengthConstraint((Number)min, (Number)firstLength.getMax(), (String)firstLength.getDescription(), (String)firstLength.getReference());
                resolved.set(0, firstLength);
            }
            if (max instanceof UnknownBoundaryNumber) {
                max = this.resolveMaxLength(max);
                lastLength = BaseConstraints.lengthConstraint((Number)lastLength.getMin(), (Number)max, (String)lastLength.getDescription(), (String)lastLength.getReference());
                resolved.set(resolved.size() - 1, lastLength);
            }
        }
        if (this.lengths.size() > 1) {
            this.validateLength(resolved);
        }
        return resolved;
    }

    private Number resolveMinLength(Number min) {
        int i = 1;
        Number newMin = min;
        while (newMin instanceof UnknownBoundaryNumber) {
            List<LengthConstraint> act = this.lengths.get(i);
            newMin = act.get(0).getMin();
            ++i;
        }
        return newMin;
    }

    private Number resolveMaxLength(Number max) {
        int i = 1;
        Number newMax = max;
        while (newMax instanceof UnknownBoundaryNumber) {
            List<LengthConstraint> act = this.lengths.get(i);
            newMax = act.get(act.size() - 1).getMax();
            ++i;
        }
        return newMax;
    }

    public void addLengths(List<LengthConstraint> lengths) {
        if (lengths != null && !lengths.isEmpty()) {
            this.lengths.add(lengths);
        }
    }

    public List<PatternConstraint> getPatterns() {
        if (this.patterns.isEmpty()) {
            return Collections.emptyList();
        }
        return this.patterns.get(0);
    }

    public void addPatterns(List<PatternConstraint> patterns) {
        this.patterns.add(patterns);
    }

    public Integer getFractionDigits() {
        if (this.fractionDigits.isEmpty()) {
            return null;
        }
        return this.fractionDigits.get(0);
    }

    public void addFractionDigits(Integer fractionDigits) {
        this.fractionDigits.add(fractionDigits);
    }

    public void validateConstraints() {
        this.validateLength();
        this.validateRange();
    }

    private void validateRange() {
        this.validateRange(this.getRange());
    }

    private void validateRange(List<RangeConstraint> typeRange) {
        if (this.ranges.size() < 2) {
            return;
        }
        for (RangeConstraint range : typeRange) {
            if (range.getMin() instanceof UnknownBoundaryNumber || range.getMax() instanceof UnknownBoundaryNumber) {
                throw new YangParseException(this.moduleName, this.line, "Unresolved range constraints");
            }
            BigDecimal min = new BigDecimal(range.getMin().toString());
            BigDecimal max = new BigDecimal(range.getMax().toString());
            List<RangeConstraint> parentRanges = this.ranges.get(1);
            if (this.areRangesSubintervalsOfParentRanges(parentRanges, min, max)) continue;
            throw new YangParseException(this.moduleName, this.line, "Invalid range constraint: <" + min + ", " + max + "> (parent: " + parentRanges + ").");
        }
    }

    private boolean areRangesSubintervalsOfParentRanges(List<RangeConstraint> parentRanges, BigDecimal min, BigDecimal max) {
        boolean check = false;
        for (RangeConstraint r : parentRanges) {
            Number parentMinNumber = r.getMin();
            if (parentMinNumber instanceof UnknownBoundaryNumber) {
                parentMinNumber = this.resolveMinRange(parentMinNumber);
            }
            BigDecimal parentMin = new BigDecimal(parentMinNumber.toString());
            Number parentMaxNumber = r.getMax();
            if (parentMaxNumber instanceof UnknownBoundaryNumber) {
                parentMaxNumber = this.resolveMaxRange(parentMaxNumber);
            }
            BigDecimal parentMax = new BigDecimal(parentMaxNumber.toString());
            if (parentMin.compareTo(min) > 0 || parentMax.compareTo(max) < 0) continue;
            check = true;
            break;
        }
        return check;
    }

    private void validateLength() {
        this.validateLength(this.getLength());
    }

    private void validateLength(List<LengthConstraint> typeLength) {
        if (this.lengths.size() < 2) {
            return;
        }
        for (LengthConstraint length : typeLength) {
            if (length.getMin() instanceof UnknownBoundaryNumber || length.getMax() instanceof UnknownBoundaryNumber) {
                throw new YangParseException(this.moduleName, this.line, "Unresolved length constraints");
            }
            long min = length.getMin().longValue();
            long max = length.getMax().longValue();
            List<LengthConstraint> parentLengths = this.lengths.get(1);
            if (this.areLengthRangesSubintervalsOfParentLengthRanges(parentLengths, min, max)) continue;
            throw new YangParseException(this.moduleName, this.line, "Invalid length constraint: <" + min + ", " + max + "> (parent: " + parentLengths + ").");
        }
    }

    private boolean areLengthRangesSubintervalsOfParentLengthRanges(List<LengthConstraint> parentLengths, long min, long max) {
        boolean check = false;
        for (LengthConstraint lc : parentLengths) {
            Number parentMinNumber = lc.getMin();
            if (parentMinNumber instanceof UnknownBoundaryNumber) {
                parentMinNumber = this.resolveMinLength(parentMinNumber);
            }
            long parentMin = parentMinNumber.longValue();
            Number parentMaxNumber = lc.getMax();
            if (parentMaxNumber instanceof UnknownBoundaryNumber) {
                parentMaxNumber = this.resolveMaxLength(parentMaxNumber);
            }
            long parentMax = parentMaxNumber.longValue();
            if (parentMin > min || parentMax < max) continue;
            check = true;
            break;
        }
        return check;
    }
}

