/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TopologicalSort {
    private TopologicalSort() {
    }

    public static List<Node> sort(Set<Node> nodes) {
        ArrayList sortedNodes = Lists.newArrayList();
        Set<Node> dependentNodes = TopologicalSort.getDependentNodes(nodes);
        while (!dependentNodes.isEmpty()) {
            Node n = dependentNodes.iterator().next();
            dependentNodes.remove(n);
            sortedNodes.add(n);
            for (Edge e : n.getInEdges()) {
                Node m = e.getFrom();
                m.getOutEdges().remove(e);
                if (!m.getOutEdges().isEmpty()) continue;
                dependentNodes.add(m);
            }
        }
        TopologicalSort.detectCycles(nodes);
        return sortedNodes;
    }

    private static Set<Node> getDependentNodes(Set<Node> nodes) {
        HashSet dependentNodes = Sets.newHashSet();
        for (Node n : nodes) {
            if (n.getOutEdges().size() != 0) continue;
            dependentNodes.add(n);
        }
        return dependentNodes;
    }

    private static void detectCycles(Set<Node> nodes) {
        boolean cycle = false;
        Node cycledNode = null;
        for (Node n : nodes) {
            if (n.getOutEdges().isEmpty()) continue;
            cycle = true;
            cycledNode = n;
            break;
        }
        Preconditions.checkState((!cycle ? 1 : 0) != 0, (Object)("Cycle detected in graph around node: " + cycledNode));
    }

    public static class EdgeImpl
    implements Edge {
        private final Node from;
        private final Node to;

        @Override
        public Node getFrom() {
            return this.from;
        }

        @Override
        public Node getTo() {
            return this.to;
        }

        public EdgeImpl(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeImpl other = (EdgeImpl)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }

    public static class NodeImpl
    implements Node {
        private final Set<Edge> inEdges = Sets.newHashSet();
        private final Set<Edge> outEdges = Sets.newHashSet();

        @Override
        public Set<Edge> getInEdges() {
            return this.inEdges;
        }

        @Override
        public Set<Edge> getOutEdges() {
            return this.outEdges;
        }

        public void addEdge(Node to) {
            EdgeImpl e = new EdgeImpl(this, to);
            this.outEdges.add(e);
            to.getInEdges().add(e);
        }
    }

    public static interface Edge {
        public Node getFrom();

        public Node getTo();
    }

    public static interface Node {
        public Set<Edge> getInEdges();

        public Set<Edge> getOutEdges();
    }
}

