/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import java.lang.reflect.Method;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class RefineUtils {
    private RefineUtils() {
    }

    public static void refineLeaf(LeafSchemaNodeBuilder leaf, RefineHolder refine) {
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (defaultStr != null && !"".equals(defaultStr)) {
            leaf.setDefaultStr(defaultStr);
        }
        if (mandatory != null) {
            leaf.getConstraints().setMandatory(mandatory);
        }
        if (must != null) {
            leaf.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(leaf);
                leaf.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineContainer(ContainerSchemaNodeBuilder container, RefineHolder refine) {
        Boolean presence = refine.isPresence();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (presence != null) {
            container.setPresence(presence);
        }
        if (must != null) {
            container.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(container);
                container.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineList(ListSchemaNodeBuilder list, RefineHolder refine) {
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (must != null) {
            list.getConstraints().addMustDefinition(must);
        }
        if (min != null) {
            list.getConstraints().setMinElements(min);
        }
        if (max != null) {
            list.getConstraints().setMaxElements(max);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(list);
                list.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineLeafList(LeafListSchemaNodeBuilder leafList, RefineHolder refine) {
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (must != null) {
            leafList.getConstraints().addMustDefinition(must);
        }
        if (min != null) {
            leafList.getConstraints().setMinElements(min);
        }
        if (max != null) {
            leafList.getConstraints().setMaxElements(max);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(leafList);
                leafList.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineChoice(ChoiceBuilder choice, RefineHolder refine) {
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (defaultStr != null) {
            choice.setDefaultCase(defaultStr);
        }
        if (mandatory != null) {
            choice.getConstraints().setMandatory(mandatory);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(choice);
                choice.addUnknownNodeBuilder(unknown);
            }
        }
    }

    public static void refineAnyxml(AnyXmlBuilder anyXml, RefineHolder refine) {
        Boolean mandatory = refine.isMandatory();
        MustDefinition must = refine.getMust();
        List<UnknownSchemaNodeBuilder> unknownNodes = refine.getUnknownNodes();
        if (mandatory != null) {
            anyXml.getConstraints().setMandatory(mandatory);
        }
        if (must != null) {
            anyXml.getConstraints().addMustDefinition(must);
        }
        if (unknownNodes != null) {
            for (UnknownSchemaNodeBuilder unknown : unknownNodes) {
                unknown.setParent(anyXml);
                anyXml.addUnknownNodeBuilder(unknown);
            }
        }
    }

    private static void checkRefine(SchemaNodeBuilder node, RefineHolder refine) {
        String moduleName = refine.getModuleName();
        int line = refine.getLine();
        String name = node.getQName().getLocalName();
        String defaultStr = refine.getDefaultStr();
        Boolean mandatory = refine.isMandatory();
        Boolean presence = refine.isPresence();
        MustDefinition must = refine.getMust();
        Integer min = refine.getMinElements();
        Integer max = refine.getMaxElements();
        if (node instanceof AnyXmlBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof ChoiceBuilder) {
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMust(node, must, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof ContainerSchemaNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
            RefineUtils.checkRefineMust(node, must, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof LeafSchemaNodeBuilder) {
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        } else if (node instanceof LeafListSchemaNodeBuilder || node instanceof ListSchemaNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
        } else if (node instanceof GroupingBuilder || node instanceof TypeDefinitionBuilder || node instanceof UsesNodeBuilder) {
            RefineUtils.checkRefineDefault(node, defaultStr, moduleName, line);
            RefineUtils.checkRefinePresence(node, presence, moduleName, line);
            RefineUtils.checkRefineMandatory(node, mandatory, moduleName, line);
            RefineUtils.checkRefineMust(node, must, moduleName, line);
            RefineUtils.checkRefineMinMax(name, min, max, moduleName, line);
        }
    }

    private static void checkRefineDefault(SchemaNodeBuilder node, String defaultStr, String moduleName, int line) {
        if (defaultStr != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'default' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMandatory(SchemaNodeBuilder node, Boolean mandatory, String moduleName, int line) {
        if (mandatory != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'mandatory' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefinePresence(SchemaNodeBuilder node, Boolean presence, String moduleName, int line) {
        if (presence != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'presence' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMust(SchemaNodeBuilder node, MustDefinition must, String moduleName, int line) {
        if (must != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'must' for '" + node.getQName().getLocalName() + "'.");
        }
    }

    private static void checkRefineMinMax(String refineTargetName, Integer min, Integer max, String moduleName, int line) {
        if (min != null || max != null) {
            throw new YangParseException(moduleName, line, "Can not refine 'min-elements' or 'max-elements' for '" + refineTargetName + "'.");
        }
    }

    private static void refineDefault(Builder node, RefineHolder refine) {
        Boolean config;
        String reference;
        String moduleName = refine.getModuleName();
        int line = refine.getLine();
        Class<?> cls = node.getClass();
        String description = refine.getDescription();
        if (description != null) {
            try {
                Method method = cls.getDeclaredMethod("setDescription", String.class);
                method.invoke((Object)node, description);
            }
            catch (Exception e) {
                throw new YangParseException(moduleName, line, "Cannot refine description in " + cls.getName(), e);
            }
        }
        if ((reference = refine.getReference()) != null) {
            try {
                Method method = cls.getDeclaredMethod("setReference", String.class);
                method.invoke((Object)node, reference);
            }
            catch (Exception e) {
                throw new YangParseException(moduleName, line, "Cannot refine reference in " + cls.getName(), e);
            }
        }
        if ((config = refine.isConfiguration()) != null) {
            try {
                Method method = cls.getDeclaredMethod("setConfiguration", Boolean.class);
                method.invoke((Object)node, config);
            }
            catch (Exception e) {
                throw new YangParseException(moduleName, line, "Cannot refine config in " + cls.getName(), e);
            }
        }
    }

    static void performRefine(SchemaNodeBuilder nodeToRefine, RefineHolder refine) {
        RefineUtils.checkRefine(nodeToRefine, refine);
        RefineUtils.refineDefault(nodeToRefine, refine);
        if (nodeToRefine instanceof LeafSchemaNodeBuilder) {
            RefineUtils.refineLeaf((LeafSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ContainerSchemaNodeBuilder) {
            RefineUtils.refineContainer((ContainerSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ListSchemaNodeBuilder) {
            RefineUtils.refineList((ListSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof LeafListSchemaNodeBuilder) {
            RefineUtils.refineLeafList((LeafListSchemaNodeBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof ChoiceBuilder) {
            RefineUtils.refineChoice((ChoiceBuilder)nodeToRefine, refine);
        } else if (nodeToRefine instanceof AnyXmlBuilder) {
            RefineUtils.refineAnyxml((AnyXmlBuilder)nodeToRefine, refine);
        }
    }
}

