/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingMember;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.CopyUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ParserUtils {
    private ParserUtils() {
    }

    public static SchemaPath createSchemaPath(SchemaPath schemaPath, QName ... qname) {
        ArrayList<QName> _arrayList;
        List _path = schemaPath.getPath();
        ArrayList<QName> path = _arrayList = new ArrayList<QName>(_path);
        List<QName> _asList = Arrays.asList(qname);
        path.addAll(_asList);
        boolean _isAbsolute = schemaPath.isAbsolute();
        SchemaPath _schemaPath = new SchemaPath(path, _isAbsolute);
        return _schemaPath;
    }

    public static ModuleImport getModuleImport(ModuleBuilder builder, String prefix) {
        Set<ModuleImport> _moduleImports = builder.getModuleImports();
        for (ModuleImport mi : _moduleImports) {
            String _prefix = mi.getPrefix();
            boolean _equals = _prefix.equals(prefix);
            if (!_equals) continue;
            return mi;
        }
        return null;
    }

    public static ModuleBuilder findModuleFromBuilders(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, String prefix, int line) {
        ModuleBuilder dependentModule = null;
        Date dependentModuleRevision = null;
        boolean _equals = Objects.equal((Object)prefix, null);
        if (_equals) {
            dependentModule = module;
        } else {
            String _prefix = module.getPrefix();
            boolean _equals_1 = prefix.equals(_prefix);
            if (_equals_1) {
                dependentModule = module;
            } else {
                boolean _tripleEquals_2;
                boolean _tripleEquals_1;
                Date _revision;
                boolean _tripleEquals;
                ModuleImport dependentModuleImport = ParserUtils.getModuleImport(module, prefix);
                boolean bl = _tripleEquals = dependentModuleImport == null;
                if (_tripleEquals) {
                    String _name = module.getName();
                    String _plus = "No import found with prefix '" + prefix;
                    String _plus_1 = _plus + "'.";
                    YangParseException _yangParseException = new YangParseException(_name, line, _plus_1);
                    throw _yangParseException;
                }
                String dependentModuleName = dependentModuleImport.getModuleName();
                dependentModuleRevision = _revision = dependentModuleImport.getRevision();
                TreeMap<Date, ModuleBuilder> moduleBuildersByRevision = modules.get(dependentModuleName);
                boolean bl2 = _tripleEquals_1 = moduleBuildersByRevision == null;
                if (_tripleEquals_1) {
                    return null;
                }
                boolean bl3 = _tripleEquals_2 = dependentModuleRevision == null;
                if (_tripleEquals_2) {
                    ModuleBuilder _value;
                    Map.Entry<Date, ModuleBuilder> _lastEntry = moduleBuildersByRevision.lastEntry();
                    dependentModule = _value = _lastEntry.getValue();
                } else {
                    ModuleBuilder _get;
                    dependentModule = _get = moduleBuildersByRevision.get(dependentModuleRevision);
                }
            }
        }
        return dependentModule;
    }

    public static Module findModuleFromContext(SchemaContext context, ModuleBuilder currentModule, String prefix, int line) {
        boolean _tripleEquals_3;
        boolean _tripleEquals_1;
        TreeMap<Date, Module> _treeMap;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            String _name = currentModule.getName();
            String _plus = "Cannot find module with prefix '" + prefix;
            String _plus_1 = _plus + "'.";
            YangParseException _yangParseException = new YangParseException(_name, line, _plus_1);
            throw _yangParseException;
        }
        TreeMap<Date, Module> modulesByRevision = _treeMap = new TreeMap<Date, Module>();
        ModuleImport dependentModuleImport = ParserUtils.getModuleImport(currentModule, prefix);
        boolean bl2 = _tripleEquals_1 = dependentModuleImport == null;
        if (_tripleEquals_1) {
            String _name_1 = currentModule.getName();
            String _plus_2 = "No import found with prefix '" + prefix;
            String _plus_3 = _plus_2 + "'.";
            YangParseException _yangParseException_1 = new YangParseException(_name_1, line, _plus_3);
            throw _yangParseException_1;
        }
        String dependentModuleName = dependentModuleImport.getModuleName();
        Date dependentModuleRevision = dependentModuleImport.getRevision();
        Set _modules = context.getModules();
        for (Module contextModule : _modules) {
            boolean _tripleEquals_2;
            String _name_2 = contextModule.getName();
            boolean _equals = _name_2.equals(dependentModuleName);
            if (!_equals) continue;
            Date revision = contextModule.getRevision();
            boolean bl3 = _tripleEquals_2 = revision == null;
            if (_tripleEquals_2) {
                Date _date;
                revision = _date = new Date(0L);
            }
            modulesByRevision.put(revision, contextModule);
        }
        Module result = null;
        boolean bl4 = _tripleEquals_3 = dependentModuleRevision == null;
        if (_tripleEquals_3) {
            Module _get;
            Date _firstKey = (Date)modulesByRevision.firstKey();
            result = _get = (Module)modulesByRevision.get(_firstKey);
        } else {
            Module _get_1;
            result = _get_1 = (Module)modulesByRevision.get(dependentModuleRevision);
        }
        return result;
    }

    public static SchemaPath parseXPathString(String xpathString) {
        ArrayList<QName> _arrayList;
        boolean absolute = xpathString.startsWith("/");
        String[] splittedPath = xpathString.split("/");
        ArrayList<QName> path = _arrayList = new ArrayList<QName>();
        QName name = null;
        for (String pathElement : splittedPath) {
            boolean _equals;
            boolean _greaterThan;
            int _length = pathElement.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            String[] splittedElement = pathElement.split(":");
            int _length_1 = splittedElement.length;
            boolean bl2 = _equals = _length_1 == 1;
            if (_equals) {
                QName _qName;
                String _get = splittedElement[0];
                name = _qName = new QName(null, null, null, _get);
            } else {
                QName _qName_1;
                String _get_1 = splittedElement[0];
                String _get_2 = splittedElement[1];
                name = _qName_1 = new QName(null, null, _get_1, _get_2);
            }
            path.add(name);
        }
        SchemaPath _schemaPath = new SchemaPath(path, absolute);
        return _schemaPath;
    }

    public static Object _fillAugmentTarget(AugmentationSchemaBuilder augment, Builder target) {
        return null;
    }

    public static Object _fillAugmentTarget(AugmentationSchemaBuilder augment, DataNodeContainerBuilder target) {
        Set<DataSchemaNodeBuilder> _childNodeBuilders = augment.getChildNodeBuilders();
        for (DataSchemaNodeBuilder child : _childNodeBuilders) {
            DataSchemaNodeBuilder childCopy = CopyUtils.copy(child, (Builder)target, false);
            Builder _parent = augment.getParent();
            if (_parent instanceof UsesNodeBuilder) {
                ParserUtils.setNodeAddedByUses(childCopy);
            }
            ParserUtils.setNodeAugmenting(childCopy);
            try {
                target.addChildNode(childCopy);
            }
            catch (Throwable _t) {
                if (_t instanceof YangParseException) {
                    YangParseException e = (YangParseException)_t;
                    String _moduleName = augment.getModuleName();
                    int _line = augment.getLine();
                    String _message = e.getMessage();
                    String _plus = "Failed to perform augmentation: " + _message;
                    YangParseException _yangParseException = new YangParseException(_moduleName, _line, _plus);
                    throw _yangParseException;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    public static Object _fillAugmentTarget(AugmentationSchemaBuilder augment, ChoiceBuilder target) {
        Set<DataSchemaNodeBuilder> _childNodeBuilders = augment.getChildNodeBuilders();
        for (DataSchemaNodeBuilder builder : _childNodeBuilders) {
            DataSchemaNodeBuilder childCopy = CopyUtils.copy(builder, (Builder)target, false);
            Builder _parent = augment.getParent();
            if (_parent instanceof UsesNodeBuilder) {
                ParserUtils.setNodeAddedByUses(childCopy);
            }
            ParserUtils.setNodeAugmenting(childCopy);
            target.addCase(childCopy);
        }
        Set<UsesNodeBuilder> _usesNodeBuilders = augment.getUsesNodeBuilders();
        for (UsesNodeBuilder usesNode : _usesNodeBuilders) {
            boolean _tripleNotEquals = usesNode != null;
            if (!_tripleNotEquals) continue;
            String _moduleName = augment.getModuleName();
            int _line = augment.getLine();
            YangParseException _yangParseException = new YangParseException(_moduleName, _line, "Error in augment parsing: cannot augment choice with nodes from grouping");
            throw _yangParseException;
        }
        return null;
    }

    private static void setNodeAugmenting(DataSchemaNodeBuilder child) {
        block3: {
            block2: {
                child.setAugmenting(true);
                if (!(child instanceof DataNodeContainerBuilder)) break block2;
                DataNodeContainerBuilder dataNodeChild = (DataNodeContainerBuilder)((Object)child);
                Set<DataSchemaNodeBuilder> _childNodeBuilders = dataNodeChild.getChildNodeBuilders();
                for (DataSchemaNodeBuilder inner : _childNodeBuilders) {
                    ParserUtils.setNodeAugmenting(inner);
                }
                break block3;
            }
            if (!(child instanceof ChoiceBuilder)) break block3;
            ChoiceBuilder choiceChild = (ChoiceBuilder)child;
            Set<ChoiceCaseBuilder> _cases = choiceChild.getCases();
            for (ChoiceCaseBuilder inner_1 : _cases) {
                ParserUtils.setNodeAugmenting(inner_1);
            }
        }
    }

    public static void setNodeAddedByUses(GroupingMember child) {
        block3: {
            block2: {
                child.setAddedByUses(true);
                if (!(child instanceof DataNodeContainerBuilder)) break block2;
                DataNodeContainerBuilder dataNodeChild = (DataNodeContainerBuilder)((Object)child);
                Set<DataSchemaNodeBuilder> _childNodeBuilders = dataNodeChild.getChildNodeBuilders();
                for (DataSchemaNodeBuilder inner : _childNodeBuilders) {
                    ParserUtils.setNodeAddedByUses(inner);
                }
                break block3;
            }
            if (!(child instanceof ChoiceBuilder)) break block3;
            ChoiceBuilder choiceChild = (ChoiceBuilder)child;
            Set<ChoiceCaseBuilder> _cases = choiceChild.getCases();
            for (ChoiceCaseBuilder inner_1 : _cases) {
                ParserUtils.setNodeAddedByUses(inner_1);
            }
        }
    }

    public static void setNodeConfig(DataSchemaNodeBuilder child, Boolean config) {
        block14: {
            block13: {
                boolean _or = false;
                boolean _or_1 = false;
                boolean _or_2 = false;
                boolean _or_3 = false;
                boolean _or_4 = false;
                if (child instanceof ContainerSchemaNodeBuilder) {
                    _or_4 = true;
                } else {
                    boolean bl = _or_4 = child instanceof ContainerSchemaNodeBuilder || child instanceof LeafSchemaNodeBuilder;
                }
                if (_or_4) {
                    _or_3 = true;
                } else {
                    boolean bl = _or_3 = _or_4 || child instanceof LeafListSchemaNodeBuilder;
                }
                if (_or_3) {
                    _or_2 = true;
                } else {
                    boolean bl = _or_2 = _or_3 || child instanceof ListSchemaNodeBuilder;
                }
                if (_or_2) {
                    _or_1 = true;
                } else {
                    boolean bl = _or_1 = _or_2 || child instanceof ChoiceBuilder;
                }
                if (_or_1) {
                    _or = true;
                } else {
                    boolean bl = _or = _or_1 || child instanceof AnyXmlBuilder;
                }
                if (_or) {
                    child.setConfiguration(config);
                }
                if (!(child instanceof DataNodeContainerBuilder)) break block13;
                DataNodeContainerBuilder dataNodeChild = (DataNodeContainerBuilder)((Object)child);
                Set<DataSchemaNodeBuilder> _childNodeBuilders = dataNodeChild.getChildNodeBuilders();
                for (DataSchemaNodeBuilder inner : _childNodeBuilders) {
                    ParserUtils.setNodeConfig(inner, config);
                }
                break block14;
            }
            if (!(child instanceof ChoiceBuilder)) break block14;
            ChoiceBuilder choiceChild = (ChoiceBuilder)child;
            Set<ChoiceCaseBuilder> _cases = choiceChild.getCases();
            for (ChoiceCaseBuilder inner_1 : _cases) {
                ParserUtils.setNodeConfig(inner_1, config);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSchemaNodeBuilder findSchemaNode(List<QName> path, SchemaNodeBuilder parentNode) {
        boolean _lessThan;
        DataSchemaNodeBuilder node = null;
        SchemaNodeBuilder parent = parentNode;
        int i = 0;
        int _size = path.size();
        boolean _while = _lessThan = i < _size;
        while (_while) {
            int _size_1;
            int _plus;
            boolean _lessThan_1;
            boolean _lessThan_12;
            QName _get = path.get(i);
            String name = _get.getLocalName();
            if (parent instanceof DataNodeContainerBuilder) {
                DataSchemaNodeBuilder _dataChildByName;
                node = _dataChildByName = ((DataNodeContainerBuilder)((Object)parent)).getDataChildByName(name);
            } else if (parent instanceof ChoiceBuilder) {
                ChoiceCaseBuilder _caseNodeByName = ((ChoiceBuilder)parent).getCaseNodeByName(name);
                node = _caseNodeByName;
            } else {
                if (!(parent instanceof RpcDefinitionBuilder)) return null;
                boolean _equals = "input".equals(name);
                if (_equals) {
                    ContainerSchemaNodeBuilder _input = ((RpcDefinitionBuilder)parent).getInput();
                    node = _input;
                } else {
                    boolean _equals_1 = "output".equals(name);
                    if (!_equals_1) return null;
                    ContainerSchemaNodeBuilder _output = ((RpcDefinitionBuilder)parent).getOutput();
                    node = _output;
                }
            }
            int _size_12 = path.size();
            int _minus = _size_12 - 1;
            boolean bl = _lessThan_12 = i < _minus;
            if (_lessThan_12) {
                parent = node;
            }
            _while = _lessThan_1 = (i = (_plus = i + 1)) < (_size_1 = path.size());
        }
        return node;
    }

    public static SchemaNodeBuilder findSchemaNodeInModule(List<QName> pathToNode, ModuleBuilder module) {
        boolean _not;
        boolean _equals_4;
        boolean _equals_2;
        ArrayList<QName> _arrayList = new ArrayList<QName>(pathToNode);
        ArrayList<QName> path = _arrayList;
        QName first = (QName)path.remove(0);
        String _localName = first.getLocalName();
        SchemaNodeBuilder node = module.getDataChildByName(_localName);
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            Set<NotificationBuilder> notifications = module.getAddedNotifications();
            for (NotificationBuilder notification : notifications) {
                String _localName_2;
                QName _qName = notification.getQName();
                String _localName_1 = _qName.getLocalName();
                boolean _equals_1 = _localName_1.equals(_localName_2 = first.getLocalName());
                if (!_equals_1) continue;
                node = notification;
            }
        }
        if (_equals_2 = Objects.equal((Object)node, null)) {
            Set<RpcDefinitionBuilder> rpcs = module.getAddedRpcs();
            for (RpcDefinitionBuilder rpc : rpcs) {
                String _localName_4;
                QName _qName_1 = rpc.getQName();
                String _localName_3 = _qName_1.getLocalName();
                boolean _equals_3 = _localName_3.equals(_localName_4 = first.getLocalName());
                if (!_equals_3) continue;
                node = rpc;
            }
        }
        if (_equals_4 = Objects.equal((Object)node, null)) {
            return null;
        }
        boolean _isEmpty = path.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            DataSchemaNodeBuilder _findSchemaNode;
            node = _findSchemaNode = ParserUtils.findSchemaNode(path, node);
        }
        return node;
    }

    public static boolean processAugmentation(AugmentationSchemaBuilder augment, ModuleBuilder firstNodeParent) {
        boolean _tripleEquals;
        SchemaPath _targetPath = augment.getTargetPath();
        List path = _targetPath.getPath();
        SchemaNodeBuilder targetNode = ParserUtils.findSchemaNodeInModule(path, firstNodeParent);
        boolean bl = _tripleEquals = targetNode == null;
        if (_tripleEquals) {
            return false;
        }
        if (targetNode instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder targetDataNodeContainer = (DataNodeContainerBuilder)((Object)targetNode);
            SchemaPath _path = targetDataNodeContainer.getPath();
            augment.setTargetNodeSchemaPath(_path);
        } else if (targetNode instanceof ChoiceBuilder) {
            ChoiceBuilder targetChoiceBuilder = (ChoiceBuilder)targetNode;
            SchemaPath _path_1 = targetChoiceBuilder.getPath();
            augment.setTargetNodeSchemaPath(_path_1);
        } else {
            String _moduleName = augment.getModuleName();
            int _line = augment.getLine();
            YangParseException _yangParseException = new YangParseException(_moduleName, _line, "Error in augment parsing: The target node MUST be either a container, list, choice, case, input, output, or notification node.");
            throw _yangParseException;
        }
        ParserUtils.fillAugmentTarget(augment, targetNode);
        ((AugmentationTargetBuilder)((Object)targetNode)).addAugmentation(augment);
        augment.setResolved(true);
        return true;
    }

    public static IdentitySchemaNodeBuilder findBaseIdentity(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, String baseString, int line) {
        IdentitySchemaNodeBuilder result = null;
        boolean _contains = baseString.contains(":");
        if (_contains) {
            boolean _tripleNotEquals;
            boolean _greaterThan;
            String[] splittedBase = baseString.split(":");
            int _length = splittedBase.length;
            boolean bl = _greaterThan = _length > 2;
            if (_greaterThan) {
                String _name = module.getName();
                String _plus = "Failed to parse identityref base: " + baseString;
                YangParseException _yangParseException = new YangParseException(_name, line, _plus);
                throw _yangParseException;
            }
            String prefix = splittedBase[0];
            String name = splittedBase[1];
            ModuleBuilder dependentModule = ParserUtils.findModuleFromBuilders(modules, module, prefix, line);
            boolean bl2 = _tripleNotEquals = dependentModule != null;
            if (_tripleNotEquals) {
                IdentitySchemaNodeBuilder _findIdentity;
                Set<IdentitySchemaNodeBuilder> _addedIdentities = dependentModule.getAddedIdentities();
                result = _findIdentity = ParserUtils.findIdentity(_addedIdentities, name);
            }
        } else {
            IdentitySchemaNodeBuilder _findIdentity_1;
            Set<IdentitySchemaNodeBuilder> _addedIdentities_1 = module.getAddedIdentities();
            result = _findIdentity_1 = ParserUtils.findIdentity(_addedIdentities_1, baseString);
        }
        return result;
    }

    public static IdentitySchemaNode findBaseIdentityFromContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, String baseString, int line, SchemaContext context) {
        boolean _greaterThan;
        IdentitySchemaNode result = null;
        String[] splittedBase = baseString.split(":");
        int _length = splittedBase.length;
        boolean bl = _greaterThan = _length > 2;
        if (_greaterThan) {
            String _name = module.getName();
            String _plus = "Failed to parse identityref base: " + baseString;
            YangParseException _yangParseException = new YangParseException(_name, line, _plus);
            throw _yangParseException;
        }
        String prefix = splittedBase[0];
        String name = splittedBase[1];
        Module dependentModule = ParserUtils.findModuleFromContext(context, module, prefix, line);
        Set _identities = dependentModule.getIdentities();
        IdentitySchemaNode _findIdentityNode = ParserUtils.findIdentityNode(_identities, name);
        result = _findIdentityNode;
        boolean _equals = Objects.equal((Object)result, null);
        if (_equals) {
            String _name_1 = module.getName();
            YangParseException _yangParseException_1 = new YangParseException(_name_1, line, "Failed to find base identity");
            throw _yangParseException_1;
        }
        return result;
    }

    private static IdentitySchemaNodeBuilder findIdentity(Set<IdentitySchemaNodeBuilder> identities, String name) {
        for (IdentitySchemaNodeBuilder identity : identities) {
            QName _qName = identity.getQName();
            String _localName = _qName.getLocalName();
            boolean _equals = _localName.equals(name);
            if (!_equals) continue;
            return identity;
        }
        return null;
    }

    private static IdentitySchemaNode findIdentityNode(Set<IdentitySchemaNode> identities, String name) {
        for (IdentitySchemaNode identity : identities) {
            QName _qName = identity.getQName();
            String _localName = _qName.getLocalName();
            boolean _equals = _localName.equals(name);
            if (!_equals) continue;
            return identity;
        }
        return null;
    }

    public static ModuleBuilder getParentModule(Builder node) {
        boolean _not;
        if (node instanceof ModuleBuilder) {
            return (ModuleBuilder)node;
        }
        Builder parent = node.getParent();
        boolean _while = _not = !(parent instanceof ModuleBuilder);
        while (_while) {
            boolean _not_1;
            Builder _parent = parent.getParent();
            _while = _not_1 = !((parent = _parent) instanceof ModuleBuilder);
        }
        Preconditions.checkState((boolean)(parent instanceof ModuleBuilder));
        ModuleBuilder parentModule = (ModuleBuilder)parent;
        boolean _isSubmodule = parentModule.isSubmodule();
        if (_isSubmodule) {
            ModuleBuilder _parent;
            parentModule = _parent = parentModule.getParent();
        }
        return parentModule;
    }

    public static Set<DataSchemaNodeBuilder> wrapChildNodes(String moduleName, int line, Set<DataSchemaNode> nodes, SchemaPath parentPath, URI ns, Date rev, String pref) {
        HashSet<DataSchemaNodeBuilder> _hashSet;
        HashSet<DataSchemaNodeBuilder> result = _hashSet = new HashSet<DataSchemaNodeBuilder>();
        for (DataSchemaNode node : nodes) {
            QName _qName_1;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            QName qname = _qName_1 = new QName(ns, rev, pref, _localName);
            DataSchemaNodeBuilder wrapped = ParserUtils.wrapChildNode(moduleName, line, node, parentPath, qname);
            result.add(wrapped);
        }
        return result;
    }

    public static DataSchemaNodeBuilder wrapChildNode(String moduleName, int line, DataSchemaNode node, SchemaPath parentPath, QName qname) {
        SchemaPath _schemaPath;
        ArrayList<QName> _arrayList;
        List _path = parentPath.getPath();
        ArrayList<QName> path = _arrayList = new ArrayList<QName>(_path);
        path.add(qname);
        boolean _isAbsolute = parentPath.isAbsolute();
        SchemaPath schemaPath = _schemaPath = new SchemaPath(path, _isAbsolute);
        if (node instanceof AnyXmlSchemaNode) {
            AnyXmlBuilder _anyXmlBuilder = new AnyXmlBuilder(moduleName, line, qname, schemaPath, (AnyXmlSchemaNode)node);
            return _anyXmlBuilder;
        }
        if (node instanceof ChoiceNode) {
            ChoiceBuilder _choiceBuilder = new ChoiceBuilder(moduleName, line, qname, schemaPath, (ChoiceNode)node);
            return _choiceBuilder;
        }
        if (node instanceof ContainerSchemaNode) {
            ContainerSchemaNodeBuilder _containerSchemaNodeBuilder = new ContainerSchemaNodeBuilder(moduleName, line, qname, schemaPath, (ContainerSchemaNode)node);
            return _containerSchemaNodeBuilder;
        }
        if (node instanceof LeafSchemaNode) {
            LeafSchemaNodeBuilder _leafSchemaNodeBuilder = new LeafSchemaNodeBuilder(moduleName, line, qname, schemaPath, (LeafSchemaNode)node);
            return _leafSchemaNodeBuilder;
        }
        if (node instanceof LeafListSchemaNode) {
            LeafListSchemaNodeBuilder _leafListSchemaNodeBuilder = new LeafListSchemaNodeBuilder(moduleName, line, qname, schemaPath, (LeafListSchemaNode)node);
            return _leafListSchemaNodeBuilder;
        }
        if (node instanceof ListSchemaNode) {
            ListSchemaNodeBuilder _listSchemaNodeBuilder = new ListSchemaNodeBuilder(moduleName, line, qname, schemaPath, (ListSchemaNode)node);
            return _listSchemaNodeBuilder;
        }
        if (node instanceof ChoiceCaseNode) {
            ChoiceCaseBuilder _choiceCaseBuilder = new ChoiceCaseBuilder(moduleName, line, qname, schemaPath, (ChoiceCaseNode)node);
            return _choiceCaseBuilder;
        }
        String _plus = "Failed to copy node: Unknown type of DataSchemaNode: " + node;
        YangParseException _yangParseException = new YangParseException(moduleName, line, _plus);
        throw _yangParseException;
    }

    public static Set<GroupingBuilder> wrapGroupings(String moduleName, int line, Set<GroupingDefinition> nodes, SchemaPath parentPath, URI ns, Date rev, String pref) {
        HashSet<GroupingBuilder> _hashSet;
        HashSet<GroupingBuilder> result = _hashSet = new HashSet<GroupingBuilder>();
        for (GroupingDefinition node : nodes) {
            SchemaPath _schemaPath;
            ArrayList<QName> _arrayList;
            QName _qName_1;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            QName qname = _qName_1 = new QName(ns, rev, pref, _localName);
            List _path = parentPath.getPath();
            ArrayList<QName> path = _arrayList = new ArrayList<QName>(_path);
            path.add(qname);
            boolean _isAbsolute = parentPath.isAbsolute();
            SchemaPath schemaPath = _schemaPath = new SchemaPath(path, _isAbsolute);
            GroupingBuilderImpl _groupingBuilderImpl = new GroupingBuilderImpl(moduleName, line, qname, schemaPath, node);
            result.add(_groupingBuilderImpl);
        }
        return result;
    }

    public static Set<TypeDefinitionBuilder> wrapTypedefs(String moduleName, int line, DataNodeContainer dataNode, SchemaPath parentPath, URI ns, Date rev, String pref) {
        HashSet<TypeDefinitionBuilder> _hashSet;
        Set nodes = dataNode.getTypeDefinitions();
        HashSet<TypeDefinitionBuilder> result = _hashSet = new HashSet<TypeDefinitionBuilder>();
        for (TypeDefinition node : nodes) {
            SchemaPath _schemaPath;
            ArrayList<QName> _arrayList;
            QName _qName_1;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            QName qname = _qName_1 = new QName(ns, rev, pref, _localName);
            List _path = parentPath.getPath();
            ArrayList<QName> path = _arrayList = new ArrayList<QName>(_path);
            path.add(qname);
            boolean _isAbsolute = parentPath.isAbsolute();
            SchemaPath schemaPath = _schemaPath = new SchemaPath(path, _isAbsolute);
            TypeDefinitionBuilderImpl _typeDefinitionBuilderImpl = new TypeDefinitionBuilderImpl(moduleName, line, qname, schemaPath, (ExtendedType)node);
            result.add(_typeDefinitionBuilderImpl);
        }
        return result;
    }

    public static List<UnknownSchemaNodeBuilder> wrapUnknownNodes(String moduleName, int line, List<UnknownSchemaNode> nodes, SchemaPath parentPath, URI ns, Date rev, String pref) {
        ArrayList<UnknownSchemaNodeBuilder> _arrayList;
        ArrayList<UnknownSchemaNodeBuilder> result = _arrayList = new ArrayList<UnknownSchemaNodeBuilder>();
        for (UnknownSchemaNode node : nodes) {
            SchemaPath _schemaPath;
            ArrayList<QName> _arrayList_1;
            QName _qName_1;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            QName qname = _qName_1 = new QName(ns, rev, pref, _localName);
            List _path = parentPath.getPath();
            ArrayList<QName> path = _arrayList_1 = new ArrayList<QName>(_path);
            path.add(qname);
            boolean _isAbsolute = parentPath.isAbsolute();
            SchemaPath schemaPath = _schemaPath = new SchemaPath(path, _isAbsolute);
            UnknownSchemaNodeBuilder _unknownSchemaNodeBuilder = new UnknownSchemaNodeBuilder(moduleName, line, qname, schemaPath, node);
            result.add(_unknownSchemaNodeBuilder);
        }
        return result;
    }

    public static Object fillAugmentTarget(AugmentationSchemaBuilder augment, Builder target) {
        if (target instanceof ChoiceBuilder) {
            return ParserUtils._fillAugmentTarget(augment, (ChoiceBuilder)target);
        }
        if (target instanceof DataNodeContainerBuilder) {
            return ParserUtils._fillAugmentTarget(augment, (DataNodeContainerBuilder)target);
        }
        if (target != null) {
            return ParserUtils._fillAugmentTarget(augment, target);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(augment, target).toString());
    }
}

