/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.BinaryType;
import org.opendaylight.yangtools.yang.model.util.BitsType;
import org.opendaylight.yangtools.yang.model.util.Decimal64;
import org.opendaylight.yangtools.yang.model.util.EnumerationType;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.util.Int16;
import org.opendaylight.yangtools.yang.model.util.Int32;
import org.opendaylight.yangtools.yang.model.util.Int64;
import org.opendaylight.yangtools.yang.model.util.Int8;
import org.opendaylight.yangtools.yang.model.util.Leafref;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.model.util.StringType;
import org.opendaylight.yangtools.yang.model.util.Uint16;
import org.opendaylight.yangtools.yang.model.util.Uint32;
import org.opendaylight.yangtools.yang.model.util.Uint64;
import org.opendaylight.yangtools.yang.model.util.Uint8;
import org.opendaylight.yangtools.yang.model.util.UnknownType;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.util.BitImpl;
import org.opendaylight.yangtools.yang.parser.util.MustDefinitionImpl;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.opendaylight.yangtools.yang.parser.util.TypeConstraints;
import org.opendaylight.yangtools.yang.parser.util.UnknownBoundaryNumber;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserListenerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ParserListenerUtils.class);

    private ParserListenerUtils() {
    }

    public static String stringFromNode(ParseTree treeNode) {
        String result = "";
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            YangParser.StringContext context;
            if (!(treeNode.getChild(i) instanceof YangParser.StringContext) || (context = (YangParser.StringContext)treeNode.getChild(i)) == null) continue;
            return ParserListenerUtils.stringFromStringContext(context);
        }
        return result;
    }

    public static String stringFromStringContext(YangParser.StringContext context) {
        StringBuilder str = new StringBuilder();
        for (TerminalNode stringNode : context.STRING()) {
            String result = stringNode.getText();
            if (!result.contains("\"")) {
                str.append(result);
                continue;
            }
            if (!result.startsWith("\"") && result.endsWith("\"")) {
                LOG.error("Syntax error in module {} at line {}: missing '\"'.", (Object)ParserListenerUtils.getParentModule((ParseTree)context), (Object)context.getStart().getLine());
                continue;
            }
            str.append(result.replace("\"", ""));
        }
        return str.toString();
    }

    private static String getParentModule(ParseTree ctx) {
        ParseTree current;
        for (current = ctx; current != null && !(current instanceof YangParser.Module_stmtContext); current = current.getParent()) {
        }
        if (current instanceof YangParser.Module_stmtContext) {
            YangParser.Module_stmtContext module = (YangParser.Module_stmtContext)current;
            for (int i = 0; i < module.getChildCount(); ++i) {
                if (!(module.getChild(i) instanceof YangParser.StringContext)) continue;
                YangParser.StringContext str = (YangParser.StringContext)module.getChild(i);
                return str.getChild(0).getText();
            }
        }
        return "";
    }

    public static void parseSchemaNodeArgs(ParseTree ctx, SchemaNodeBuilder builder) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                String desc = ParserListenerUtils.stringFromNode(child);
                builder.setDescription(desc);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                String ref = ParserListenerUtils.stringFromNode(child);
                builder.setReference(ref);
                continue;
            }
            if (!(child instanceof YangParser.Status_stmtContext)) continue;
            Status status = ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child);
            builder.setStatus(status);
        }
    }

    public static Status parseStatus(YangParser.Status_stmtContext ctx) {
        Status result = null;
        block10: for (int i = 0; i < ctx.getChildCount(); ++i) {
            String statusArgStr;
            ParseTree statusArg = ctx.getChild(i);
            if (!(statusArg instanceof YangParser.Status_argContext)) continue;
            switch (statusArgStr = ParserListenerUtils.stringFromNode(statusArg)) {
                case "current": {
                    result = Status.CURRENT;
                    continue block10;
                }
                case "deprecated": {
                    result = Status.DEPRECATED;
                    continue block10;
                }
                case "obsolete": {
                    result = Status.OBSOLETE;
                    continue block10;
                }
                default: {
                    LOG.warn("Invalid 'status' statement: " + statusArgStr);
                }
            }
        }
        return result;
    }

    public static String parseUnits(ParseTree ctx) {
        String units = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Units_stmtContext)) continue;
            units = ParserListenerUtils.stringFromNode(child);
            break;
        }
        return units;
    }

    public static String parseDefault(ParseTree ctx) {
        String defaultValue = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Default_stmtContext)) continue;
            defaultValue = ParserListenerUtils.stringFromNode(child);
            break;
        }
        return defaultValue;
    }

    public static SchemaPath createActualSchemaPath(Stack<QName> actualPath) {
        ArrayList<QName> path = new ArrayList<QName>(actualPath);
        return new SchemaPath(path, true);
    }

    public static List<String> createListKey(YangParser.Key_stmtContext ctx) {
        String[] splittedKey;
        String keyDefinition = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        ArrayList<String> keys = new ArrayList<String>();
        for (String keyElement : splittedKey = keyDefinition.split(" ")) {
            if (keyElement.isEmpty()) continue;
            keys.add(keyElement);
        }
        return keys;
    }

    private static List<EnumTypeDefinition.EnumPair> getEnumConstants(YangParser.Type_body_stmtsContext ctx, Stack<QName> path, String moduleName) {
        ArrayList<EnumTypeDefinition.EnumPair> enumConstants = new ArrayList<EnumTypeDefinition.EnumPair>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree enumSpecChild = ctx.getChild(i);
            if (!(enumSpecChild instanceof YangParser.Enum_specificationContext)) continue;
            int highestValue = -1;
            for (int j = 0; j < enumSpecChild.getChildCount(); ++j) {
                ParseTree enumChild = enumSpecChild.getChild(j);
                if (!(enumChild instanceof YangParser.Enum_stmtContext)) continue;
                EnumTypeDefinition.EnumPair enumPair = ParserListenerUtils.createEnumPair((YangParser.Enum_stmtContext)enumChild, highestValue, path, moduleName);
                if (enumPair.getValue() > highestValue) {
                    highestValue = enumPair.getValue();
                }
                enumConstants.add(enumPair);
            }
        }
        return enumConstants;
    }

    private static EnumTypeDefinition.EnumPair createEnumPair(YangParser.Enum_stmtContext ctx, int highestValue, Stack<QName> actualPath, String moduleName) {
        String name = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        SchemaPath path = ParserListenerUtils.createTypePath(actualPath, name);
        Integer value = null;
        String description = null;
        String reference = null;
        Status status = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Value_stmtContext) {
                String valueStr = ParserListenerUtils.stringFromNode(child);
                value = Integer.valueOf(valueStr);
                continue;
            }
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Status_stmtContext)) continue;
            status = ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child);
        }
        if (value == null) {
            value = highestValue + 1;
        }
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new YangParseException(moduleName, ctx.getStart().getLine(), "Error on enum '" + name + "': the enum value MUST be in the range from -2147483648 to 2147483647, but was: " + value);
        }
        EnumPairImpl result = new EnumPairImpl();
        result.qname = (QName)path.getPath().get(path.getPath().size() - 1);
        result.path = path;
        result.description = description;
        result.reference = reference;
        result.status = status;
        result.name = name;
        result.value = value;
        return result;
    }

    private static List<RangeConstraint> getRangeConstraints(YangParser.Type_body_stmtsContext ctx, String moduleName) {
        List<RangeConstraint> rangeConstraints = Collections.emptyList();
        block0: for (int i = 0; i < ctx.getChildCount(); ++i) {
            int j;
            ParseTree numRestrChild = ctx.getChild(i);
            if (numRestrChild instanceof YangParser.Numerical_restrictionsContext) {
                for (j = 0; j < numRestrChild.getChildCount(); ++j) {
                    ParseTree rangeChild = numRestrChild.getChild(j);
                    if (!(rangeChild instanceof YangParser.Range_stmtContext)) continue;
                    rangeConstraints = ParserListenerUtils.parseRangeConstraints((YangParser.Range_stmtContext)rangeChild, moduleName);
                    break block0;
                }
            }
            if (!(numRestrChild instanceof YangParser.Decimal64_specificationContext)) continue;
            for (j = 0; j < numRestrChild.getChildCount(); ++j) {
                ParseTree decRestr = numRestrChild.getChild(j);
                if (!(decRestr instanceof YangParser.Numerical_restrictionsContext)) continue;
                for (int k = 0; k < decRestr.getChildCount(); ++k) {
                    ParseTree rangeChild = decRestr.getChild(k);
                    if (!(rangeChild instanceof YangParser.Range_stmtContext)) continue;
                    rangeConstraints = ParserListenerUtils.parseRangeConstraints((YangParser.Range_stmtContext)rangeChild, moduleName);
                    break block0;
                }
            }
        }
        return rangeConstraints;
    }

    private static List<RangeConstraint> parseRangeConstraints(YangParser.Range_stmtContext ctx, String moduleName) {
        String[] splittedRange;
        int line = ctx.getStart().getLine();
        ArrayList<RangeConstraint> rangeConstraints = new ArrayList<RangeConstraint>();
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Reference_stmtContext)) continue;
            reference = ParserListenerUtils.stringFromNode(child);
        }
        String rangeStr = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        String trimmed = rangeStr.replace(" ", "");
        for (String rangeDef : splittedRange = trimmed.split("\\|")) {
            Number min;
            Number max;
            String[] splittedRangeDef = rangeDef.split("\\.\\.");
            if (splittedRangeDef.length == 1) {
                min = max = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[0], moduleName, line);
            } else {
                min = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[0], moduleName, line);
                max = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[1], moduleName, line);
            }
            RangeConstraint range = BaseConstraints.rangeConstraint((Number)min, (Number)max, (String)description, (String)reference);
            rangeConstraints.add(range);
        }
        return rangeConstraints;
    }

    private static List<LengthConstraint> getLengthConstraints(YangParser.Type_body_stmtsContext ctx, String moduleName) {
        List<LengthConstraint> lengthConstraints = Collections.emptyList();
        block0: for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree stringRestrChild = ctx.getChild(i);
            if (!(stringRestrChild instanceof YangParser.String_restrictionsContext)) continue;
            for (int j = 0; j < stringRestrChild.getChildCount(); ++j) {
                ParseTree lengthChild = stringRestrChild.getChild(j);
                if (!(lengthChild instanceof YangParser.Length_stmtContext)) continue;
                lengthConstraints = ParserListenerUtils.parseLengthConstraints((YangParser.Length_stmtContext)lengthChild, moduleName);
                break block0;
            }
        }
        return lengthConstraints;
    }

    private static List<LengthConstraint> parseLengthConstraints(YangParser.Length_stmtContext ctx, String moduleName) {
        String[] splittedRange;
        int line = ctx.getStart().getLine();
        ArrayList<LengthConstraint> lengthConstraints = new ArrayList<LengthConstraint>();
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Reference_stmtContext)) continue;
            reference = ParserListenerUtils.stringFromNode(child);
        }
        String lengthStr = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        String trimmed = lengthStr.replace(" ", "");
        for (String rangeDef : splittedRange = trimmed.split("\\|")) {
            Number min;
            Number max;
            String[] splittedRangeDef = rangeDef.split("\\.\\.");
            if (splittedRangeDef.length == 1) {
                min = max = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[0], moduleName, line);
            } else {
                min = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[0], moduleName, line);
                max = ParserListenerUtils.parseNumberConstraintValue(splittedRangeDef[1], moduleName, line);
            }
            LengthConstraint range = BaseConstraints.lengthConstraint((Number)min, (Number)max, (String)description, (String)reference);
            lengthConstraints.add(range);
        }
        return lengthConstraints;
    }

    private static Number parseNumberConstraintValue(String value, String moduleName, int line) {
        Number result;
        if ("min".equals(value) || "max".equals(value)) {
            result = new UnknownBoundaryNumber(value);
        } else {
            try {
                result = value.contains(".") ? new BigDecimal(value) : Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new YangParseException(moduleName, line, "Unable to parse range value '" + value + "'.", e);
            }
        }
        return result;
    }

    private static List<PatternConstraint> getPatternConstraint(YangParser.Type_body_stmtsContext ctx) {
        ArrayList<PatternConstraint> patterns = new ArrayList<PatternConstraint>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree stringRestrChild = ctx.getChild(i);
            if (!(stringRestrChild instanceof YangParser.String_restrictionsContext)) continue;
            for (int j = 0; j < stringRestrChild.getChildCount(); ++j) {
                ParseTree lengthChild = stringRestrChild.getChild(j);
                if (!(lengthChild instanceof YangParser.Pattern_stmtContext)) continue;
                patterns.add(ParserListenerUtils.parsePatternConstraint((YangParser.Pattern_stmtContext)lengthChild));
            }
        }
        return patterns;
    }

    private static PatternConstraint parsePatternConstraint(YangParser.Pattern_stmtContext ctx) {
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Reference_stmtContext)) continue;
            reference = ParserListenerUtils.stringFromNode(child);
        }
        String pattern = ParserListenerUtils.parsePatternString(ctx);
        return BaseConstraints.patternConstraint((String)pattern, description, reference);
    }

    private static String parsePatternString(YangParser.Pattern_stmtContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.StringContext)) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                if (j % 2 != 0) continue;
                String patternToken = child.getChild(j).getText();
                result.append(patternToken.substring(1, patternToken.length() - 1));
            }
        }
        return result.toString();
    }

    private static Integer getFractionDigits(YangParser.Type_body_stmtsContext ctx, String moduleName) {
        Integer result = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree dec64specChild = ctx.getChild(i);
            if (!(dec64specChild instanceof YangParser.Decimal64_specificationContext)) continue;
            result = ParserListenerUtils.parseFractionDigits((YangParser.Decimal64_specificationContext)dec64specChild, moduleName);
        }
        return result;
    }

    private static Integer parseFractionDigits(YangParser.Decimal64_specificationContext ctx, String moduleName) {
        Integer result = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree fdChild = ctx.getChild(i);
            if (!(fdChild instanceof YangParser.Fraction_digits_stmtContext)) continue;
            String value = ParserListenerUtils.stringFromNode(fdChild);
            try {
                result = Integer.valueOf(value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new YangParseException(moduleName, ctx.getStart().getLine(), "Unable to parse fraction digits value '" + value + "'.", e);
            }
        }
        return result;
    }

    private static List<BitsTypeDefinition.Bit> getBits(YangParser.Type_body_stmtsContext ctx, Stack<QName> actualPath, String moduleName) {
        ArrayList<BitsTypeDefinition.Bit> bits = new ArrayList<BitsTypeDefinition.Bit>();
        for (int j = 0; j < ctx.getChildCount(); ++j) {
            ParseTree bitsSpecChild = ctx.getChild(j);
            if (!(bitsSpecChild instanceof YangParser.Bits_specificationContext)) continue;
            long highestPosition = -1L;
            for (int k = 0; k < bitsSpecChild.getChildCount(); ++k) {
                ParseTree bitChild = bitsSpecChild.getChild(k);
                if (!(bitChild instanceof YangParser.Bit_stmtContext)) continue;
                BitsTypeDefinition.Bit bit = ParserListenerUtils.parseBit((YangParser.Bit_stmtContext)bitChild, highestPosition, actualPath, moduleName);
                if (bit.getPosition() > highestPosition) {
                    highestPosition = bit.getPosition();
                }
                bits.add(bit);
            }
        }
        return bits;
    }

    private static BitsTypeDefinition.Bit parseBit(YangParser.Bit_stmtContext ctx, long highestPosition, Stack<QName> actualPath, String moduleName) {
        String name = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        Long position = null;
        String description = null;
        String reference = null;
        Status status = Status.CURRENT;
        SchemaPath schemaPath = ParserListenerUtils.createBaseTypePath(actualPath, name);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Position_stmtContext) {
                String positionStr = ParserListenerUtils.stringFromNode(child);
                position = Long.valueOf(positionStr);
                continue;
            }
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Status_stmtContext)) continue;
            status = ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child);
        }
        if (position == null) {
            position = highestPosition + 1L;
        }
        if (position < 0L || position > 0xFFFFFFFFL) {
            throw new YangParseException(moduleName, ctx.getStart().getLine(), "Error on bit '" + name + "': the position value MUST be in the range 0 to 4294967295");
        }
        List<UnknownSchemaNode> unknownNodes = Collections.emptyList();
        return new BitImpl(position, (QName)schemaPath.getPath().get(schemaPath.getPath().size() - 1), schemaPath, description, reference, status, unknownNodes);
    }

    public static boolean parseUserOrdered(YangParser.Ordered_by_stmtContext ctx) {
        boolean result = false;
        block8: for (int j = 0; j < ctx.getChildCount(); ++j) {
            String orderStr;
            ParseTree orderArg = ctx.getChild(j);
            if (!(orderArg instanceof YangParser.Ordered_by_argContext)) continue;
            switch (orderStr = ParserListenerUtils.stringFromNode(orderArg)) {
                case "system": {
                    result = false;
                    continue block8;
                }
                case "user": {
                    result = true;
                    continue block8;
                }
                default: {
                    LOG.warn("Invalid 'ordered-by' statement.");
                }
            }
        }
        return result;
    }

    public static Boolean getConfig(ParseTree ctx, Builder parent, String moduleName, int line) {
        Boolean result;
        Boolean config = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Config_stmtContext)) continue;
            config = ParserListenerUtils.parseConfig((YangParser.Config_stmtContext)child, moduleName);
            break;
        }
        if (config == null) {
            Boolean parentConfig;
            result = parent instanceof DataSchemaNodeBuilder ? Boolean.valueOf((parentConfig = ((DataSchemaNodeBuilder)parent).isConfiguration()) == null ? true : parentConfig) : Boolean.valueOf(true);
        } else {
            Boolean parentConfig;
            if (parent instanceof DataSchemaNodeBuilder && !(parent instanceof ChoiceCaseBuilder) && !(parentConfig = ((DataSchemaNodeBuilder)parent).isConfiguration()).booleanValue() && config.booleanValue()) {
                throw new YangParseException(moduleName, line, "Can not set 'config' to 'true' if parent node has 'config' set to 'false'");
            }
            result = config;
        }
        return result;
    }

    private static Boolean parseConfig(YangParser.Config_stmtContext ctx, String moduleName) {
        Boolean result = null;
        if (ctx != null) {
            block8: for (int i = 0; i < ctx.getChildCount(); ++i) {
                String value;
                ParseTree configContext = ctx.getChild(i);
                if (!(configContext instanceof YangParser.Config_argContext)) continue;
                switch (value = ParserListenerUtils.stringFromNode(configContext)) {
                    case "true": {
                        result = true;
                        continue block8;
                    }
                    case "false": {
                        result = false;
                        continue block8;
                    }
                    default: {
                        throw new YangParseException(moduleName, ctx.getStart().getLine(), "Failed to parse 'config' statement value: '" + value + "'.");
                    }
                }
            }
        }
        return result;
    }

    public static TypeDefinition<?> parseUnknownTypeWithBody(QName typedefQName, YangParser.Type_body_stmtsContext ctx, Stack<QName> actualPath, URI namespace, Date revision, String prefix, Builder parent) {
        String moduleName = parent.getModuleName();
        String typeName = typedefQName.getLocalName();
        UnknownType.Builder unknownType = new UnknownType.Builder(typedefQName);
        if (ctx != null) {
            List<RangeConstraint> rangeStatements = ParserListenerUtils.getRangeConstraints(ctx, moduleName);
            List<LengthConstraint> lengthStatements = ParserListenerUtils.getLengthConstraints(ctx, moduleName);
            List<PatternConstraint> patternStatements = ParserListenerUtils.getPatternConstraint(ctx);
            Integer fractionDigits = ParserListenerUtils.getFractionDigits(ctx, moduleName);
            if (parent instanceof TypeDefinitionBuilder) {
                TypeDefinitionBuilder typedef = (TypeDefinitionBuilder)parent;
                typedef.setRanges(rangeStatements);
                typedef.setLengths(lengthStatements);
                typedef.setPatterns(patternStatements);
                typedef.setFractionDigits(fractionDigits);
                return unknownType.build();
            }
            UnknownTypeDefinition baseType = unknownType.build();
            QName qname = new QName(namespace, revision, prefix, typeName);
            SchemaPath schemaPath = ParserListenerUtils.createTypePath(actualPath, typeName);
            ExtendedType.Builder typeBuilder = new ExtendedType.Builder(qname, (TypeDefinition)baseType, null, null, schemaPath);
            typeBuilder.ranges(rangeStatements);
            typeBuilder.lengths(lengthStatements);
            typeBuilder.patterns(patternStatements);
            typeBuilder.fractionDigits(fractionDigits);
            return typeBuilder.build();
        }
        return unknownType.build();
    }

    public static TypeDefinition<?> parseTypeWithBody(String typeName, YangParser.Type_body_stmtsContext typeBody, Stack<QName> actualPath, URI namespace, Date revision, String prefix, Builder parent) {
        String moduleName = parent.getModuleName();
        int line = typeBody.getStart().getLine();
        Decimal64 baseType = null;
        Integer fractionDigits = ParserListenerUtils.getFractionDigits(typeBody, moduleName);
        List<LengthConstraint> lengthStatements = ParserListenerUtils.getLengthConstraints(typeBody, moduleName);
        List<PatternConstraint> patternStatements = ParserListenerUtils.getPatternConstraint(typeBody);
        List<RangeConstraint> rangeStatements = ParserListenerUtils.getRangeConstraints(typeBody, moduleName);
        TypeConstraints constraints = new TypeConstraints(moduleName, line);
        constraints.addFractionDigits(fractionDigits);
        constraints.addLengths(lengthStatements);
        constraints.addPatterns(patternStatements);
        constraints.addRanges(rangeStatements);
        SchemaPath baseTypePath = ParserListenerUtils.createBaseTypePath(actualPath, typeName);
        SchemaPath extBaseTypePath = ParserListenerUtils.createExtendedBaseTypePath(actualPath, namespace, revision, prefix, typeName);
        if (parent instanceof TypeDefinitionBuilder && !(parent instanceof UnionTypeBuilder)) {
            extBaseTypePath = baseTypePath;
        }
        if ("decimal64".equals(typeName)) {
            if (rangeStatements.isEmpty()) {
                try {
                    return new Decimal64(baseTypePath, fractionDigits);
                }
                catch (Exception e) {
                    throw new YangParseException(moduleName, line, e.getMessage());
                }
            }
            Decimal64 decimalType = new Decimal64(extBaseTypePath, fractionDigits);
            constraints.addRanges(decimalType.getRangeConstraints());
            baseType = decimalType;
        } else if (typeName.startsWith("int")) {
            Int8 intType = null;
            switch (typeName) {
                case "int8": {
                    intType = Int8.getInstance();
                    break;
                }
                case "int16": {
                    intType = Int16.getInstance();
                    break;
                }
                case "int32": {
                    intType = Int32.getInstance();
                    break;
                }
                case "int64": {
                    intType = Int64.getInstance();
                }
            }
            if (intType == null) {
                throw new YangParseException(moduleName, line, "Unknown yang type " + typeName);
            }
            constraints.addRanges(intType.getRangeConstraints());
            baseType = intType;
        } else if (typeName.startsWith("uint")) {
            Uint8 uintType = null;
            switch (typeName) {
                case "uint8": {
                    uintType = Uint8.getInstance();
                    break;
                }
                case "uint16": {
                    uintType = Uint16.getInstance();
                    break;
                }
                case "uint32": {
                    uintType = Uint32.getInstance();
                    break;
                }
                case "uint64": {
                    uintType = Uint64.getInstance();
                }
            }
            if (uintType == null) {
                throw new YangParseException(moduleName, line, "Unknown yang type " + typeName);
            }
            constraints.addRanges(uintType.getRangeConstraints());
            baseType = uintType;
        } else {
            if ("enumeration".equals(typeName)) {
                List<EnumTypeDefinition.EnumPair> enumConstants = ParserListenerUtils.getEnumConstants(typeBody, actualPath, moduleName);
                return new EnumerationType(baseTypePath, enumConstants);
            }
            if ("string".equals(typeName)) {
                StringType stringType = StringType.getInstance();
                constraints.addLengths(stringType.getLengthConstraints());
                baseType = stringType;
            } else {
                if ("bits".equals(typeName)) {
                    return new BitsType(baseTypePath, ParserListenerUtils.getBits(typeBody, actualPath, moduleName));
                }
                if ("leafref".equals(typeName)) {
                    String path = ParserListenerUtils.parseLeafrefPath(typeBody);
                    boolean absolute = path.startsWith("/");
                    RevisionAwareXPathImpl xpath = new RevisionAwareXPathImpl(path, absolute);
                    return new Leafref((RevisionAwareXPath)xpath);
                }
                if ("binary".equals(typeName)) {
                    BinaryType binaryType = BinaryType.getInstance();
                    constraints.addLengths(binaryType.getLengthConstraints());
                    baseType = binaryType;
                } else if ("instance-identifier".equals(typeName)) {
                    boolean requireInstance = ParserListenerUtils.isRequireInstance(typeBody);
                    return new InstanceIdentifier(null, requireInstance);
                }
            }
        }
        if (parent instanceof TypeDefinitionBuilder && !(parent instanceof UnionTypeBuilder)) {
            TypeDefinitionBuilder typedef = (TypeDefinitionBuilder)parent;
            typedef.setRanges(constraints.getRange());
            typedef.setLengths(constraints.getLength());
            typedef.setPatterns(constraints.getPatterns());
            typedef.setFractionDigits(constraints.getFractionDigits());
            return baseType;
        }
        ArrayList<QName> path = new ArrayList<QName>(actualPath);
        path.add(new QName(namespace, revision, prefix, typeName));
        SchemaPath schemaPath = new SchemaPath(path, true);
        QName qname = (QName)schemaPath.getPath().get(schemaPath.getPath().size() - 1);
        ExtendedType.Builder typeBuilder = new ExtendedType.Builder(qname, (TypeDefinition)baseType, "", "", schemaPath);
        typeBuilder.ranges(constraints.getRange());
        typeBuilder.lengths(constraints.getLength());
        typeBuilder.patterns(constraints.getPatterns());
        typeBuilder.fractionDigits(constraints.getFractionDigits());
        return typeBuilder.build();
    }

    private static SchemaPath createTypePath(Stack<QName> actual, String typeName) {
        QName last = actual.peek();
        QName typeQName = new QName(last.getNamespace(), last.getRevision(), last.getPrefix(), typeName);
        ArrayList<QName> path = new ArrayList<QName>(actual);
        path.add(typeQName);
        return new SchemaPath(path, true);
    }

    private static SchemaPath createBaseTypePath(Stack<QName> actual, String typeName) {
        ArrayList<QName> path = new ArrayList<QName>(actual);
        path.add(BaseTypes.constructQName((String)typeName));
        return new SchemaPath(path, true);
    }

    private static SchemaPath createExtendedBaseTypePath(Stack<QName> actual, URI namespace, Date revision, String prefix, String typeName) {
        QName extTypeName = new QName(namespace, revision, prefix, typeName);
        QName baseTypeName = BaseTypes.constructQName((String)typeName);
        ArrayList<QName> path = new ArrayList<QName>(actual);
        path.add(extTypeName);
        path.add(baseTypeName);
        return new SchemaPath(path, true);
    }

    public static String getIdentityrefBase(YangParser.Type_body_stmtsContext ctx) {
        String result = null;
        block0: for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Identityref_specificationContext)) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                ParseTree baseArg = child.getChild(j);
                if (!(baseArg instanceof YangParser.Base_stmtContext)) continue;
                result = ParserListenerUtils.stringFromNode(baseArg);
                break block0;
            }
        }
        return result;
    }

    private static boolean isRequireInstance(YangParser.Type_body_stmtsContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Instance_identifier_specificationContext)) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                ParseTree reqStmt = child.getChild(j);
                if (!(reqStmt instanceof YangParser.Require_instance_stmtContext)) continue;
                for (int k = 0; k < reqStmt.getChildCount(); ++k) {
                    ParseTree reqArg = reqStmt.getChild(k);
                    if (!(reqArg instanceof YangParser.Require_instance_argContext)) continue;
                    return Boolean.valueOf(ParserListenerUtils.stringFromNode(reqArg));
                }
            }
        }
        return true;
    }

    private static String parseLeafrefPath(YangParser.Type_body_stmtsContext ctx) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Leafref_specificationContext)) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                ParseTree leafRefSpec = child.getChild(j);
                if (!(leafRefSpec instanceof YangParser.Path_stmtContext)) continue;
                return ParserListenerUtils.stringFromNode(leafRefSpec);
            }
        }
        return null;
    }

    public static MustDefinition parseMust(YangParser.Must_stmtContext ctx) {
        StringBuilder mustText = new StringBuilder();
        String description = null;
        String reference = null;
        String errorAppTag = null;
        String errorMessage = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.StringContext) {
                YangParser.StringContext context = (YangParser.StringContext)child;
                if (context.getChildCount() == 1) {
                    String mustPart = context.getChild(0).getText();
                    mustText.append(mustPart.substring(1, mustPart.length() - 1));
                    continue;
                }
                for (int j = 0; j < context.getChildCount(); ++j) {
                    String mustPart = context.getChild(j).getText();
                    if (j == 0) {
                        mustText.append(mustPart.substring(0, mustPart.length() - 1));
                        continue;
                    }
                    if (j % 2 != 0) continue;
                    mustText.append(mustPart.substring(1));
                }
                continue;
            }
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Error_app_tag_stmtContext) {
                errorAppTag = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Error_message_stmtContext)) continue;
            errorMessage = ParserListenerUtils.stringFromNode(child);
        }
        return new MustDefinitionImpl(mustText.toString(), description, reference, errorAppTag, errorMessage);
    }

    public static void parseConstraints(ParseTree ctx, ConstraintsBuilder constraints) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (childNode instanceof YangParser.Max_elements_stmtContext) {
                Integer max = ParserListenerUtils.parseMaxElements((YangParser.Max_elements_stmtContext)childNode, constraints.getModuleName());
                constraints.setMaxElements(max);
                continue;
            }
            if (childNode instanceof YangParser.Min_elements_stmtContext) {
                Integer min = ParserListenerUtils.parseMinElements((YangParser.Min_elements_stmtContext)childNode, constraints.getModuleName());
                constraints.setMinElements(min);
                continue;
            }
            if (childNode instanceof YangParser.Must_stmtContext) {
                MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)childNode);
                constraints.addMustDefinition(must);
                continue;
            }
            if (childNode instanceof YangParser.Mandatory_stmtContext) {
                for (int j = 0; j < childNode.getChildCount(); ++j) {
                    ParseTree mandatoryTree = childNode.getChild(j);
                    if (!(mandatoryTree instanceof YangParser.Mandatory_argContext)) continue;
                    Boolean mandatory = Boolean.valueOf(ParserListenerUtils.stringFromNode(mandatoryTree));
                    constraints.setMandatory(mandatory);
                }
                continue;
            }
            if (!(childNode instanceof YangParser.When_stmtContext)) continue;
            constraints.addWhenCondition(ParserListenerUtils.stringFromNode(childNode));
        }
    }

    private static Integer parseMinElements(YangParser.Min_elements_stmtContext ctx, String moduleName) {
        Integer result = null;
        try {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                ParseTree minArg = ctx.getChild(i);
                if (!(minArg instanceof YangParser.Min_value_argContext)) continue;
                result = Integer.valueOf(ParserListenerUtils.stringFromNode(minArg));
            }
            if (result == null) {
                throw new IllegalArgumentException();
            }
            return result;
        }
        catch (Exception e) {
            throw new YangParseException(moduleName, ctx.getStart().getLine(), "Failed to parse min-elements.", e);
        }
    }

    private static Integer parseMaxElements(YangParser.Max_elements_stmtContext ctx, String moduleName) {
        Integer result = null;
        try {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                ParseTree maxArg = ctx.getChild(i);
                if (!(maxArg instanceof YangParser.Max_value_argContext)) continue;
                result = Integer.valueOf(ParserListenerUtils.stringFromNode(maxArg));
            }
            if (result == null) {
                throw new IllegalArgumentException();
            }
            return result;
        }
        catch (Exception e) {
            throw new YangParseException(moduleName, ctx.getStart().getLine(), "Failed to parse max-elements.", e);
        }
    }

    public static boolean parseYinValue(YangParser.Argument_stmtContext ctx) {
        boolean yinValue = false;
        block0: for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree yin = ctx.getChild(i);
            if (!(yin instanceof YangParser.Yin_element_stmtContext)) continue;
            for (int j = 0; j < yin.getChildCount(); ++j) {
                String yinString;
                ParseTree yinArg = yin.getChild(j);
                if (!(yinArg instanceof YangParser.Yin_element_argContext) || !"true".equals(yinString = ParserListenerUtils.stringFromNode(yinArg))) continue;
                yinValue = true;
                break block0;
            }
        }
        return yinValue;
    }

    public static void checkMissingBody(String typeName, String moduleName, int line) {
        switch (typeName) {
            case "decimal64": {
                throw new YangParseException(moduleName, line, "The 'fraction-digits' statement MUST be present if the type is 'decimal64'.");
            }
            case "identityref": {
                throw new YangParseException(moduleName, line, "The 'base' statement MUST be present if the type is 'identityref'.");
            }
            case "leafref": {
                throw new YangParseException(moduleName, line, "The 'path' statement MUST be present if the type is 'leafref'.");
            }
            case "bits": {
                throw new YangParseException(moduleName, line, "The 'bit' statement MUST be present if the type is 'bits'.");
            }
            case "enumeration": {
                throw new YangParseException(moduleName, line, "The 'enum' statement MUST be present if the type is 'enumeration'.");
            }
        }
    }

    public static RefineHolder parseRefine(YangParser.Refine_stmtContext refineCtx, String moduleName) {
        String refineTarget = ParserListenerUtils.stringFromNode((ParseTree)refineCtx);
        RefineHolder refine = new RefineHolder(moduleName, refineCtx.getStart().getLine(), refineTarget);
        for (int i = 0; i < refineCtx.getChildCount(); ++i) {
            ParseTree refinePom = refineCtx.getChild(i);
            if (!(refinePom instanceof YangParser.Refine_pomContext)) continue;
            for (int j = 0; j < refinePom.getChildCount(); ++j) {
                ParseTree refineStmt = refinePom.getChild(j);
                ParserListenerUtils.parseRefineDefault(refine, refineStmt);
                if (refineStmt instanceof YangParser.Refine_leaf_stmtsContext) {
                    ParserListenerUtils.parseRefine(refine, (YangParser.Refine_leaf_stmtsContext)refineStmt);
                    continue;
                }
                if (refineStmt instanceof YangParser.Refine_container_stmtsContext) {
                    ParserListenerUtils.parseRefine(refine, (YangParser.Refine_container_stmtsContext)refineStmt);
                    continue;
                }
                if (refineStmt instanceof YangParser.Refine_list_stmtsContext) {
                    ParserListenerUtils.parseRefine(refine, (YangParser.Refine_list_stmtsContext)refineStmt);
                    continue;
                }
                if (refineStmt instanceof YangParser.Refine_leaf_list_stmtsContext) {
                    ParserListenerUtils.parseRefine(refine, (YangParser.Refine_leaf_list_stmtsContext)refineStmt);
                    continue;
                }
                if (refineStmt instanceof YangParser.Refine_choice_stmtsContext) {
                    ParserListenerUtils.parseRefine(refine, (YangParser.Refine_choice_stmtsContext)refineStmt);
                    continue;
                }
                if (!(refineStmt instanceof YangParser.Refine_anyxml_stmtsContext)) continue;
                ParserListenerUtils.parseRefine(refine, (YangParser.Refine_anyxml_stmtsContext)refineStmt);
            }
        }
        return refine;
    }

    private static void parseRefineDefault(RefineHolder refine, ParseTree refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Description_stmtContext) {
                String description = ParserListenerUtils.stringFromNode(refineArg);
                refine.setDescription(description);
                continue;
            }
            if (refineArg instanceof YangParser.Reference_stmtContext) {
                String reference = ParserListenerUtils.stringFromNode(refineArg);
                refine.setReference(reference);
                continue;
            }
            if (!(refineArg instanceof YangParser.Config_stmtContext)) continue;
            Boolean config = ParserListenerUtils.parseConfig((YangParser.Config_stmtContext)refineArg, refine.getModuleName());
            refine.setConfiguration(config);
        }
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_leaf_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Default_stmtContext) {
                String defaultStr = ParserListenerUtils.stringFromNode(refineArg);
                refine.setDefaultStr(defaultStr);
                continue;
            }
            if (refineArg instanceof YangParser.Mandatory_stmtContext) {
                for (int j = 0; j < refineArg.getChildCount(); ++j) {
                    ParseTree mandatoryTree = refineArg.getChild(j);
                    if (!(mandatoryTree instanceof YangParser.Mandatory_argContext)) continue;
                    Boolean mandatory = Boolean.valueOf(ParserListenerUtils.stringFromNode(mandatoryTree));
                    refine.setMandatory(mandatory);
                }
                continue;
            }
            if (!(refineArg instanceof YangParser.Must_stmtContext)) continue;
            MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)refineArg);
            refine.setMust(must);
        }
        return refine;
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_container_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Must_stmtContext) {
                MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)refineArg);
                refine.setMust(must);
                continue;
            }
            if (!(refineArg instanceof YangParser.Presence_stmtContext)) continue;
            refine.setPresence(true);
        }
        return refine;
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_list_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Must_stmtContext) {
                MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)refineArg);
                refine.setMust(must);
                continue;
            }
            if (refineArg instanceof YangParser.Max_elements_stmtContext) {
                Integer max = ParserListenerUtils.parseMaxElements((YangParser.Max_elements_stmtContext)refineArg, refine.getModuleName());
                refine.setMaxElements(max);
                continue;
            }
            if (!(refineArg instanceof YangParser.Min_elements_stmtContext)) continue;
            Integer min = ParserListenerUtils.parseMinElements((YangParser.Min_elements_stmtContext)refineArg, refine.getModuleName());
            refine.setMinElements(min);
        }
        return refine;
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_leaf_list_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Must_stmtContext) {
                MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)refineArg);
                refine.setMust(must);
                continue;
            }
            if (refineArg instanceof YangParser.Max_elements_stmtContext) {
                Integer max = ParserListenerUtils.parseMaxElements((YangParser.Max_elements_stmtContext)refineArg, refine.getModuleName());
                refine.setMaxElements(max);
                continue;
            }
            if (!(refineArg instanceof YangParser.Min_elements_stmtContext)) continue;
            Integer min = ParserListenerUtils.parseMinElements((YangParser.Min_elements_stmtContext)refineArg, refine.getModuleName());
            refine.setMinElements(min);
        }
        return refine;
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_choice_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Default_stmtContext) {
                String defaultStr = ParserListenerUtils.stringFromNode(refineArg);
                refine.setDefaultStr(defaultStr);
                continue;
            }
            if (!(refineArg instanceof YangParser.Mandatory_stmtContext)) continue;
            for (int j = 0; j < refineArg.getChildCount(); ++j) {
                ParseTree mandatoryTree = refineArg.getChild(j);
                if (!(mandatoryTree instanceof YangParser.Mandatory_argContext)) continue;
                Boolean mandatory = Boolean.valueOf(ParserListenerUtils.stringFromNode(mandatoryTree));
                refine.setMandatory(mandatory);
            }
        }
        return refine;
    }

    private static RefineHolder parseRefine(RefineHolder refine, YangParser.Refine_anyxml_stmtsContext refineStmt) {
        for (int i = 0; i < refineStmt.getChildCount(); ++i) {
            ParseTree refineArg = refineStmt.getChild(i);
            if (refineArg instanceof YangParser.Must_stmtContext) {
                MustDefinition must = ParserListenerUtils.parseMust((YangParser.Must_stmtContext)refineArg);
                refine.setMust(must);
                continue;
            }
            if (!(refineArg instanceof YangParser.Mandatory_stmtContext)) continue;
            for (int j = 0; j < refineArg.getChildCount(); ++j) {
                ParseTree mandatoryTree = refineArg.getChild(j);
                if (!(mandatoryTree instanceof YangParser.Mandatory_argContext)) continue;
                Boolean mandatory = Boolean.valueOf(ParserListenerUtils.stringFromNode(mandatoryTree));
                refine.setMandatory(mandatory);
            }
        }
        return refine;
    }

    public static String getArgumentString(ParserRuleContext ctx) {
        List potentialValues = ctx.getRuleContexts(YangParser.StringContext.class);
        Preconditions.checkState((!potentialValues.isEmpty() ? 1 : 0) != 0);
        return ParserListenerUtils.stringFromStringContext((YangParser.StringContext)((Object)potentialValues.get(0)));
    }

    public static <T extends ParserRuleContext> Optional<T> getFirstContext(ParserRuleContext context, Class<T> contextType) {
        List potential = context.getRuleContexts(contextType);
        if (potential.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(potential.get(0));
    }

    private static class EnumPairImpl
    implements EnumTypeDefinition.EnumPair {
        private QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status;
        private List<UnknownSchemaNode> unknownNodes = Collections.emptyList();
        private String name;
        private Integer value;

        private EnumPairImpl() {
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.unknownNodes == null ? 0 : this.unknownNodes.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPairImpl other = (EnumPairImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                return false;
            }
            if (this.unknownNodes == null ? other.unknownNodes != null : !this.unknownNodes.equals(other.unknownNodes)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return EnumTypeDefinition.EnumPair.class.getSimpleName() + "[name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

