/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.util.TopologicalSort;
import org.opendaylight.yangtools.yang.parser.util.YangValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleDependencySort {
    private static final Date DEFAULT_REVISION = new Date(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDependencySort.class);

    private ModuleDependencySort() {
    }

    public static List<ModuleBuilder> sort(ModuleBuilder ... builders) {
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(Arrays.asList(builders));
        return Lists.transform(sorted, (Function)new Function<TopologicalSort.Node, ModuleBuilder>(){

            public ModuleBuilder apply(TopologicalSort.Node input) {
                return (ModuleBuilder)((ModuleNodeImpl)input).getReference();
            }
        });
    }

    public static List<ModuleBuilder> sortWithContext(SchemaContext context, ModuleBuilder ... builders) {
        ArrayList modules = new ArrayList();
        Collections.addAll(modules, builders);
        modules.addAll(context.getModules());
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(modules);
        return Lists.transform(sorted, (Function)new Function<TopologicalSort.Node, ModuleBuilder>(){

            public ModuleBuilder apply(TopologicalSort.Node input) {
                if (((ModuleNodeImpl)input).getReference() instanceof ModuleBuilder) {
                    return (ModuleBuilder)((ModuleNodeImpl)input).getReference();
                }
                return null;
            }
        });
    }

    public static List<Module> sort(Module ... modules) {
        List<TopologicalSort.Node> sorted = ModuleDependencySort.sortInternal(Arrays.asList(modules));
        return Lists.transform(sorted, (Function)new Function<TopologicalSort.Node, Module>(){

            public Module apply(TopologicalSort.Node input) {
                return (Module)((ModuleNodeImpl)input).getReference();
            }
        });
    }

    private static List<TopologicalSort.Node> sortInternal(List<?> modules) {
        Map<String, Map<Date, ModuleNodeImpl>> moduleGraph = ModuleDependencySort.createModuleGraph(modules);
        HashSet nodes = Sets.newHashSet();
        for (Map<Date, ModuleNodeImpl> map : moduleGraph.values()) {
            for (ModuleNodeImpl node : map.values()) {
                nodes.add(node);
            }
        }
        return TopologicalSort.sort(nodes);
    }

    @VisibleForTesting
    static Map<String, Map<Date, ModuleNodeImpl>> createModuleGraph(List<?> builders) {
        HashMap moduleGraph = Maps.newHashMap();
        ModuleDependencySort.processModules(moduleGraph, builders);
        ModuleDependencySort.processDependencies(moduleGraph, builders);
        return moduleGraph;
    }

    private static void processDependencies(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, List<?> builders) {
        HashMap allNS = new HashMap();
        for (Object mb : builders) {
            HashMap imported = Maps.newHashMap();
            String fromName = null;
            Date fromRevision = null;
            Set<ModuleImport> imports = null;
            URI ns = null;
            if (mb instanceof Module) {
                fromName = ((Module)mb).getName();
                fromRevision = ((Module)mb).getRevision();
                imports = ((Module)mb).getImports();
                ns = ((Module)mb).getNamespace();
            } else if (mb instanceof ModuleBuilder) {
                fromName = ((ModuleBuilder)mb).getName();
                fromRevision = ((ModuleBuilder)mb).getRevision();
                imports = ((ModuleBuilder)mb).getModuleImports();
                ns = ((ModuleBuilder)mb).getNamespace();
            }
            if (allNS.containsKey(ns)) {
                Object mod = allNS.get(ns);
                String name = null;
                Date revision = null;
                if (mod instanceof Module) {
                    name = ((Module)mod).getName();
                    revision = ((Module)mod).getRevision();
                } else if (mod instanceof ModuleBuilder) {
                    name = ((ModuleBuilder)mod).getName();
                    revision = ((ModuleBuilder)mod).getRevision();
                }
                if (!fromName.equals(name)) {
                    LOGGER.warn("Error while sorting module [{}, {}]: module with same namespace ({}) already loaded: [{}, {}]", new Object[]{fromName, fromRevision, ns, name, revision});
                }
            } else {
                allNS.put(ns, mb);
            }
            if (fromRevision == null) {
                fromRevision = DEFAULT_REVISION;
            }
            for (ModuleImport imprt : imports) {
                String toName = imprt.getModuleName();
                Date toRevision = imprt.getRevision() == null ? DEFAULT_REVISION : imprt.getRevision();
                ModuleNodeImpl from = moduleGraph.get(fromName).get(fromRevision);
                ModuleNodeImpl to = ModuleDependencySort.getModuleByNameAndRevision(moduleGraph, fromName, fromRevision, toName, toRevision);
                if (!(imported.get(toName) == null || ((Date)imported.get(toName)).equals(toRevision) || ((Date)imported.get(toName)).equals(DEFAULT_REVISION) || toRevision.equals(DEFAULT_REVISION))) {
                    ModuleDependencySort.ex(String.format("Module:%s imported twice with different revisions:%s, %s", toName, ModuleDependencySort.formatRevDate((Date)imported.get(toName)), ModuleDependencySort.formatRevDate(toRevision)));
                }
                imported.put(toName, toRevision);
                from.addEdge(to);
            }
        }
    }

    private static ModuleNodeImpl getModuleByNameAndRevision(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, String fromName, Date fromRevision, String toName, Date toRevision) {
        ModuleNodeImpl to = null;
        if (moduleGraph.get(toName) == null || !moduleGraph.get(toName).containsKey(toRevision)) {
            if (moduleGraph.get(toName) != null && !moduleGraph.get(toName).isEmpty() && toRevision.equals(DEFAULT_REVISION)) {
                to = moduleGraph.get(toName).values().iterator().next();
                LOGGER.debug(String.format("Import:%s:%s by module:%s:%s does not specify revision, using:%s:%s for module dependency sort", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision), to.getName(), ModuleDependencySort.formatRevDate(to.getRevision())));
            } else {
                LOGGER.warn(String.format("Not existing module imported:%s:%s by:%s:%s", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)));
                LOGGER.warn("Available models: {}", moduleGraph);
                ModuleDependencySort.ex(String.format("Not existing module imported:%s:%s by:%s:%s", toName, ModuleDependencySort.formatRevDate(toRevision), fromName, ModuleDependencySort.formatRevDate(fromRevision)));
            }
        } else {
            to = moduleGraph.get(toName).get(toRevision);
        }
        return to;
    }

    private static void ex(String message) {
        throw new YangValidationException(message);
    }

    private static void processModules(Map<String, Map<Date, ModuleNodeImpl>> moduleGraph, List<?> builders) {
        for (Object mb : builders) {
            String name = null;
            Date rev = null;
            if (mb instanceof Module) {
                name = ((Module)mb).getName();
                rev = ((Module)mb).getRevision();
            } else if (mb instanceof ModuleBuilder) {
                name = ((ModuleBuilder)mb).getName();
                rev = ((ModuleBuilder)mb).getRevision();
            } else {
                throw new IllegalStateException(String.format("Unexpected type of node for sort, expected only:%s, %s, got:%s", Module.class, ModuleBuilder.class, mb.getClass()));
            }
            if (rev == null) {
                rev = DEFAULT_REVISION;
            }
            if (moduleGraph.get(name) == null) {
                moduleGraph.put(name, Maps.newHashMap());
            }
            if (moduleGraph.get(name).get(rev) != null) {
                ModuleDependencySort.ex(String.format("Module:%s with revision:%s declared twice", name, ModuleDependencySort.formatRevDate(rev)));
            }
            moduleGraph.get(name).put(rev, new ModuleNodeImpl(name, rev, mb));
        }
    }

    private static String formatRevDate(Date rev) {
        return rev.equals(DEFAULT_REVISION) ? "default" : new SimpleDateFormat("yyyy-MM-dd").format(rev);
    }

    @VisibleForTesting
    static class ModuleNodeImpl
    extends TopologicalSort.NodeImpl {
        private final String name;
        private final Date revision;
        private final Object originalObject;

        public ModuleNodeImpl(String name, Date revision, Object builder) {
            this.name = name;
            this.revision = revision;
            this.originalObject = builder;
        }

        public String getName() {
            return this.name;
        }

        public Date getRevision() {
            return this.revision;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleNodeImpl other = (ModuleNodeImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
        }

        public String toString() {
            return "Module [name=" + this.name + ", revision=" + ModuleDependencySort.formatRevDate(this.revision) + "]";
        }

        public Object getReference() {
            return this.originalObject;
        }
    }
}

