/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.opendaylight.yangtools.yang.parser.util.RefineUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class GroupingUtils {
    private GroupingUtils() {
    }

    public static GroupingBuilder getTargetGroupingFromModules(UsesNodeBuilder usesBuilder, Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        ModuleBuilder dependentModule;
        String groupingName;
        String groupingPrefix;
        Object splitted;
        int line = usesBuilder.getLine();
        String groupingString = usesBuilder.getGroupingPathAsString();
        if (groupingString.contains(":")) {
            splitted = groupingString.split(":");
            if (((String[])splitted).length != 2 || groupingString.contains("/")) {
                throw new YangParseException(module.getName(), line, "Invalid name of target grouping");
            }
            groupingPrefix = splitted[0];
            groupingName = splitted[1];
        } else {
            groupingPrefix = module.getPrefix();
            groupingName = groupingString;
        }
        if (groupingPrefix == null) {
            splitted = module;
        }
        if ((dependentModule = groupingPrefix.equals(module.getPrefix()) ? module : ParserUtils.findModuleFromBuilders(modules, module, groupingPrefix, line)) == null) {
            return null;
        }
        Set<GroupingBuilder> groupings = dependentModule.getGroupingBuilders();
        GroupingBuilder result = GroupingUtils.findGroupingBuilder(groupings, groupingName);
        if (result != null) {
            return result;
        }
        for (Builder parent = usesBuilder.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof DataNodeContainerBuilder) {
                groupings = parent.getGroupingBuilders();
            } else if (parent instanceof RpcDefinitionBuilder) {
                groupings = ((RpcDefinitionBuilder)parent).getGroupings();
            }
            result = GroupingUtils.findGroupingBuilder(groupings, groupingName);
            if (result != null) break;
        }
        if (result == null) {
            throw new YangParseException(module.getName(), line, "Referenced grouping '" + groupingName + "' not found.");
        }
        return result;
    }

    public static GroupingDefinition getTargetGroupingFromContext(UsesNodeBuilder usesBuilder, ModuleBuilder module, SchemaContext context) {
        String groupingName;
        String groupingPrefix;
        int line = usesBuilder.getLine();
        String groupingString = usesBuilder.getGroupingPathAsString();
        if (groupingString.contains(":")) {
            String[] splitted = groupingString.split(":");
            if (splitted.length != 2 || groupingString.contains("/")) {
                throw new YangParseException(module.getName(), line, "Invalid name of target grouping");
            }
            groupingPrefix = splitted[0];
            groupingName = splitted[1];
        } else {
            groupingPrefix = module.getPrefix();
            groupingName = groupingString;
        }
        Module dependentModule = ParserUtils.findModuleFromContext(context, module, groupingPrefix, line);
        return GroupingUtils.findGroupingDefinition(dependentModule.getGroupings(), groupingName);
    }

    public static GroupingBuilder findGroupingBuilder(Set<GroupingBuilder> groupings, String name) {
        for (GroupingBuilder grouping : groupings) {
            if (!grouping.getQName().getLocalName().equals(name)) continue;
            return grouping;
        }
        return null;
    }

    public static GroupingDefinition findGroupingDefinition(Set<GroupingDefinition> groupings, String name) {
        for (GroupingDefinition grouping : groupings) {
            if (!grouping.getQName().getLocalName().equals(name)) continue;
            return grouping;
        }
        return null;
    }

    public static void performRefine(UsesNodeBuilder usesNode) {
        for (RefineHolder refine : usesNode.getRefines()) {
            String refineTargetPath = refine.getName();
            String[] splitted = refineTargetPath.split("/");
            Builder currentNode = usesNode.getParent();
            for (String pathElement : splitted) {
                if (currentNode instanceof DataNodeContainerBuilder) {
                    currentNode = currentNode.getDataChildByName(pathElement);
                    continue;
                }
                if (!(currentNode instanceof ChoiceBuilder)) continue;
                currentNode = ((ChoiceBuilder)currentNode).getCaseNodeByName(pathElement);
            }
            DataSchemaNodeBuilder nodeToRefine = (DataSchemaNodeBuilder)currentNode;
            if (nodeToRefine == null) {
                throw new YangParseException(refine.getModuleName(), refine.getLine(), "Refine target node '" + refine.getName() + "' not found");
            }
            RefineUtils.performRefine(nodeToRefine, refine);
            usesNode.addRefineNode(nodeToRefine);
        }
    }

    private static int getElementPosition(UsesNodeBuilder usesNode) {
        int i = 0;
        Builder parent = usesNode.getParent();
        while (!(parent instanceof ModuleBuilder)) {
            parent = parent.getParent();
            ++i;
        }
        return i;
    }

    public static class UsesComparator
    implements Comparator<UsesNodeBuilder> {
        @Override
        public int compare(UsesNodeBuilder o1, UsesNodeBuilder o2) {
            return GroupingUtils.getElementPosition(o2) - GroupingUtils.getElementPosition(o1);
        }
    }
}

