/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.util.NodeWrappedType;
import org.opendaylight.yangtools.yang.parser.util.TopologicalSort;

public class GroupingSort {
    public static List<GroupingBuilder> sort(Collection<GroupingBuilder> groupingDefinitions) {
        if (groupingDefinitions == null) {
            throw new IllegalArgumentException("Set of Type Definitions cannot be NULL!");
        }
        ArrayList<GroupingBuilder> resultGroupingDefinitions = new ArrayList<GroupingBuilder>();
        Set<TopologicalSort.Node> unsorted = GroupingSort.groupingDefinitionsToNodes(groupingDefinitions);
        List<TopologicalSort.Node> sortedNodes = TopologicalSort.sort(unsorted);
        for (TopologicalSort.Node node : sortedNodes) {
            NodeWrappedType nodeWrappedType = (NodeWrappedType)node;
            resultGroupingDefinitions.add((GroupingBuilder)nodeWrappedType.getWrappedType());
        }
        return resultGroupingDefinitions;
    }

    private static Set<TopologicalSort.Node> groupingDefinitionsToNodes(Collection<GroupingBuilder> groupingDefinitions) {
        HashMap nodeMap = Maps.newHashMap();
        HashSet resultNodes = Sets.newHashSet();
        for (GroupingBuilder groupingDefinition : groupingDefinitions) {
            NodeWrappedType node = new NodeWrappedType(groupingDefinition);
            nodeMap.put(groupingDefinition.getPath(), node);
            resultNodes.add(node);
        }
        for (TopologicalSort.Node node : resultNodes) {
            NodeWrappedType nodeWrappedType = (NodeWrappedType)node;
            GroupingBuilder groupingDefinition = (GroupingBuilder)nodeWrappedType.getWrappedType();
            Set<UsesNodeBuilder> usesNodes = GroupingSort.getAllUsesNodes(groupingDefinition);
            for (UsesNodeBuilder usesNode : usesNodes) {
                SchemaPath schemaPath = usesNode.getGroupingBuilder().getPath();
                TopologicalSort.Node nodeTo = (TopologicalSort.Node)nodeMap.get(schemaPath);
                if (nodeTo == null) {
                    throw new IllegalArgumentException("target grouping not found for uses " + usesNode);
                }
                nodeWrappedType.addEdge(nodeTo);
            }
        }
        return resultNodes;
    }

    public static Set<UsesNodeBuilder> getAllUsesNodes(DataNodeContainerBuilder container) {
        HashSet<UsesNodeBuilder> ret = new HashSet<UsesNodeBuilder>();
        Set<UsesNodeBuilder> usesNodes = container.getUsesNodeBuilders();
        ret.addAll(usesNodes);
        for (UsesNodeBuilder usesNode : usesNodes) {
            for (AugmentationSchemaBuilder augment : usesNode.getAugmentations()) {
                ret.addAll(GroupingSort.getAllUsesNodes(augment));
            }
        }
        Set<GroupingBuilder> groupings = container.getGroupingBuilders();
        for (GroupingBuilder groupingDefinition : groupings) {
            ret.addAll(GroupingSort.getAllUsesNodes(groupingDefinition));
        }
        Set<DataSchemaNodeBuilder> childNodes = container.getChildNodeBuilders();
        for (DataSchemaNodeBuilder childNode : childNodes) {
            if (childNode instanceof DataNodeContainerBuilder) {
                ret.addAll(GroupingSort.getAllUsesNodes((DataNodeContainerBuilder)((Object)childNode)));
                continue;
            }
            if (!(childNode instanceof ChoiceBuilder)) continue;
            Set<ChoiceCaseBuilder> cases = ((ChoiceBuilder)childNode).getCases();
            for (ChoiceCaseBuilder choiceCaseNode : cases) {
                ret.addAll(GroupingSort.getAllUsesNodes(choiceCaseNode));
            }
        }
        return ret;
    }
}

