/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

final class BitImpl
implements BitsTypeDefinition.Bit {
    private final Long position;
    private final QName qname;
    private final SchemaPath schemaPath;
    private final String description;
    private final String reference;
    private final Status status;
    private List<UnknownSchemaNode> unknownNodes = Collections.emptyList();

    BitImpl(Long position, QName qname, SchemaPath schemaPath, String description, String reference, Status status, List<UnknownSchemaNode> unknownNodes) {
        this.position = position;
        this.qname = qname;
        this.schemaPath = schemaPath;
        this.description = description;
        this.reference = reference;
        this.status = status;
        if (unknownNodes != null) {
            this.unknownNodes = unknownNodes;
        }
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.schemaPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public Long getPosition() {
        return this.position;
    }

    public String getName() {
        return this.qname.getLocalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.unknownNodes == null ? 0 : this.unknownNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitsTypeDefinition.Bit other = (BitsTypeDefinition.Bit)obj;
        if (this.qname == null ? other.getQName() != null : !this.qname.equals((Object)other.getQName())) {
            return false;
        }
        return !(this.schemaPath == null ? other.getPath() != null : !this.schemaPath.equals((Object)other.getPath()));
    }

    public String toString() {
        return BitsTypeDefinition.Bit.class.getSimpleName() + "[name=" + this.qname.getLocalName() + ", position=" + this.position + "]";
    }
}

