/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProviders;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangSourceContext
implements AdvancedSchemaSourceProvider<InputStream>,
AutoCloseable {
    private final ImmutableSet<SourceIdentifier> validSources;
    private final ImmutableSet<SourceIdentifier> missingSources;
    private final ImmutableMultimap<SourceIdentifier, ModuleImport> missingDependencies;
    private AdvancedSchemaSourceProvider<InputStream> sourceProvider;

    private YangSourceContext(ImmutableSet<SourceIdentifier> validSourcesSet, ImmutableSet<SourceIdentifier> missingSourcesSet, ImmutableMultimap<SourceIdentifier, ModuleImport> missingDependenciesMap, AdvancedSchemaSourceProvider<InputStream> sourceProvicer) {
        this.validSources = validSourcesSet;
        this.missingSources = missingSourcesSet;
        this.missingDependencies = missingDependenciesMap;
        this.sourceProvider = sourceProvicer;
    }

    public ImmutableSet<SourceIdentifier> getValidSources() {
        return this.validSources;
    }

    public ImmutableSet<SourceIdentifier> getMissingSources() {
        return this.missingSources;
    }

    public ImmutableMultimap<SourceIdentifier, ModuleImport> getMissingDependencies() {
        return this.missingDependencies;
    }

    public Optional<InputStream> getSchemaSource(String moduleName, Optional<String> revision) {
        return this.getSchemaSource(SourceIdentifier.create((String)moduleName, revision));
    }

    public Optional<InputStream> getSchemaSource(SourceIdentifier sourceIdentifier) {
        if (this.validSources.contains((Object)sourceIdentifier)) {
            return this.getDelegateChecked().getSchemaSource(sourceIdentifier);
        }
        return Optional.absent();
    }

    private AdvancedSchemaSourceProvider<InputStream> getDelegateChecked() {
        Preconditions.checkState((this.sourceProvider != null ? 1 : 0) != 0, (Object)"Instance is already closed.");
        return this.sourceProvider;
    }

    @Override
    public void close() {
        if (this.sourceProvider != null) {
            this.sourceProvider = null;
        }
    }

    public static final YangSourceContext createFrom(Iterable<QName> capabilities, SchemaSourceProvider<InputStream> schemaSourceProvider) {
        YangSourceFromCapabilitiesResolver resolver = new YangSourceFromCapabilitiesResolver(capabilities, schemaSourceProvider);
        return ((YangSourceContextResolver)resolver).resolveContext();
    }

    public static final YangSourceContext createFrom(Map<SourceIdentifier, YangModelDependencyInfo> moduleDependencies) {
        YangSourceFromDependencyInfoResolver resolver = new YangSourceFromDependencyInfoResolver(moduleDependencies);
        return ((YangSourceContextResolver)resolver).resolveContext();
    }

    public static final SchemaContext toSchemaContext(YangSourceContext context) {
        List<InputStream> inputStreams = YangSourceContext.getValidInputStreams(context);
        YangParserImpl parser = new YangParserImpl();
        Set<Module> models = parser.parseYangModelsFromStreams(inputStreams);
        return parser.resolveSchemaContext(models);
    }

    public static List<InputStream> getValidInputStreams(YangSourceContext context) {
        return YangSourceContext.getValidInputStreams(context, context.sourceProvider);
    }

    public static List<InputStream> getValidInputStreams(YangSourceContext context, AdvancedSchemaSourceProvider<InputStream> provider) {
        HashSet<SourceIdentifier> sourcesToLoad = new HashSet<SourceIdentifier>();
        sourcesToLoad.addAll((Collection<SourceIdentifier>)context.getValidSources());
        for (SourceIdentifier source : context.getValidSources()) {
            if (source.getRevision() == null) continue;
            SourceIdentifier sourceWithoutRevision = SourceIdentifier.create((String)source.getName(), (Optional)Optional.absent());
            sourcesToLoad.removeAll(Collections.singleton(sourceWithoutRevision));
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (SourceIdentifier sourceIdentifier : sourcesToLoad) {
            Optional source = provider.getSchemaSource(sourceIdentifier);
            ret.add(source.get());
        }
        return ret.build();
    }

    public static final class YangSourceFromDependencyInfoResolver
    extends YangSourceContextResolver {
        private final Map<SourceIdentifier, YangModelDependencyInfo> dependencyInfo;

        public YangSourceFromDependencyInfoResolver(Map<SourceIdentifier, YangModelDependencyInfo> moduleDependencies) {
            this.dependencyInfo = ImmutableMap.copyOf(moduleDependencies);
        }

        @Override
        public Optional<YangModelDependencyInfo> getDependencyInfo(SourceIdentifier identifier) {
            if (identifier.getRevision() != null) {
                return Optional.fromNullable((Object)this.dependencyInfo.get(identifier));
            }
            YangModelDependencyInfo potential = this.dependencyInfo.get(identifier);
            if (potential == null) {
                for (Map.Entry<SourceIdentifier, YangModelDependencyInfo> newPotential : this.dependencyInfo.entrySet()) {
                    String newPotentialName = newPotential.getKey().getName();
                    if (!newPotentialName.equals(identifier.getName())) continue;
                    String newPotentialRevision = newPotential.getKey().getRevision();
                    if (potential != null && 1 != newPotentialRevision.compareTo(potential.getFormattedRevision())) continue;
                    potential = newPotential.getValue();
                }
            }
            return Optional.fromNullable((Object)potential);
        }

        @Override
        public YangSourceContext resolveContext() {
            for (SourceIdentifier source : this.dependencyInfo.keySet()) {
                this.resolveSource(source);
            }
            return this.createSourceContext();
        }
    }

    public static final class YangSourceFromCapabilitiesResolver
    extends YangSourceContextResolver {
        private Iterable<QName> capabilities;

        public YangSourceFromCapabilitiesResolver(Iterable<QName> capabilities, SchemaSourceProvider<InputStream> schemaSourceProvider) {
            super((AdvancedSchemaSourceProvider<InputStream>)SchemaSourceProviders.toAdvancedSchemaSourceProvider(schemaSourceProvider));
            this.capabilities = capabilities;
        }

        @Override
        public YangSourceContext resolveContext() {
            for (QName capability : this.capabilities) {
                this.resolveCapability(capability);
            }
            return this.createSourceContext();
        }

        private void resolveCapability(QName capability) {
            super.resolveSource(capability.getLocalName(), (Optional<String>)Optional.fromNullable((Object)capability.getFormattedRevision()));
        }

        @Override
        public Optional<YangModelDependencyInfo> getDependencyInfo(SourceIdentifier identifier) {
            Optional<InputStream> source = this.getSchemaSource(identifier);
            if (source.isPresent()) {
                return Optional.of((Object)YangModelDependencyInfo.fromInputStream((InputStream)source.get()));
            }
            return Optional.absent();
        }

        private Optional<InputStream> getSchemaSource(SourceIdentifier identifier) {
            return this.getSourceProvider().getSchemaSource(identifier.getName(), Optional.fromNullable((Object)identifier.getRevision()));
        }
    }

    private static enum ResolutionState {
        MISSING_SOURCE,
        MISSING_DEPENDENCY,
        OTHER_ERROR,
        EVERYTHING_OK;

    }

    public static abstract class YangSourceContextResolver {
        private static final Logger LOG = LoggerFactory.getLogger(YangSourceContextResolver.class);
        private final AdvancedSchemaSourceProvider<InputStream> sourceProvider;
        private final HashMap<SourceIdentifier, ResolutionState> alreadyProcessed = new HashMap();
        private final ImmutableSet.Builder<SourceIdentifier> missingSources = ImmutableSet.builder();
        private ImmutableMultimap.Builder<SourceIdentifier, ModuleImport> missingDependencies = ImmutableMultimap.builder();
        private final ImmutableSet.Builder<SourceIdentifier> validSources = ImmutableSet.builder();

        public AdvancedSchemaSourceProvider<InputStream> getSourceProvider() {
            return this.sourceProvider;
        }

        public YangSourceContextResolver() {
            this.sourceProvider = null;
        }

        public YangSourceContextResolver(AdvancedSchemaSourceProvider<InputStream> sourceProvicer) {
            this.sourceProvider = sourceProvicer;
        }

        public abstract YangSourceContext resolveContext();

        public ResolutionState resolveSource(String name, Optional<String> formattedRevision) {
            return this.resolveSource(new SourceIdentifier(name, formattedRevision));
        }

        public ResolutionState resolveSource(SourceIdentifier identifier) {
            ResolutionState potentialState;
            block5: {
                if (this.alreadyProcessed.containsKey(identifier)) {
                    return this.alreadyProcessed.get(identifier);
                }
                LOG.trace("Resolving source:\u00a0{}", (Object)identifier);
                potentialState = ResolutionState.EVERYTHING_OK;
                try {
                    Optional<YangModelDependencyInfo> potentialInfo = this.getDependencyInfo(identifier);
                    if (potentialInfo.isPresent()) {
                        YangModelDependencyInfo info = (YangModelDependencyInfo)potentialInfo.get();
                        this.checkValidSource(identifier, info);
                        for (ModuleImport dependency : info.getDependencies()) {
                            LOG.trace("Source: {} Resolving dependency: {}", (Object)identifier, (Object)dependency);
                            ResolutionState dependencyState = this.resolveDependency(dependency);
                            if (dependencyState == ResolutionState.EVERYTHING_OK) continue;
                            potentialState = ResolutionState.MISSING_DEPENDENCY;
                            this.missingDependencies.put((Object)identifier, (Object)dependency);
                        }
                        break block5;
                    }
                    this.missingSources.add((Object)identifier);
                    return ResolutionState.MISSING_SOURCE;
                }
                catch (Exception e) {
                    potentialState = ResolutionState.OTHER_ERROR;
                }
            }
            this.updateResolutionState(identifier, potentialState);
            return potentialState;
        }

        public abstract Optional<YangModelDependencyInfo> getDependencyInfo(SourceIdentifier var1);

        private boolean checkValidSource(SourceIdentifier identifier, YangModelDependencyInfo info) {
            if (!identifier.getName().equals(info.getName())) {
                LOG.warn("Incorrect model returned. Identifier name was: {}, source contained: {}", (Object)identifier.getName(), (Object)info.getName());
                throw new IllegalStateException("Incorrect source was returned");
            }
            return true;
        }

        private void updateResolutionState(SourceIdentifier identifier, ResolutionState potentialState) {
            this.alreadyProcessed.put(identifier, potentialState);
            switch (potentialState) {
                case MISSING_SOURCE: {
                    this.missingSources.add((Object)identifier);
                    break;
                }
                case EVERYTHING_OK: {
                    this.validSources.add((Object)identifier);
                    break;
                }
            }
        }

        private ResolutionState resolveDependency(ModuleImport dependency) {
            String name = dependency.getModuleName();
            Optional formattedRevision = Optional.fromNullable((Object)QName.formattedRevision((Date)dependency.getRevision()));
            return this.resolveSource(new SourceIdentifier(name, formattedRevision));
        }

        protected YangSourceContext createSourceContext() {
            ImmutableSet missingSourcesSet = this.missingSources.build();
            ImmutableMultimap missingDependenciesMap = this.missingDependencies.build();
            ImmutableSet validSourcesSet = this.validSources.build();
            return new YangSourceContext(validSourcesSet, missingSourcesSet, missingDependenciesMap, this.sourceProvider);
        }
    }
}

