/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.util.ParserListenerUtils;

public abstract class YangModelDependencyInfo {
    private final String name;
    private final String formattedRevision;
    private final Date revision;
    private final ImmutableSet<ModuleImport> submoduleIncludes;
    private final ImmutableSet<ModuleImport> moduleImports;
    private final ImmutableSet<ModuleImport> dependencies;

    public YangModelDependencyInfo(String name, String formattedRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
        this.name = name;
        this.formattedRevision = formattedRevision;
        this.revision = QName.parseRevision((String)formattedRevision);
        this.moduleImports = imports;
        this.submoduleIncludes = includes;
        this.dependencies = ImmutableSet.builder().addAll(this.moduleImports).addAll(this.submoduleIncludes).build();
    }

    public ImmutableSet<ModuleImport> getDependencies() {
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getFormattedRevision() {
        return this.formattedRevision;
    }

    public Date getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formattedRevision == null ? 0 : this.formattedRevision.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YangModelDependencyInfo)) {
            return false;
        }
        YangModelDependencyInfo other = (YangModelDependencyInfo)obj;
        if (this.formattedRevision == null ? other.formattedRevision != null : !this.formattedRevision.equals(other.formattedRevision)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static YangModelDependencyInfo fromInputStream(InputStream yangStream) {
        YangParser.YangContext yangContext = YangParserImpl.parseStreamWithoutErrorListeners(yangStream);
        Optional<YangParser.Module_stmtContext> moduleCtx = ParserListenerUtils.getFirstContext(yangContext, YangParser.Module_stmtContext.class);
        if (moduleCtx.isPresent()) {
            return YangModelDependencyInfo.fromModuleContext((YangParser.Module_stmtContext)((Object)moduleCtx.get()));
        }
        Optional<YangParser.Submodule_stmtContext> submoduleCtx = ParserListenerUtils.getFirstContext(yangContext, YangParser.Submodule_stmtContext.class);
        if (submoduleCtx.isPresent()) {
            return YangModelDependencyInfo.fromSubmoduleContext((YangParser.Submodule_stmtContext)((Object)submoduleCtx.get()));
        }
        throw new IllegalArgumentException("Supplied stream is not valid yang file.");
    }

    private static YangModelDependencyInfo fromModuleContext(YangParser.Module_stmtContext module) {
        String name = ParserListenerUtils.getArgumentString(module);
        String namespace = ParserListenerUtils.getArgumentString(module.module_header_stmts().namespace_stmt(0));
        String latestRevision = YangModelDependencyInfo.getLatestRevision(module.revision_stmts());
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.getImports(module.linkage_stmts().import_stmt());
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.getIncludes(module.linkage_stmts().include_stmt());
        return new ModuleDependencyInfo(name, latestRevision, namespace, imports, includes);
    }

    private static ImmutableSet<ModuleImport> getImports(List<YangParser.Import_stmtContext> importStatements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (YangParser.Import_stmtContext importStmt : importStatements) {
            String moduleName = ParserListenerUtils.getArgumentString(importStmt);
            Date revision = YangModelDependencyInfo.getRevision(importStmt.revision_date_stmt());
            String prefix = ParserListenerUtils.getArgumentString(importStmt.prefix_stmt());
            builder.add((Object)new ModuleImportImpl(moduleName, revision));
        }
        return builder.build();
    }

    private static String getLatestRevision(YangParser.Revision_stmtsContext revision_stmts) {
        List revisions = revision_stmts.getRuleContexts(YangParser.Revision_stmtContext.class);
        String latestRevision = null;
        for (YangParser.Revision_stmtContext revisionStmt : revisions) {
            String currentRevision = ParserListenerUtils.getArgumentString(revisionStmt);
            if (latestRevision != null && latestRevision.compareTo(currentRevision) != -1) continue;
            latestRevision = currentRevision;
        }
        return latestRevision;
    }

    private static YangModelDependencyInfo fromSubmoduleContext(YangParser.Submodule_stmtContext submodule) {
        String name = ParserListenerUtils.getArgumentString(submodule);
        YangParser.Belongs_to_stmtContext belongsToStmt = submodule.submodule_header_stmts().belongs_to_stmt(0);
        String belongsTo = ParserListenerUtils.getArgumentString(belongsToStmt);
        String latestRevision = YangModelDependencyInfo.getLatestRevision(submodule.revision_stmts());
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.getImports(submodule.linkage_stmts().import_stmt());
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.getIncludes(submodule.linkage_stmts().include_stmt());
        return new SubmoduleDependencyInfo(name, latestRevision, belongsTo, imports, includes);
    }

    private static ImmutableSet<ModuleImport> getIncludes(List<YangParser.Include_stmtContext> importStatements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (YangParser.Include_stmtContext importStmt : importStatements) {
            String moduleName = ParserListenerUtils.getArgumentString(importStmt);
            Date revision = YangModelDependencyInfo.getRevision(importStmt.revision_date_stmt());
            builder.add((Object)new ModuleImportImpl(moduleName, revision));
        }
        return builder.build();
    }

    private static Date getRevision(YangParser.Revision_date_stmtContext revision_date_stmt) {
        if (revision_date_stmt == null) {
            return null;
        }
        String formatedDate = ParserListenerUtils.getArgumentString(revision_date_stmt);
        return QName.parseRevision((String)formatedDate);
    }

    private static final class ModuleImportImpl
    implements ModuleImport {
        private Date revision;
        private String name;

        public ModuleImportImpl(String moduleName, Date revision) {
            this.name = moduleName;
            this.revision = revision;
        }

        public String getModuleName() {
            return this.name;
        }

        public Date getRevision() {
            return this.revision;
        }

        public String getPrefix() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleImportImpl other = (ModuleImportImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
        }

        public String toString() {
            return "ModuleImportImpl [name=" + this.name + ", revision=" + QName.formattedRevision((Date)this.revision) + "]";
        }
    }

    public static final class SubmoduleDependencyInfo
    extends YangModelDependencyInfo {
        private final String belongsTo;

        public String getParentModule() {
            return this.belongsTo;
        }

        private SubmoduleDependencyInfo(String name, String latestRevision, String belongsTo, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
            this.belongsTo = belongsTo;
        }

        public String toString() {
            return "Submodule [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }

    public static final class ModuleDependencyInfo
    extends YangModelDependencyInfo {
        private ModuleDependencyInfo(String name, String latestRevision, String namespace, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
        }

        public String toString() {
            return "Module [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }
}

