/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLSchemaContextResolver
implements AdvancedSchemaSourceProvider<InputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(URLSchemaContextResolver.class);
    private final ConcurrentMap<SourceIdentifier, SourceContext> availableSources = new ConcurrentHashMap<SourceIdentifier, SourceContext>();
    private YangSourceContext currentSourceContext;
    private Optional<SchemaContext> currentSchemaContext = Optional.absent();

    public Registration<URL> registerSource(URL source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"Supplied source must not be null");
        InputStream yangStream = this.getInputStream(source);
        YangModelDependencyInfo modelInfo = YangModelDependencyInfo.fromInputStream(yangStream);
        SourceIdentifier identifier = SourceIdentifier.create((String)modelInfo.getName(), (Optional)Optional.of((Object)modelInfo.getFormattedRevision()));
        SourceContext sourceContext = new SourceContext(source, identifier, modelInfo);
        this.availableSources.putIfAbsent(identifier, sourceContext);
        return sourceContext;
    }

    public Optional<SchemaContext> getSchemaContext() {
        return this.currentSchemaContext;
    }

    public Optional<InputStream> getSchemaSource(SourceIdentifier key) {
        SourceContext ctx = (SourceContext)((Object)this.availableSources.get(key));
        if (ctx != null) {
            InputStream stream = this.getInputStream((URL)ctx.getInstance());
            return Optional.fromNullable((Object)stream);
        }
        return Optional.absent();
    }

    public Optional<InputStream> getSchemaSource(String name, Optional<String> version) {
        return this.getSchemaSource(SourceIdentifier.create((String)name, version));
    }

    private InputStream getInputStream(URL source) {
        InputStream stream;
        try {
            stream = source.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Supplied stream: " + source + " is not available", e);
        }
        return stream;
    }

    private void removeSource(SourceContext sourceContext) {
        boolean removed = this.availableSources.remove(sourceContext.getIdentifier(), (Object)sourceContext);
        if (removed) {
            this.tryToUpdateSchemaContext();
        }
    }

    public synchronized Optional<SchemaContext> tryToUpdateSchemaContext() {
        if (this.availableSources.isEmpty()) {
            return Optional.absent();
        }
        ImmutableMap actualSources = ImmutableMap.copyOf(this.availableSources);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : actualSources.entrySet()) {
            builder.put(entry.getKey(), (Object)((SourceContext)((Object)entry.getValue())).getDependencyInfo());
        }
        ImmutableMap sourcesMap = builder.build();
        YangSourceContext context = YangSourceContext.createFrom((Map<SourceIdentifier, YangModelDependencyInfo>)sourcesMap);
        LOG.debug("Trying to create schema context from {}", (Object)sourcesMap.keySet());
        if (context.getMissingDependencies().size() != 0) {
            LOG.debug("Omitting {} because of unresolved dependencies", (Object)context.getMissingDependencies().keySet());
            LOG.debug("Missing model sources for {}", context.getMissingSources());
        }
        try {
            if (this.currentSourceContext == null || !context.getValidSources().equals(this.currentSourceContext.getValidSources())) {
                List<InputStream> streams = YangSourceContext.getValidInputStreams(context, this);
                YangParserImpl parser = new YangParserImpl();
                Set<Module> modules = parser.parseYangModelsFromStreams(streams);
                SchemaContext schemaContext = parser.resolveSchemaContext(modules);
                this.currentSchemaContext = Optional.of((Object)schemaContext);
                this.currentSourceContext = context;
                return this.currentSchemaContext;
            }
            this.currentSourceContext = context;
        }
        catch (Exception e) {
            LOG.error("Could not create schema context for {} ", context.getValidSources());
        }
        return Optional.absent();
    }

    private final class SourceContext
    extends AbstractObjectRegistration<URL>
    implements Identifiable<SourceIdentifier> {
        final SourceIdentifier identifier;
        final YangModelDependencyInfo dependencyInfo;

        public SourceContext(URL instance, SourceIdentifier identifier, YangModelDependencyInfo modelInfo) {
            super((Object)instance);
            this.identifier = identifier;
            this.dependencyInfo = modelInfo;
        }

        public SourceIdentifier getIdentifier() {
            return this.identifier;
        }

        protected void removeRegistration() {
            URLSchemaContextResolver.this.removeSource(this);
        }

        public YangModelDependencyInfo getDependencyInfo() {
            return this.dependencyInfo;
        }
    }
}

