/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Strings;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParserBaseListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.YangTypesConverter;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.DeviationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.FeatureBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.ParserListenerUtils;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangParserListenerImpl
extends YangParserBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(YangParserListenerImpl.class);
    private static final String AUGMENT_STR = "augment";
    private final String sourcePath;
    private ModuleBuilder moduleBuilder;
    private String moduleName;
    private URI namespace;
    private String yangModelPrefix;
    private Date revision = new Date(0L);
    private final DateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final Stack<Stack<QName>> actualPath = new Stack();

    private void addNodeToPath(QName name) {
        this.actualPath.peek().push(name);
    }

    private QName removeNodeFromPath() {
        return this.actualPath.peek().pop();
    }

    public YangParserListenerImpl(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Override
    public void enterModule_stmt(YangParser.Module_stmtContext ctx) {
        this.moduleName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        LOGGER.debug("entering module " + this.moduleName);
        this.enterLog("module", this.moduleName, 0);
        this.actualPath.push(new Stack());
        this.moduleBuilder = new ModuleBuilder(this.moduleName, this.sourcePath);
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (description != null && reference != null) break;
        }
        this.moduleBuilder.setDescription(description);
        this.moduleBuilder.setReference(reference);
    }

    @Override
    public void exitModule_stmt(YangParser.Module_stmtContext ctx) {
        this.exitLog("module", "");
        this.actualPath.pop();
    }

    @Override
    public void enterSubmodule_stmt(YangParser.Submodule_stmtContext ctx) {
        this.moduleName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        LOGGER.debug("entering submodule " + this.moduleName);
        this.enterLog("submodule", this.moduleName, 0);
        this.actualPath.push(new Stack());
        this.moduleBuilder = new ModuleBuilder(this.moduleName, true, this.sourcePath);
        String description = null;
        String reference = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                description = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (description != null && reference != null) break;
        }
        this.moduleBuilder.setDescription(description);
        this.moduleBuilder.setReference(reference);
    }

    @Override
    public void exitSubmodule_stmt(YangParser.Submodule_stmtContext ctx) {
        this.exitLog("submodule", "");
        this.actualPath.pop();
    }

    @Override
    public void enterBelongs_to_stmt(YangParser.Belongs_to_stmtContext ctx) {
        this.moduleBuilder.setBelongsTo(ParserListenerUtils.stringFromNode((ParseTree)ctx));
    }

    @Override
    public void enterModule_header_stmts(YangParser.Module_header_stmtsContext ctx) {
        this.enterLog("module_header", "", ctx.getStart().getLine());
        String yangVersion = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (treeNode instanceof YangParser.Namespace_stmtContext) {
                String namespaceStr = ParserListenerUtils.stringFromNode(treeNode);
                this.namespace = URI.create(namespaceStr);
                this.moduleBuilder.setNamespace(this.namespace);
                this.setLog("namespace", namespaceStr);
                continue;
            }
            if (treeNode instanceof YangParser.Prefix_stmtContext) {
                this.yangModelPrefix = ParserListenerUtils.stringFromNode(treeNode);
                this.moduleBuilder.setPrefix(this.yangModelPrefix);
                this.setLog("prefix", this.yangModelPrefix);
                continue;
            }
            if (!(treeNode instanceof YangParser.Yang_version_stmtContext)) continue;
            yangVersion = ParserListenerUtils.stringFromNode(treeNode);
            this.setLog("yang-version", yangVersion);
        }
        if (yangVersion == null) {
            yangVersion = "1";
        }
        this.moduleBuilder.setYangVersion(yangVersion);
    }

    @Override
    public void exitModule_header_stmts(YangParser.Module_header_stmtsContext ctx) {
        this.exitLog("module_header", "");
    }

    @Override
    public void enterMeta_stmts(YangParser.Meta_stmtsContext ctx) {
        this.enterLog("meta_stmt", "", ctx.getStart().getLine());
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Organization_stmtContext) {
                String organization = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setOrganization(organization);
                this.setLog("organization", organization);
                continue;
            }
            if (child instanceof YangParser.Contact_stmtContext) {
                String contact = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setContact(contact);
                this.setLog("contact", contact);
                continue;
            }
            if (child instanceof YangParser.Description_stmtContext) {
                String description = ParserListenerUtils.stringFromNode(child);
                this.moduleBuilder.setDescription(description);
                this.setLog("description", description);
                continue;
            }
            if (!(child instanceof YangParser.Reference_stmtContext)) continue;
            String reference = ParserListenerUtils.stringFromNode(child);
            this.moduleBuilder.setReference(reference);
            this.setLog("reference", reference);
        }
    }

    @Override
    public void exitMeta_stmts(YangParser.Meta_stmtsContext ctx) {
        this.exitLog("meta_stmt", "");
    }

    @Override
    public void enterRevision_stmts(YangParser.Revision_stmtsContext ctx) {
        this.enterLog("revisions", "", ctx.getStart().getLine());
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (!(treeNode instanceof YangParser.Revision_stmtContext)) continue;
            this.updateRevisionForRevisionStatement(treeNode);
        }
    }

    @Override
    public void exitRevision_stmts(YangParser.Revision_stmtsContext ctx) {
        this.exitLog("revisions", "");
    }

    private void updateRevisionForRevisionStatement(ParseTree treeNode) {
        String revisionDateStr = ParserListenerUtils.stringFromNode(treeNode);
        try {
            Date revisionDate = this.SIMPLE_DATE_FORMAT.parse(revisionDateStr);
            if (revisionDate != null && this.revision.compareTo(revisionDate) < 0) {
                this.revision = revisionDate;
                this.moduleBuilder.setRevision(this.revision);
                this.setLog("revision", this.revision.toString());
                for (int i = 0; i < treeNode.getChildCount(); ++i) {
                    ParseTree child = treeNode.getChild(i);
                    if (!(child instanceof YangParser.Reference_stmtContext)) continue;
                    this.moduleBuilder.setReference(ParserListenerUtils.stringFromNode(child));
                }
            }
        }
        catch (ParseException e) {
            String message = "Failed to parse revision string: " + revisionDateStr;
            LOGGER.warn(message);
        }
    }

    @Override
    public void enterImport_stmt(YangParser.Import_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String importName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("import", importName, line);
        String importPrefix = null;
        Date importRevision = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree treeNode = ctx.getChild(i);
            if (treeNode instanceof YangParser.Prefix_stmtContext) {
                importPrefix = ParserListenerUtils.stringFromNode(treeNode);
            }
            if (!(treeNode instanceof YangParser.Revision_date_stmtContext)) continue;
            String importRevisionStr = ParserListenerUtils.stringFromNode(treeNode);
            try {
                importRevision = this.SIMPLE_DATE_FORMAT.parse(importRevisionStr);
                continue;
            }
            catch (ParseException e) {
                LOGGER.warn("Failed to parse import revision-date at line " + line + ": " + importRevisionStr);
            }
        }
        this.moduleBuilder.addModuleImport(importName, importRevision, importPrefix);
        this.setLog("import", "(" + importName + "; " + importRevision + "; " + importPrefix + ")");
    }

    @Override
    public void exitImport_stmt(YangParser.Import_stmtContext ctx) {
        this.exitLog("import", "");
    }

    @Override
    public void enterAugment_stmt(YangParser.Augment_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String augmentPath = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog(AUGMENT_STR, augmentPath, line);
        this.actualPath.push(new Stack());
        AugmentationSchemaBuilder builder = this.moduleBuilder.addAugment(line, augmentPath);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                builder.setDescription(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                builder.setReference(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Status_stmtContext) {
                builder.setStatus(ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child));
                continue;
            }
            if (!(child instanceof YangParser.When_stmtContext)) continue;
            builder.addWhenCondition(ParserListenerUtils.stringFromNode(child));
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitAugment_stmt(YangParser.Augment_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog(AUGMENT_STR, "");
        this.actualPath.pop();
    }

    @Override
    public void enterExtension_stmt(YangParser.Extension_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String extName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("extension", extName, line);
        QName qname = new QName(this.namespace, this.revision, this.yangModelPrefix, extName);
        this.addNodeToPath(qname);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ExtensionBuilder builder = this.moduleBuilder.addExtension(qname, line, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        String argument = null;
        boolean yin = false;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Argument_stmtContext)) continue;
            argument = ParserListenerUtils.stringFromNode(child);
            yin = ParserListenerUtils.parseYinValue((YangParser.Argument_stmtContext)child);
            break;
        }
        builder.setArgument(argument);
        builder.setYinElement(yin);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitExtension_stmt(YangParser.Extension_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("extension", this.removeNodeFromPath());
    }

    @Override
    public void enterTypedef_stmt(YangParser.Typedef_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String typedefName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("typedef", typedefName, line);
        QName typedefQName = new QName(this.namespace, this.revision, this.yangModelPrefix, typedefName);
        this.addNodeToPath(typedefQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        TypeDefinitionBuilderImpl builder = this.moduleBuilder.addTypedef(line, typedefQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        builder.setUnits(ParserListenerUtils.parseUnits((ParseTree)ctx));
        builder.setDefaultValue(ParserListenerUtils.parseDefault((ParseTree)ctx));
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitTypedef_stmt(YangParser.Typedef_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("typedef", this.removeNodeFromPath());
    }

    @Override
    public void enterType_stmt(YangParser.Type_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String typeName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("type", typeName, line);
        QName typeQName = this.parseQName(typeName);
        TypeDefinition<?> type = null;
        YangParser.Type_body_stmtsContext typeBody = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!(ctx.getChild(i) instanceof YangParser.Type_body_stmtsContext)) continue;
            typeBody = (YangParser.Type_body_stmtsContext)ctx.getChild(i);
            break;
        }
        if (YangTypesConverter.isBaseYangType((String)typeName)) {
            if (typeBody == null) {
                ParserListenerUtils.checkMissingBody(typeName, this.moduleName, line);
                type = YangTypesConverter.javaTypeForBaseYangType((String)typeName);
                this.addNodeToPath(type.getQName());
                this.moduleBuilder.setType(type);
            } else {
                switch (typeName) {
                    case "union": {
                        QName qname = BaseTypes.constructQName((String)"union");
                        this.addNodeToPath(qname);
                        UnionTypeBuilder unionBuilder = this.moduleBuilder.addUnionType(line, this.namespace, this.revision);
                        Builder parent = this.moduleBuilder.getActualNode();
                        unionBuilder.setParent(parent);
                        this.moduleBuilder.enterNode(unionBuilder);
                        break;
                    }
                    case "identityref": {
                        QName qname = BaseTypes.constructQName((String)"identityref");
                        this.addNodeToPath(qname);
                        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
                        this.moduleBuilder.addIdentityrefType(line, path, ParserListenerUtils.getIdentityrefBase(typeBody));
                        break;
                    }
                    default: {
                        type = ParserListenerUtils.parseTypeWithBody(typeName, typeBody, this.actualPath.peek(), this.namespace, this.revision, this.yangModelPrefix, this.moduleBuilder.getActualNode());
                        this.moduleBuilder.setType(type);
                        this.addNodeToPath(type.getQName());
                        break;
                    }
                }
            }
        } else {
            type = ParserListenerUtils.parseUnknownTypeWithBody(typeQName, typeBody, this.actualPath.peek(), this.namespace, this.revision, this.yangModelPrefix, this.moduleBuilder.getActualNode());
            this.moduleBuilder.markActualNodeDirty();
            this.moduleBuilder.setType(type);
            this.addNodeToPath(type.getQName());
        }
    }

    private QName parseQName(String typeName) {
        QName typeQName;
        if (typeName.contains(":")) {
            String[] splittedName = typeName.split(":");
            String prefix = splittedName[0];
            String name = splittedName[1];
            typeQName = prefix.equals(this.yangModelPrefix) ? new QName(this.namespace, this.revision, prefix, name) : new QName(null, null, prefix, name);
        } else {
            typeQName = new QName(this.namespace, this.revision, this.yangModelPrefix, typeName);
        }
        return typeQName;
    }

    @Override
    public void exitType_stmt(YangParser.Type_stmtContext ctx) {
        String typeName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        if ("union".equals(typeName)) {
            this.moduleBuilder.exitNode();
        }
        this.exitLog("type", this.removeNodeFromPath());
    }

    @Override
    public void enterGrouping_stmt(YangParser.Grouping_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String groupName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("grouping", groupName, line);
        QName groupQName = new QName(this.namespace, this.revision, this.yangModelPrefix, groupName);
        this.addNodeToPath(groupQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        GroupingBuilder builder = this.moduleBuilder.addGrouping(ctx.getStart().getLine(), groupQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitGrouping_stmt(YangParser.Grouping_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("grouping", this.removeNodeFromPath());
    }

    @Override
    public void enterContainer_stmt(YangParser.Container_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String containerName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("container", containerName, line);
        QName containerQName = new QName(this.namespace, this.revision, this.yangModelPrefix, containerName);
        this.addNodeToPath(containerQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addContainerNode(line, containerQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, line));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (!(childNode instanceof YangParser.Presence_stmtContext)) continue;
            builder.setPresence(true);
            break;
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitContainer_stmt(YangParser.Container_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("container", this.removeNodeFromPath());
    }

    @Override
    public void enterLeaf_stmt(YangParser.Leaf_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String leafName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("leaf", leafName, line);
        QName leafQName = new QName(this.namespace, this.revision, this.yangModelPrefix, leafName);
        this.addNodeToPath(leafQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        LeafSchemaNodeBuilder builder = this.moduleBuilder.addLeafNode(line, leafQName, path);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, line));
        String defaultStr = null;
        String unitsStr = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Default_stmtContext) {
                defaultStr = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Units_stmtContext)) continue;
            unitsStr = ParserListenerUtils.stringFromNode(child);
        }
        builder.setDefaultStr(defaultStr);
        builder.setUnits(unitsStr);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitLeaf_stmt(YangParser.Leaf_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("leaf", this.removeNodeFromPath());
    }

    @Override
    public void enterUses_stmt(YangParser.Uses_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String groupingPathStr = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("uses", groupingPathStr, line);
        UsesNodeBuilder builder = this.moduleBuilder.addUsesNode(line, groupingPathStr);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitUses_stmt(YangParser.Uses_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("uses", "");
    }

    @Override
    public void enterUses_augment_stmt(YangParser.Uses_augment_stmtContext ctx) {
        this.actualPath.push(new Stack());
        int line = ctx.getStart().getLine();
        String augmentPath = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog(AUGMENT_STR, augmentPath, line);
        AugmentationSchemaBuilder builder = this.moduleBuilder.addAugment(line, augmentPath);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Description_stmtContext) {
                builder.setDescription(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Reference_stmtContext) {
                builder.setReference(ParserListenerUtils.stringFromNode(child));
                continue;
            }
            if (child instanceof YangParser.Status_stmtContext) {
                builder.setStatus(ParserListenerUtils.parseStatus((YangParser.Status_stmtContext)child));
                continue;
            }
            if (!(child instanceof YangParser.When_stmtContext)) continue;
            builder.addWhenCondition(ParserListenerUtils.stringFromNode(child));
        }
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitUses_augment_stmt(YangParser.Uses_augment_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog(AUGMENT_STR, "");
        this.actualPath.pop();
    }

    @Override
    public void enterRefine_stmt(YangParser.Refine_stmtContext ctx) {
        String refineString = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("refine", refineString, ctx.getStart().getLine());
        RefineHolder refine = ParserListenerUtils.parseRefine(ctx, this.moduleName);
        this.moduleBuilder.addRefine(refine);
        this.moduleBuilder.enterNode(refine);
    }

    @Override
    public void exitRefine_stmt(YangParser.Refine_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("refine", "");
    }

    @Override
    public void enterLeaf_list_stmt(YangParser.Leaf_list_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String leafListName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("leaf-list", leafListName, line);
        QName leafListQName = new QName(this.namespace, this.revision, this.yangModelPrefix, leafListName);
        this.addNodeToPath(leafListQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        LeafListSchemaNodeBuilder builder = this.moduleBuilder.addLeafListNode(line, leafListQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, ctx.getStart().getLine()));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (!(childNode instanceof YangParser.Ordered_by_stmtContext)) continue;
            YangParser.Ordered_by_stmtContext orderedBy = (YangParser.Ordered_by_stmtContext)childNode;
            boolean userOrdered = ParserListenerUtils.parseUserOrdered(orderedBy);
            builder.setUserOrdered(userOrdered);
            break;
        }
    }

    @Override
    public void exitLeaf_list_stmt(YangParser.Leaf_list_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("leaf-list", this.removeNodeFromPath());
    }

    @Override
    public void enterList_stmt(YangParser.List_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String listName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("list", listName, line);
        QName listQName = new QName(this.namespace, this.revision, this.yangModelPrefix, listName);
        this.addNodeToPath(listQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ListSchemaNodeBuilder builder = this.moduleBuilder.addListNode(line, listQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, line));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree childNode = ctx.getChild(i);
            if (childNode instanceof YangParser.Ordered_by_stmtContext) {
                YangParser.Ordered_by_stmtContext orderedBy = (YangParser.Ordered_by_stmtContext)childNode;
                boolean userOrdered = ParserListenerUtils.parseUserOrdered(orderedBy);
                builder.setUserOrdered(userOrdered);
                continue;
            }
            if (!(childNode instanceof YangParser.Key_stmtContext)) continue;
            List<String> key = ParserListenerUtils.createListKey((YangParser.Key_stmtContext)childNode);
            builder.setKeys(key);
        }
    }

    @Override
    public void exitList_stmt(YangParser.List_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("list", this.removeNodeFromPath());
    }

    @Override
    public void enterAnyxml_stmt(YangParser.Anyxml_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String anyXmlName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("anyxml", anyXmlName, line);
        QName anyXmlQName = new QName(this.namespace, this.revision, this.yangModelPrefix, anyXmlName);
        this.addNodeToPath(anyXmlQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        AnyXmlBuilder builder = this.moduleBuilder.addAnyXml(line, anyXmlQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, line));
    }

    @Override
    public void exitAnyxml_stmt(YangParser.Anyxml_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("anyxml", this.removeNodeFromPath());
    }

    @Override
    public void enterChoice_stmt(YangParser.Choice_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String choiceName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("choice", choiceName, line);
        QName choiceQName = new QName(this.namespace, this.revision, this.yangModelPrefix, choiceName);
        this.addNodeToPath(choiceQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ChoiceBuilder builder = this.moduleBuilder.addChoice(line, choiceQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
        builder.setConfiguration(ParserListenerUtils.getConfig((ParseTree)ctx, this.moduleBuilder.getActualParent(), this.moduleName, line));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Default_stmtContext)) continue;
            String defaultCase = ParserListenerUtils.stringFromNode(child);
            builder.setDefaultCase(defaultCase);
            break;
        }
    }

    @Override
    public void exitChoice_stmt(YangParser.Choice_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("choice", this.removeNodeFromPath());
    }

    @Override
    public void enterCase_stmt(YangParser.Case_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String caseName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("case", caseName, line);
        QName caseQName = new QName(this.namespace, this.revision, this.yangModelPrefix, caseName);
        this.addNodeToPath(caseQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ChoiceCaseBuilder builder = this.moduleBuilder.addCase(line, caseQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitCase_stmt(YangParser.Case_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("case", this.removeNodeFromPath());
    }

    @Override
    public void enterNotification_stmt(YangParser.Notification_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String notificationName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("notification", notificationName, line);
        QName notificationQName = new QName(this.namespace, this.revision, this.yangModelPrefix, notificationName);
        this.addNodeToPath(notificationQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        NotificationBuilder builder = this.moduleBuilder.addNotification(line, notificationQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
    }

    @Override
    public void exitNotification_stmt(YangParser.Notification_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("notification", this.removeNodeFromPath());
    }

    @Override
    public void enterIdentifier_stmt(YangParser.Identifier_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String nodeParameter = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("unknown-node", nodeParameter, line);
        String nodeTypeStr = ctx.getChild(0).getText();
        String[] splittedElement = nodeTypeStr.split(":");
        QName nodeType = splittedElement.length == 1 ? new QName(this.namespace, this.revision, this.yangModelPrefix, splittedElement[0]) : new QName(this.namespace, this.revision, splittedElement[0], splittedElement[1]);
        QName qname = null;
        try {
            String[] splittedName;
            qname = !Strings.isNullOrEmpty((String)nodeParameter) ? ((splittedName = nodeParameter.split(":")).length == 2 ? new QName(null, null, splittedName[0], splittedName[1]) : new QName(this.namespace, this.revision, this.yangModelPrefix, splittedName[0])) : nodeType;
        }
        catch (IllegalArgumentException e) {
            qname = nodeType;
        }
        this.addNodeToPath(qname);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        UnknownSchemaNodeBuilder builder = this.moduleBuilder.addUnknownSchemaNode(line, qname, path);
        builder.setNodeType(nodeType);
        builder.setNodeParameter(nodeParameter);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        this.moduleBuilder.enterNode(builder);
    }

    @Override
    public void exitIdentifier_stmt(YangParser.Identifier_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("unknown-node", this.removeNodeFromPath());
    }

    @Override
    public void enterRpc_stmt(YangParser.Rpc_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String rpcName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("rpc", rpcName, line);
        QName rpcQName = new QName(this.namespace, this.revision, this.yangModelPrefix, rpcName);
        this.addNodeToPath(rpcQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        RpcDefinitionBuilder rpcBuilder = this.moduleBuilder.addRpc(line, rpcQName, path);
        this.moduleBuilder.enterNode(rpcBuilder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, rpcBuilder);
    }

    @Override
    public void exitRpc_stmt(YangParser.Rpc_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("rpc", this.removeNodeFromPath());
    }

    @Override
    public void enterInput_stmt(YangParser.Input_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String input = "input";
        this.enterLog("input", "input", line);
        QName rpcQName = new QName(this.namespace, this.revision, this.yangModelPrefix, "input");
        this.addNodeToPath(rpcQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addRpcInput(line, rpcQName, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitInput_stmt(YangParser.Input_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("input", this.removeNodeFromPath());
    }

    @Override
    public void enterOutput_stmt(YangParser.Output_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String output = "output";
        this.enterLog("output", "output", line);
        QName rpcQName = new QName(this.namespace, this.revision, this.yangModelPrefix, "output");
        this.addNodeToPath(rpcQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        ContainerSchemaNodeBuilder builder = this.moduleBuilder.addRpcOutput(path, rpcQName, line);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        ParserListenerUtils.parseConstraints((ParseTree)ctx, builder.getConstraints());
    }

    @Override
    public void exitOutput_stmt(YangParser.Output_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("output", this.removeNodeFromPath());
    }

    @Override
    public void enterFeature_stmt(YangParser.Feature_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String featureName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("feature", featureName, line);
        QName featureQName = new QName(this.namespace, this.revision, this.yangModelPrefix, featureName);
        this.addNodeToPath(featureQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        FeatureBuilder featureBuilder = this.moduleBuilder.addFeature(line, featureQName, path);
        this.moduleBuilder.enterNode(featureBuilder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, featureBuilder);
    }

    @Override
    public void exitFeature_stmt(YangParser.Feature_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("feature", this.removeNodeFromPath());
    }

    @Override
    public void enterDeviation_stmt(YangParser.Deviation_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String targetPath = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("deviation", targetPath, line);
        String reference = null;
        String deviate = null;
        DeviationBuilder builder = this.moduleBuilder.addDeviation(line, targetPath);
        this.moduleBuilder.enterNode(builder);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof YangParser.Reference_stmtContext) {
                reference = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_not_supported_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_add_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (child instanceof YangParser.Deviate_replace_stmtContext) {
                deviate = ParserListenerUtils.stringFromNode(child);
                continue;
            }
            if (!(child instanceof YangParser.Deviate_delete_stmtContext)) continue;
            deviate = ParserListenerUtils.stringFromNode(child);
        }
        builder.setReference(reference);
        builder.setDeviate(deviate);
    }

    @Override
    public void exitDeviation_stmt(YangParser.Deviation_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("deviation", "");
    }

    @Override
    public void enterIdentity_stmt(YangParser.Identity_stmtContext ctx) {
        int line = ctx.getStart().getLine();
        String identityName = ParserListenerUtils.stringFromNode((ParseTree)ctx);
        this.enterLog("identity", identityName, line);
        QName identityQName = new QName(this.namespace, this.revision, this.yangModelPrefix, identityName);
        this.addNodeToPath(identityQName);
        SchemaPath path = ParserListenerUtils.createActualSchemaPath(this.actualPath.peek());
        IdentitySchemaNodeBuilder builder = this.moduleBuilder.addIdentity(identityQName, line, path);
        this.moduleBuilder.enterNode(builder);
        ParserListenerUtils.parseSchemaNodeArgs((ParseTree)ctx, builder);
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child instanceof YangParser.Base_stmtContext)) continue;
            String baseIdentityName = ParserListenerUtils.stringFromNode(child);
            builder.setBaseIdentityName(baseIdentityName);
        }
    }

    @Override
    public void exitIdentity_stmt(YangParser.Identity_stmtContext ctx) {
        this.moduleBuilder.exitNode();
        this.exitLog("identity", this.removeNodeFromPath());
    }

    public ModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    private void enterLog(String p1, String p2, int line) {
        LOGGER.trace("entering {} {} ({})", new Object[]{p1, p2, line});
    }

    private void exitLog(String p1, String p2) {
        LOGGER.trace("exiting {} {}", (Object)p1, (Object)p2);
    }

    private void exitLog(String p1, QName p2) {
        LOGGER.trace("exiting {} {}", (Object)p1, (Object)p2.getLocalName());
    }

    private void setLog(String p1, String p2) {
        LOGGER.trace("setting {} {}", (Object)p1, (Object)p2);
    }
}

