/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.antlrv4.code.gen.YangLexer;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.parser.api.YangModelParser;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.DeviationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.impl.SchemaContextImpl;
import org.opendaylight.yangtools.yang.parser.impl.YangErrorListener;
import org.opendaylight.yangtools.yang.parser.impl.YangParserListenerImpl;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.GroupingSort;
import org.opendaylight.yangtools.yang.parser.util.GroupingUtils;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.parser.util.NamedFileInputStream;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.TypeUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;
import org.opendaylight.yangtools.yang.validator.YangModelBasicValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangParserImpl
implements YangModelParser {
    private static final Logger LOG = LoggerFactory.getLogger(YangParserImpl.class);
    private static final String FAIL_DEVIATION_TARGET = "Failed to find deviation target.";

    public Set<Module> parseYangModels(File yangFile, File directory) {
        Preconditions.checkState((boolean)yangFile.exists(), (Object)(yangFile + " does not exists"));
        Preconditions.checkState((boolean)directory.exists(), (Object)(directory + " does not exists"));
        Preconditions.checkState((boolean)directory.isDirectory(), (Object)(directory + " is not a directory"));
        String yangFileName = yangFile.getName();
        String[] fileList = directory.list();
        Preconditions.checkNotNull((Object)fileList, (Object)(directory + " not found"));
        FileInputStream yangFileStream = null;
        LinkedHashMap<FileInputStream, File> streamToFileMap = new LinkedHashMap<FileInputStream, File>();
        try {
            yangFileStream = new FileInputStream(yangFile);
            streamToFileMap.put(yangFileStream, yangFile);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Exception while reading yang file: " + yangFile.getName(), (Throwable)e);
        }
        for (String fileName : fileList) {
            if (fileName.equals(yangFileName)) continue;
            File dependency = new File(directory, fileName);
            try {
                if (!dependency.isFile()) continue;
                streamToFileMap.put(new FileInputStream(dependency), dependency);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Exception while reading yang file: " + fileName, (Throwable)e);
            }
        }
        Map<InputStream, ModuleBuilder> parsedBuilders = this.parseBuilders(new ArrayList<InputStream>(streamToFileMap.keySet()), new HashMap<ModuleBuilder, InputStream>());
        ModuleBuilder main = parsedBuilders.get(yangFileStream);
        ArrayList<ModuleBuilder> moduleBuilders = new ArrayList<ModuleBuilder>();
        moduleBuilders.add(main);
        this.filterImports(main, new ArrayList<ModuleBuilder>(parsedBuilders.values()), moduleBuilders);
        Collection<ModuleBuilder> result = this.resolveSubmodules(moduleBuilders);
        ModuleBuilder[] builders = new ModuleBuilder[result.size()];
        result.toArray(builders);
        List<ModuleBuilder> sortedBuilders = ModuleDependencySort.sort(builders);
        LinkedHashMap<String, TreeMap<Date, ModuleBuilder>> modules = this.orderModules(sortedBuilders);
        Collection<Module> unsorted = this.build(modules).values();
        return new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
    }

    public Set<Module> parseYangModels(List<File> yangFiles) {
        Collection<Module> unsorted = this.parseYangModelsMapped(yangFiles).values();
        return new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
    }

    public Set<Module> parseYangModels(List<File> yangFiles, SchemaContext context) {
        if (yangFiles == null) {
            return Collections.emptySet();
        }
        HashMap<FileInputStream, File> inputStreams = new HashMap<FileInputStream, File>();
        for (File yangFile : yangFiles) {
            try {
                inputStreams.put(new FileInputStream(yangFile), yangFile);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Exception while reading yang file: " + yangFile.getName(), (Throwable)e);
            }
        }
        ArrayList<InputStream> yangModelStreams = new ArrayList<InputStream>(inputStreams.keySet());
        HashMap<ModuleBuilder, InputStream> builderToStreamMap = new HashMap<ModuleBuilder, InputStream>();
        Map<String, TreeMap<Date, ModuleBuilder>> modules = this.resolveModuleBuilders(yangModelStreams, builderToStreamMap, null);
        for (InputStream is : inputStreams.keySet()) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close stream.");
            }
        }
        Collection<Module> unsorted = this.buildWithContext(modules, context).values();
        if (context != null) {
            for (Module m : context.getModules()) {
                if (unsorted.contains(m)) continue;
                unsorted.add(m);
            }
        }
        return new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
    }

    public Set<Module> parseYangModelsFromStreams(List<InputStream> yangModelStreams) {
        Collection<Module> unsorted = this.parseYangModelsFromStreamsMapped(yangModelStreams).values();
        return new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
    }

    public Set<Module> parseYangModelsFromStreams(List<InputStream> yangModelStreams, SchemaContext context) {
        if (yangModelStreams == null) {
            return Collections.emptySet();
        }
        HashMap<ModuleBuilder, InputStream> builderToStreamMap = new HashMap<ModuleBuilder, InputStream>();
        Map<String, TreeMap<Date, ModuleBuilder>> modules = this.resolveModuleBuilders(yangModelStreams, builderToStreamMap, context);
        LinkedHashSet<Module> unsorted = new LinkedHashSet<Module>(this.buildWithContext(modules, context).values());
        if (context != null) {
            for (Module m : context.getModules()) {
                if (unsorted.contains(m)) continue;
                unsorted.add(m);
            }
        }
        return new LinkedHashSet<Module>(ModuleDependencySort.sort(unsorted.toArray(new Module[unsorted.size()])));
    }

    public Map<File, Module> parseYangModelsMapped(List<File> yangFiles) {
        if (yangFiles == null) {
            return Collections.emptyMap();
        }
        HashMap<FileInputStream, File> inputStreams = new HashMap<FileInputStream, File>();
        for (File yangFile : yangFiles) {
            try {
                inputStreams.put(new FileInputStream(yangFile), yangFile);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Exception while reading yang file: " + yangFile.getName(), (Throwable)e);
            }
        }
        ArrayList<InputStream> yangModelStreams = new ArrayList<InputStream>(inputStreams.keySet());
        HashMap<ModuleBuilder, InputStream> builderToStreamMap = new HashMap<ModuleBuilder, InputStream>();
        Map<String, TreeMap<Date, ModuleBuilder>> modules = this.resolveModuleBuilders(yangModelStreams, builderToStreamMap, null);
        for (InputStream is : inputStreams.keySet()) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close stream.");
            }
        }
        LinkedHashMap<File, Module> result = new LinkedHashMap<File, Module>();
        Map<ModuleBuilder, Module> builderToModuleMap = this.build(modules);
        Set<ModuleBuilder> keyset = builderToModuleMap.keySet();
        List<ModuleBuilder> sorted = ModuleDependencySort.sort(keyset.toArray(new ModuleBuilder[keyset.size()]));
        for (ModuleBuilder key : sorted) {
            result.put((File)inputStreams.get(builderToStreamMap.get(key)), builderToModuleMap.get(key));
        }
        return result;
    }

    public Map<InputStream, Module> parseYangModelsFromStreamsMapped(List<InputStream> yangModelStreams) {
        if (yangModelStreams == null) {
            return Collections.emptyMap();
        }
        HashMap<ModuleBuilder, InputStream> builderToStreamMap = new HashMap<ModuleBuilder, InputStream>();
        Map<String, TreeMap<Date, ModuleBuilder>> modules = this.resolveModuleBuilders(yangModelStreams, builderToStreamMap, null);
        LinkedHashMap<InputStream, Module> result = new LinkedHashMap<InputStream, Module>();
        Map<ModuleBuilder, Module> builderToModuleMap = this.build(modules);
        Set<ModuleBuilder> keyset = builderToModuleMap.keySet();
        List<ModuleBuilder> sorted = ModuleDependencySort.sort(keyset.toArray(new ModuleBuilder[keyset.size()]));
        for (ModuleBuilder key : sorted) {
            result.put((InputStream)builderToStreamMap.get(key), builderToModuleMap.get(key));
        }
        return result;
    }

    public SchemaContext resolveSchemaContext(Set<Module> modules) {
        return new SchemaContextImpl(modules);
    }

    private Map<InputStream, ModuleBuilder> parseModuleBuilders(List<InputStream> inputStreams, Map<ModuleBuilder, InputStream> streamToBuilderMap) {
        Map<InputStream, ModuleBuilder> modules = this.parseBuilders(inputStreams, streamToBuilderMap);
        Map<InputStream, ModuleBuilder> result = this.resolveSubmodules(modules);
        return result;
    }

    private Map<InputStream, ModuleBuilder> parseBuilders(List<InputStream> inputStreams, Map<ModuleBuilder, InputStream> streamToBuilderMap) {
        ParseTreeWalker walker = new ParseTreeWalker();
        Map<InputStream, ParseTree> trees = this.parseStreams(inputStreams);
        LinkedHashMap<InputStream, ModuleBuilder> builders = new LinkedHashMap<InputStream, ModuleBuilder>();
        new YangModelBasicValidator(walker).validate(new ArrayList<ParseTree>(trees.values()));
        for (Map.Entry<InputStream, ParseTree> entry : trees.entrySet()) {
            InputStream is = entry.getKey();
            String path = null;
            if (is instanceof NamedFileInputStream) {
                NamedFileInputStream nis = (NamedFileInputStream)is;
                path = nis.getFileDestination();
            }
            YangParserListenerImpl yangModelParser = new YangParserListenerImpl(path);
            walker.walk((ParseTreeListener)yangModelParser, entry.getValue());
            ModuleBuilder moduleBuilder = yangModelParser.getModuleBuilder();
            streamToBuilderMap.put(moduleBuilder, entry.getKey());
            builders.put(entry.getKey(), moduleBuilder);
        }
        return builders;
    }

    private Map<InputStream, ModuleBuilder> resolveSubmodules(Map<InputStream, ModuleBuilder> builders) {
        HashMap<InputStream, ModuleBuilder> modules = new HashMap<InputStream, ModuleBuilder>();
        HashSet<ModuleBuilder> submodules = new HashSet<ModuleBuilder>();
        for (Map.Entry<InputStream, ModuleBuilder> entry : builders.entrySet()) {
            ModuleBuilder moduleBuilder = entry.getValue();
            if (moduleBuilder.isSubmodule()) {
                submodules.add(moduleBuilder);
                continue;
            }
            modules.put(entry.getKey(), moduleBuilder);
        }
        Collection values = modules.values();
        for (ModuleBuilder submodule : submodules) {
            for (ModuleBuilder module : values) {
                if (!module.getName().equals(submodule.getBelongsTo())) continue;
                this.addSubmoduleToModule(submodule, module);
            }
        }
        return modules;
    }

    private Collection<ModuleBuilder> resolveSubmodules(Collection<ModuleBuilder> builders) {
        HashSet<ModuleBuilder> modules = new HashSet<ModuleBuilder>();
        HashSet<ModuleBuilder> submodules = new HashSet<ModuleBuilder>();
        for (ModuleBuilder moduleBuilder : builders) {
            if (moduleBuilder.isSubmodule()) {
                submodules.add(moduleBuilder);
                continue;
            }
            modules.add(moduleBuilder);
        }
        for (ModuleBuilder submodule : submodules) {
            for (ModuleBuilder module : modules) {
                if (!module.getName().equals(submodule.getBelongsTo())) continue;
                this.addSubmoduleToModule(submodule, module);
            }
        }
        return modules;
    }

    private void addSubmoduleToModule(ModuleBuilder submodule, ModuleBuilder module) {
        submodule.setParent(module);
        module.getDirtyNodes().addAll(submodule.getDirtyNodes());
        module.getModuleImports().addAll(submodule.getModuleImports());
        module.getAugments().addAll(submodule.getAugments());
        module.getAugmentBuilders().addAll(submodule.getAugmentBuilders());
        module.getAllAugments().addAll(submodule.getAllAugments());
        module.getChildNodeBuilders().addAll(submodule.getChildNodeBuilders());
        module.getChildNodes().addAll(submodule.getChildNodes());
        module.getGroupings().addAll(submodule.getGroupings());
        module.getGroupingBuilders().addAll(submodule.getGroupingBuilders());
        module.getTypeDefinitions().addAll(submodule.getTypeDefinitions());
        module.getTypeDefinitionBuilders().addAll(submodule.getTypeDefinitionBuilders());
        module.getUsesNodes().addAll(submodule.getUsesNodes());
        module.getUsesNodeBuilders().addAll(submodule.getUsesNodeBuilders());
        module.getAllGroupings().addAll(submodule.getAllGroupings());
        module.getAllUsesNodes().addAll(submodule.getAllUsesNodes());
        module.getRpcs().addAll(submodule.getRpcs());
        module.getAddedRpcs().addAll(submodule.getAddedRpcs());
        module.getNotifications().addAll(submodule.getNotifications());
        module.getAddedNotifications().addAll(submodule.getAddedNotifications());
        module.getIdentities().addAll(submodule.getIdentities());
        module.getAddedIdentities().addAll(submodule.getAddedIdentities());
        module.getFeatures().addAll(submodule.getFeatures());
        module.getAddedFeatures().addAll(submodule.getAddedFeatures());
        module.getDeviations().addAll(submodule.getDeviations());
        module.getDeviationBuilders().addAll(submodule.getDeviationBuilders());
        module.getExtensions().addAll(submodule.getExtensions());
        module.getAddedExtensions().addAll(submodule.getAddedExtensions());
        module.getUnknownNodes().addAll(submodule.getUnknownNodes());
        module.getAllUnknownNodes().addAll(submodule.getAllUnknownNodes());
    }

    private Map<String, TreeMap<Date, ModuleBuilder>> resolveModuleBuilders(List<InputStream> yangFileStreams, Map<ModuleBuilder, InputStream> streamToBuilderMap, SchemaContext context) {
        Map<InputStream, ModuleBuilder> parsedBuilders = this.parseModuleBuilders(yangFileStreams, streamToBuilderMap);
        ModuleBuilder[] builders = new ModuleBuilder[parsedBuilders.size()];
        parsedBuilders.values().toArray(builders);
        List<ModuleBuilder> sorted = context == null ? ModuleDependencySort.sort(builders) : ModuleDependencySort.sortWithContext(context, builders);
        return this.orderModules(sorted);
    }

    private LinkedHashMap<String, TreeMap<Date, ModuleBuilder>> orderModules(List<ModuleBuilder> modules) {
        LinkedHashMap<String, TreeMap<Date, ModuleBuilder>> result = new LinkedHashMap<String, TreeMap<Date, ModuleBuilder>>();
        for (ModuleBuilder builder : modules) {
            TreeMap<Date, ModuleBuilder> builderByRevision;
            if (builder == null) continue;
            String builderName = builder.getName();
            Date builderRevision = builder.getRevision();
            if (builderRevision == null) {
                builderRevision = new Date(0L);
            }
            if ((builderByRevision = result.get(builderName)) == null) {
                builderByRevision = new TreeMap();
            }
            builderByRevision.put(builderRevision, builder);
            result.put(builderName, builderByRevision);
        }
        return result;
    }

    private void filterImports(ModuleBuilder main, List<ModuleBuilder> other, List<ModuleBuilder> filtered) {
        Set<ModuleImport> imports = main.getModuleImports();
        if (main.isSubmodule()) {
            TreeMap<Date, ModuleBuilder> dependencies = new TreeMap<Date, ModuleBuilder>();
            for (ModuleBuilder mb : other) {
                if (!mb.getName().equals(main.getBelongsTo())) continue;
                dependencies.put(mb.getRevision(), mb);
            }
            ModuleBuilder parent = (ModuleBuilder)dependencies.get(dependencies.firstKey());
            filtered.add(parent);
            imports.addAll(parent.getModuleImports());
        }
        for (ModuleImport mi : imports) {
            for (ModuleBuilder builder : other) {
                if (!mi.getModuleName().equals(builder.getModuleName())) continue;
                if (mi.getRevision() == null) {
                    if (filtered.contains(builder)) continue;
                    filtered.add(builder);
                    this.filterImports(builder, other, filtered);
                    continue;
                }
                if (!mi.getRevision().equals(builder.getRevision()) || filtered.contains(builder)) continue;
                filtered.add(builder);
                this.filterImports(builder, other, filtered);
            }
        }
    }

    private Map<InputStream, ParseTree> parseStreams(List<InputStream> yangStreams) {
        HashMap<InputStream, ParseTree> trees = new HashMap<InputStream, ParseTree>();
        for (InputStream yangStream : yangStreams) {
            trees.put(yangStream, this.parseStream(yangStream));
        }
        return trees;
    }

    private ParseTree parseStream(InputStream yangStream) {
        YangParser.YangContext result = null;
        try {
            ANTLRInputStream input = new ANTLRInputStream(yangStream);
            YangLexer lexer = new YangLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            YangParser parser = new YangParser((TokenStream)tokens);
            parser.removeErrorListeners();
            YangErrorListener errorListener = new YangErrorListener();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            result = parser.yang();
            errorListener.validate();
        }
        catch (IOException e) {
            LOG.warn("Exception while reading yang file: " + yangStream, (Throwable)e);
        }
        return result;
    }

    public static YangParser.YangContext parseStreamWithoutErrorListeners(InputStream yangStream) {
        YangParser.YangContext result = null;
        try {
            ANTLRInputStream input = new ANTLRInputStream(yangStream);
            YangLexer lexer = new YangLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            YangParser parser = new YangParser((TokenStream)tokens);
            parser.removeErrorListeners();
            result = parser.yang();
        }
        catch (IOException e) {
            LOG.warn("Exception while reading yang file: " + yangStream, (Throwable)e);
        }
        return result;
    }

    private Map<ModuleBuilder, Module> build(Map<String, TreeMap<Date, ModuleBuilder>> modules) {
        this.resolveDirtyNodes(modules);
        this.resolveAugmentsTargetPath(modules, null);
        this.resolveUsesTargetGrouping(modules, null);
        this.resolveUsesForGroupings(modules, null);
        this.resolveUsesForNodes(modules, null);
        this.resolveAugments(modules, null);
        this.resolveDeviations(modules);
        LinkedHashMap<ModuleBuilder, Module> result = new LinkedHashMap<ModuleBuilder, Module>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> childEntry : entry.getValue().entrySet()) {
                ModuleBuilder moduleBuilder = childEntry.getValue();
                Module module = moduleBuilder.build();
                result.put(moduleBuilder, module);
            }
        }
        return result;
    }

    private Map<ModuleBuilder, Module> buildWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        this.resolvedDirtyNodesWithContext(modules, context);
        this.resolveAugmentsTargetPath(modules, context);
        this.resolveUsesTargetGrouping(modules, context);
        this.resolveUsesForGroupings(modules, context);
        this.resolveUsesForNodes(modules, context);
        this.resolveAugments(modules, context);
        this.resolveDeviationsWithContext(modules, context);
        LinkedHashMap<ModuleBuilder, Module> result = new LinkedHashMap<ModuleBuilder, Module>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> childEntry : entry.getValue().entrySet()) {
                ModuleBuilder moduleBuilder = childEntry.getValue();
                Module module = moduleBuilder.build();
                result.put(moduleBuilder, module);
            }
        }
        return result;
    }

    private void resolveDirtyNodes(Map<String, TreeMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> childEntry : entry.getValue().entrySet()) {
                ModuleBuilder module = childEntry.getValue();
                this.resolveUnknownNodes(modules, module);
                this.resolveIdentities(modules, module);
                this.resolveDirtyNodes(modules, module);
            }
        }
    }

    private void resolvedDirtyNodesWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> childEntry : entry.getValue().entrySet()) {
                ModuleBuilder module = childEntry.getValue();
                this.resolveUnknownNodesWithContext(modules, module, context);
                this.resolveIdentitiesWithContext(modules, module, context);
                this.resolveDirtyNodesWithContext(modules, module, context);
            }
        }
    }

    private void resolveDirtyNodes(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        Set<TypeAwareBuilder> dirtyNodes = module.getDirtyNodes();
        if (!dirtyNodes.isEmpty()) {
            for (TypeAwareBuilder nodeToResolve : dirtyNodes) {
                if (nodeToResolve instanceof UnionTypeBuilder) {
                    TypeUtils.resolveTypeUnion((UnionTypeBuilder)nodeToResolve, modules, module);
                    continue;
                }
                if (nodeToResolve.getTypedef() instanceof IdentityrefTypeBuilder) {
                    IdentityrefTypeBuilder idref = (IdentityrefTypeBuilder)nodeToResolve.getTypedef();
                    IdentitySchemaNodeBuilder identity = ParserUtils.findBaseIdentity(modules, module, idref.getBaseString(), idref.getLine());
                    if (identity == null) {
                        throw new YangParseException(module.getName(), idref.getLine(), "Failed to find base identity");
                    }
                    idref.setBaseIdentity(identity);
                    nodeToResolve.setType((TypeDefinition<?>)idref.build());
                    continue;
                }
                TypeUtils.resolveType(nodeToResolve, modules, module);
            }
        }
    }

    private void resolveDirtyNodesWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        Set<TypeAwareBuilder> dirtyNodes = module.getDirtyNodes();
        if (!dirtyNodes.isEmpty()) {
            for (TypeAwareBuilder nodeToResolve : dirtyNodes) {
                if (nodeToResolve instanceof UnionTypeBuilder) {
                    TypeUtils.resolveTypeUnionWithContext((UnionTypeBuilder)nodeToResolve, modules, module, context);
                    continue;
                }
                if (nodeToResolve.getTypedef() instanceof IdentityrefTypeBuilder) {
                    IdentityrefTypeBuilder idref = (IdentityrefTypeBuilder)nodeToResolve.getTypedef();
                    IdentitySchemaNodeBuilder identity = ParserUtils.findBaseIdentity(modules, module, idref.getBaseString(), idref.getLine());
                    idref.setBaseIdentity(identity);
                    nodeToResolve.setType((TypeDefinition<?>)idref.build());
                    continue;
                }
                TypeUtils.resolveTypeWithContext(nodeToResolve, modules, module, context);
            }
        }
    }

    private void resolveAugmentsTargetPath(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        ArrayList<AugmentationSchemaBuilder> allAugments = new ArrayList<AugmentationSchemaBuilder>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                allAugments.addAll(inner.getValue().getAllAugments());
            }
        }
        for (AugmentationSchemaBuilder augment : allAugments) {
            this.setCorrectAugmentTargetPath(modules, augment, context);
        }
    }

    private void setCorrectAugmentTargetPath(Map<String, TreeMap<Date, ModuleBuilder>> modules, AugmentationSchemaBuilder augment, SchemaContext context) {
        ModuleBuilder module = ParserUtils.getParentModule(augment);
        SchemaPath oldSchemaPath = augment.getTargetPath();
        List oldPath = oldSchemaPath.getPath();
        ArrayList<QName> newPath = new ArrayList<QName>();
        Builder parent = augment.getParent();
        if (parent instanceof UsesNodeBuilder) {
            String prefix;
            Date revision;
            URI ns;
            DataNodeContainerBuilder usesParent = ((UsesNodeBuilder)parent).getParent();
            newPath.addAll(usesParent.getPath().getPath());
            QName baseQName = usesParent.getQName();
            if (baseQName == null) {
                ModuleBuilder m = ParserUtils.getParentModule(usesParent);
                ns = m.getNamespace();
                revision = m.getRevision();
                prefix = m.getPrefix();
            } else {
                ns = baseQName.getNamespace();
                revision = baseQName.getRevision();
                prefix = baseQName.getPrefix();
            }
            for (QName qn : oldSchemaPath.getPath()) {
                newPath.add(new QName(ns, revision, prefix, qn.getLocalName()));
            }
        } else {
            for (QName qn : oldPath) {
                URI ns = module.getNamespace();
                Date rev = module.getRevision();
                String pref = module.getPrefix();
                String localPrefix = qn.getPrefix();
                if (localPrefix != null && !"".equals(localPrefix)) {
                    ModuleBuilder currentModule = ParserUtils.findModuleFromBuilders(modules, module, localPrefix, augment.getLine());
                    if (currentModule == null) {
                        Module m = ParserUtils.findModuleFromContext(context, module, localPrefix, augment.getLine());
                        if (m == null) {
                            throw new YangParseException(module.getName(), augment.getLine(), "Module with prefix " + localPrefix + " not found.");
                        }
                        ns = m.getNamespace();
                        rev = m.getRevision();
                        pref = m.getPrefix();
                    } else {
                        ns = currentModule.getNamespace();
                        rev = currentModule.getRevision();
                        pref = currentModule.getPrefix();
                    }
                }
                newPath.add(new QName(ns, rev, pref, qn.getLocalName()));
            }
        }
        augment.setTargetNodeSchemaPath(new SchemaPath(newPath, augment.getTargetPath().isAbsolute()));
        for (DataSchemaNodeBuilder childNode : augment.getChildNodeBuilders()) {
            this.correctPathForAugmentNodes(childNode, augment.getTargetNodeSchemaPath());
        }
    }

    private void correctPathForAugmentNodes(DataSchemaNodeBuilder node, SchemaPath parentPath) {
        SchemaPath newPath = ParserUtils.createSchemaPath(parentPath, node.getQName());
        node.setPath(newPath);
        if (node instanceof DataNodeContainerBuilder) {
            for (DataSchemaNodeBuilder dataSchemaNodeBuilder : ((DataNodeContainerBuilder)((Object)node)).getChildNodeBuilders()) {
                this.correctPathForAugmentNodes(dataSchemaNodeBuilder, node.getPath());
            }
        }
        if (node instanceof ChoiceBuilder) {
            for (ChoiceCaseBuilder choiceCaseBuilder : ((ChoiceBuilder)node).getCases()) {
                this.correctPathForAugmentNodes(choiceCaseBuilder, node.getPath());
            }
        }
    }

    private void checkAugmentMandatoryNodes(Collection<AugmentationSchemaBuilder> augments) {
        for (AugmentationSchemaBuilder augment : augments) {
            String augmentPrefix = ((QName)augment.getTargetPath().getPath().get(0)).getPrefix();
            ModuleBuilder module = ParserUtils.getParentModule(augment);
            String modulePrefix = module.getPrefix();
            if (augmentPrefix == null || augmentPrefix.isEmpty() || augmentPrefix.equals(modulePrefix)) continue;
            for (DataSchemaNodeBuilder childNode : augment.getChildNodeBuilders()) {
                if (!childNode.getConstraints().isMandatory()) continue;
                throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: cannot augment mandatory node " + childNode.getQName().getLocalName());
            }
        }
    }

    private void resolveAugments(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        ArrayList<ModuleBuilder> all = new ArrayList<ModuleBuilder>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                all.add(inner.getValue());
            }
        }
        List<ModuleBuilder> sorted = context == null ? ModuleDependencySort.sort(all.toArray(new ModuleBuilder[all.size()])) : ModuleDependencySort.sortWithContext(context, all.toArray(new ModuleBuilder[all.size()]));
        for (ModuleBuilder mb : sorted) {
            if (mb == null) continue;
            List<AugmentationSchemaBuilder> augments = mb.getAllAugments();
            this.checkAugmentMandatoryNodes(augments);
            Collections.sort(augments, Comparators.AUGMENT_COMP);
            for (AugmentationSchemaBuilder augment : augments) {
                boolean resolved;
                if (augment.isResolved() || (resolved = this.resolveAugment(augment, mb, modules, context))) continue;
                throw new YangParseException(augment.getModuleName(), augment.getLine(), "Error in augment parsing: failed to find augment target: " + augment);
            }
        }
    }

    private boolean resolveUsesAugment(AugmentationSchemaBuilder augment, ModuleBuilder module, Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        if (augment.isResolved()) {
            return true;
        }
        UsesNodeBuilder usesNode = (UsesNodeBuilder)augment.getParent();
        DataNodeContainerBuilder parentNode = usesNode.getParent();
        SchemaNodeBuilder targetNode = parentNode instanceof ModuleBuilder ? ParserUtils.findSchemaNodeInModule(augment.getTargetPath().getPath(), (ModuleBuilder)parentNode) : ParserUtils.findSchemaNode(augment.getTargetPath().getPath(), (SchemaNodeBuilder)((Object)parentNode));
        ParserUtils.fillAugmentTarget(augment, targetNode);
        augment.setResolved(true);
        return true;
    }

    private boolean resolveAugment(AugmentationSchemaBuilder augment, ModuleBuilder module, Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        if (augment.isResolved()) {
            return true;
        }
        List targetPath = augment.getTargetPath().getPath();
        ModuleBuilder targetModule = this.findTargetModule((QName)targetPath.get(0), module, modules, context, augment.getLine());
        if (targetModule == null) {
            throw new YangParseException(module.getModuleName(), augment.getLine(), "Failed to resolve augment " + augment);
        }
        return ParserUtils.processAugmentation(augment, targetModule);
    }

    private ModuleBuilder findTargetModule(QName qname, ModuleBuilder module, Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context, int line) {
        ModuleBuilder targetModule = null;
        String prefix = qname.getPrefix();
        targetModule = prefix == null || prefix.equals("") ? module : ParserUtils.findModuleFromBuilders(modules, module, qname.getPrefix(), line);
        if (targetModule == null && context != null) {
            Module m = ParserUtils.findModuleFromContext(context, module, prefix, line);
            targetModule = new ModuleBuilder(m);
            DataSchemaNode firstNode = m.getDataChildByName(qname.getLocalName());
            DataSchemaNodeBuilder firstNodeWrapped = ParserUtils.wrapChildNode(targetModule.getModuleName(), line, firstNode, targetModule.getPath(), firstNode.getQName());
            targetModule.addChildNode(firstNodeWrapped);
            TreeMap<Date, ModuleBuilder> map = new TreeMap<Date, ModuleBuilder>();
            map.put(targetModule.getRevision(), targetModule);
            modules.put(targetModule.getModuleName(), map);
        }
        return targetModule;
    }

    private void resolveIdentities(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        Set<IdentitySchemaNodeBuilder> identities = module.getAddedIdentities();
        for (IdentitySchemaNodeBuilder identity : identities) {
            String baseIdentityName = identity.getBaseIdentityName();
            int line = identity.getLine();
            if (baseIdentityName == null) continue;
            IdentitySchemaNodeBuilder baseIdentity = ParserUtils.findBaseIdentity(modules, module, baseIdentityName, line);
            if (baseIdentity == null) {
                throw new YangParseException(module.getName(), identity.getLine(), "Failed to find base identity");
            }
            identity.setBaseIdentity(baseIdentity);
        }
    }

    private void resolveIdentitiesWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        Set<IdentitySchemaNodeBuilder> identities = module.getAddedIdentities();
        for (IdentitySchemaNodeBuilder identity : identities) {
            String baseIdentityName = identity.getBaseIdentityName();
            int line = identity.getLine();
            if (baseIdentityName == null) continue;
            IdentitySchemaNodeBuilder baseIdentity = ParserUtils.findBaseIdentity(modules, module, baseIdentityName, line);
            if (baseIdentity == null) {
                IdentitySchemaNode baseId = ParserUtils.findBaseIdentityFromContext(modules, module, baseIdentityName, line, context);
                identity.setBaseIdentity(baseId);
                continue;
            }
            identity.setBaseIdentity(baseIdentity);
        }
    }

    private void resolveUsesTargetGrouping(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        ArrayList<UsesNodeBuilder> allUses = new ArrayList<UsesNodeBuilder>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                allUses.addAll(inner.getValue().getAllUsesNodes());
            }
        }
        for (UsesNodeBuilder usesNode : allUses) {
            ModuleBuilder module;
            GroupingBuilder targetGroupingBuilder = GroupingUtils.getTargetGroupingFromModules(usesNode, modules, module = ParserUtils.getParentModule(usesNode));
            if (targetGroupingBuilder == null) {
                if (context == null) {
                    throw new YangParseException(module.getName(), usesNode.getLine(), "Referenced grouping '" + usesNode.getGroupingPathAsString() + "' not found.");
                }
                GroupingDefinition targetGroupingDefinition = GroupingUtils.getTargetGroupingFromContext(usesNode, module, context);
                usesNode.setGroupingDefinition(targetGroupingDefinition);
                continue;
            }
            usesNode.setGrouping(targetGroupingBuilder);
        }
    }

    private void resolveUsesForGroupings(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        HashSet<GroupingBuilder> allGroupings = new HashSet<GroupingBuilder>();
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                ModuleBuilder module = inner.getValue();
                allGroupings.addAll(module.getAllGroupings());
            }
        }
        List<GroupingBuilder> sorted = GroupingSort.sort(allGroupings);
        for (GroupingBuilder gb : sorted) {
            ArrayList<UsesNodeBuilder> usesNodes = new ArrayList<UsesNodeBuilder>(GroupingSort.getAllUsesNodes(gb));
            Collections.sort(usesNodes, new GroupingUtils.UsesComparator());
            for (UsesNodeBuilder usesNode : usesNodes) {
                this.resolveUses(usesNode, modules, context);
            }
        }
    }

    private void resolveUsesForNodes(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                ModuleBuilder module = inner.getValue();
                List<UsesNodeBuilder> usesNodes = module.getAllUsesNodes();
                Collections.sort(usesNodes, new GroupingUtils.UsesComparator());
                for (UsesNodeBuilder usesNode : usesNodes) {
                    this.resolveUses(usesNode, modules, context);
                }
            }
        }
    }

    private void resolveUses(UsesNodeBuilder usesNode, Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        if (!usesNode.isResolved()) {
            DataNodeContainerBuilder parent = usesNode.getParent();
            ModuleBuilder module = ParserUtils.getParentModule(parent);
            GroupingBuilder target = GroupingUtils.getTargetGroupingFromModules(usesNode, modules, module);
            if (target == null) {
                this.resolveUsesWithContext(usesNode);
                usesNode.setResolved(true);
                for (AugmentationSchemaBuilder augment : usesNode.getAugmentations()) {
                    this.resolveUsesAugment(augment, module, modules, context);
                }
            } else {
                parent.getChildNodeBuilders().addAll(target.instantiateChildNodes(parent));
                parent.getTypeDefinitionBuilders().addAll(target.instantiateTypedefs(parent));
                parent.getGroupingBuilders().addAll(target.instantiateGroupings(parent));
                parent.getUnknownNodes().addAll(target.instantiateUnknownNodes(parent));
                usesNode.setResolved(true);
                for (AugmentationSchemaBuilder augment : usesNode.getAugmentations()) {
                    this.resolveUsesAugment(augment, module, modules, context);
                }
            }
            GroupingUtils.performRefine(usesNode);
        }
    }

    private void resolveUsesWithContext(UsesNodeBuilder usesNode) {
        SchemaPath parentPath;
        int line = usesNode.getLine();
        DataNodeContainerBuilder parent = usesNode.getParent();
        ModuleBuilder module = ParserUtils.getParentModule(parent);
        URI ns = null;
        Date rev = null;
        String pref = null;
        if (parent instanceof AugmentationSchemaBuilder || parent instanceof ModuleBuilder) {
            ns = module.getNamespace();
            rev = module.getRevision();
            pref = module.getPrefix();
            parentPath = parent instanceof AugmentationSchemaBuilder ? ((AugmentationSchemaBuilder)parent).getTargetNodeSchemaPath() : ((ModuleBuilder)parent).getPath();
        } else {
            ns = ((DataSchemaNodeBuilder)((Object)parent)).getQName().getNamespace();
            rev = ((DataSchemaNodeBuilder)((Object)parent)).getQName().getRevision();
            pref = ((DataSchemaNodeBuilder)((Object)parent)).getQName().getPrefix();
            parentPath = ((DataSchemaNodeBuilder)((Object)parent)).getPath();
        }
        GroupingDefinition gd = usesNode.getGroupingDefinition();
        Set<DataSchemaNodeBuilder> childNodes = ParserUtils.wrapChildNodes(module.getModuleName(), line, gd.getChildNodes(), parentPath, ns, rev, pref);
        parent.getChildNodeBuilders().addAll(childNodes);
        for (DataSchemaNodeBuilder childNode : childNodes) {
            ParserUtils.setNodeAddedByUses(childNode);
        }
        Set<TypeDefinitionBuilder> typedefs = ParserUtils.wrapTypedefs(module.getModuleName(), line, (DataNodeContainer)gd, parentPath, ns, rev, pref);
        parent.getTypeDefinitionBuilders().addAll(typedefs);
        for (TypeDefinitionBuilder typedef : typedefs) {
            ParserUtils.setNodeAddedByUses(typedef);
        }
        Set<GroupingBuilder> groupings = ParserUtils.wrapGroupings(module.getModuleName(), line, usesNode.getGroupingDefinition().getGroupings(), parentPath, ns, rev, pref);
        parent.getGroupingBuilders().addAll(groupings);
        for (GroupingBuilder gb : groupings) {
            ParserUtils.setNodeAddedByUses(gb);
        }
        List<UnknownSchemaNodeBuilder> unknownNodes = ParserUtils.wrapUnknownNodes(module.getModuleName(), line, gd.getUnknownSchemaNodes(), parentPath, ns, rev, pref);
        parent.getUnknownNodes().addAll(unknownNodes);
        for (UnknownSchemaNodeBuilder un : unknownNodes) {
            un.setAddedByUses(true);
        }
    }

    private void resolveUnknownNodes(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        block2: for (UnknownSchemaNodeBuilder usnb : module.getAllUnknownNodes()) {
            QName nodeType = usnb.getNodeType();
            try {
                ModuleBuilder dependentModule = ParserUtils.findModuleFromBuilders(modules, module, nodeType.getPrefix(), usnb.getLine());
                for (ExtensionBuilder extension : dependentModule.getAddedExtensions()) {
                    if (!extension.getQName().getLocalName().equals(nodeType.getLocalName())) continue;
                    usnb.setNodeType(extension.getQName());
                    usnb.setExtensionBuilder(extension);
                    continue block2;
                }
            }
            catch (YangParseException e) {
                throw new YangParseException(module.getName(), usnb.getLine(), "Failed to resolve node " + usnb + ": no such extension definition found.", e);
            }
        }
    }

    private void resolveUnknownNodesWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        block2: for (UnknownSchemaNodeBuilder usnb : module.getAllUnknownNodes()) {
            QName nodeType = usnb.getNodeType();
            try {
                ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, nodeType.getPrefix(), usnb.getLine());
                if (dependentModuleBuilder == null) {
                    Module dependentModule = ParserUtils.findModuleFromContext(context, module, nodeType.getPrefix(), usnb.getLine());
                    for (ExtensionDefinition e : dependentModule.getExtensionSchemaNodes()) {
                        if (!e.getQName().getLocalName().equals(nodeType.getLocalName())) continue;
                        usnb.setNodeType(new QName(e.getQName().getNamespace(), e.getQName().getRevision(), nodeType.getPrefix(), e.getQName().getLocalName()));
                        usnb.setExtensionDefinition(e);
                        continue block2;
                    }
                    continue;
                }
                for (ExtensionBuilder extension : dependentModuleBuilder.getAddedExtensions()) {
                    if (!extension.getQName().getLocalName().equals(nodeType.getLocalName())) continue;
                    usnb.setExtensionBuilder(extension);
                    continue block2;
                }
            }
            catch (YangParseException e) {
                throw new YangParseException(module.getName(), usnb.getLine(), "Failed to resolve node " + usnb + ": no such extension definition found.", e);
            }
        }
    }

    private void resolveDeviations(Map<String, TreeMap<Date, ModuleBuilder>> modules) {
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                ModuleBuilder b = inner.getValue();
                this.resolveDeviation(modules, b);
            }
        }
    }

    private void resolveDeviation(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module) {
        for (DeviationBuilder dev : module.getDeviationBuilders()) {
            int line = dev.getLine();
            SchemaPath targetPath = dev.getTargetPath();
            List path = targetPath.getPath();
            QName q0 = (QName)path.get(0);
            String prefix = q0.getPrefix();
            if (prefix == null) {
                prefix = module.getPrefix();
            }
            ModuleBuilder dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, prefix, line);
            this.processDeviation(dev, dependentModuleBuilder, path, module);
        }
    }

    private void resolveDeviationsWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, SchemaContext context) {
        for (Map.Entry<String, TreeMap<Date, ModuleBuilder>> entry : modules.entrySet()) {
            for (Map.Entry<Date, ModuleBuilder> inner : entry.getValue().entrySet()) {
                ModuleBuilder b = inner.getValue();
                this.resolveDeviationWithContext(modules, b, context);
            }
        }
    }

    private void resolveDeviationWithContext(Map<String, TreeMap<Date, ModuleBuilder>> modules, ModuleBuilder module, SchemaContext context) {
        for (DeviationBuilder dev : module.getDeviationBuilders()) {
            ModuleBuilder dependentModuleBuilder;
            int line = dev.getLine();
            SchemaPath targetPath = dev.getTargetPath();
            List path = targetPath.getPath();
            QName q0 = (QName)path.get(0);
            String prefix = q0.getPrefix();
            if (prefix == null) {
                prefix = module.getPrefix();
            }
            if ((dependentModuleBuilder = ParserUtils.findModuleFromBuilders(modules, module, prefix, line)) == null) {
                Module currentParent = ParserUtils.findModuleFromContext(context, module, prefix, line);
                for (QName q : path) {
                    if (currentParent == null) {
                        throw new YangParseException(module.getName(), line, FAIL_DEVIATION_TARGET);
                    }
                    String name = q.getLocalName();
                    if (!(currentParent instanceof DataNodeContainer)) continue;
                    currentParent = ((DataNodeContainer)currentParent).getDataChildByName(name);
                }
                if (currentParent == null) {
                    throw new YangParseException(module.getName(), line, FAIL_DEVIATION_TARGET);
                }
                if (!(currentParent instanceof SchemaNode)) continue;
                dev.setTargetPath(((SchemaNode)currentParent).getPath());
                continue;
            }
            this.processDeviation(dev, dependentModuleBuilder, path, module);
        }
    }

    private void processDeviation(DeviationBuilder dev, ModuleBuilder dependentModuleBuilder, List<QName> path, ModuleBuilder module) {
        int line = dev.getLine();
        Builder currentParent = dependentModuleBuilder;
        for (QName q : path) {
            if (currentParent == null) {
                throw new YangParseException(module.getName(), line, FAIL_DEVIATION_TARGET);
            }
            String name = q.getLocalName();
            if (!(currentParent instanceof DataNodeContainerBuilder)) continue;
            currentParent = ((DataNodeContainerBuilder)currentParent).getDataChildByName(name);
        }
        if (!(currentParent instanceof SchemaNodeBuilder)) {
            throw new YangParseException(module.getName(), line, FAIL_DEVIATION_TARGET);
        }
        dev.setTargetPath(((SchemaNodeBuilder)currentParent).getPath());
    }
}

