/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

final class YangErrorListener
extends BaseErrorListener {
    private final List<Exception> exceptions = new ArrayList<Exception>();

    YangErrorListener() {
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String module = this.getModuleName(recognizer);
        this.exceptions.add(new YangParseException(module, line, msg));
    }

    private String getModuleName(Recognizer<?, ?> recognizer) {
        String result;
        if (recognizer instanceof Parser) {
            try {
                Parser parser = (Parser)recognizer;
                String model = parser.getInputStream().getTokenSource().getInputStream().toString();
                model = model.substring(0, model.indexOf("\n"));
                model = model.substring(model.indexOf("module") + 6);
                model = model.substring(0, model.indexOf("{"));
                result = model = model.trim();
            }
            catch (Exception e) {
                result = "";
            }
        } else {
            result = "";
        }
        return result;
    }

    public void validate() {
        if (!this.exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Exception e : this.exceptions) {
                sb.append("\n");
                sb.append(e.getMessage());
            }
            throw new YangParseException(sb.toString());
        }
    }
}

