/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;

final class SchemaContextImpl
implements SchemaContext {
    private final Set<Module> modules;

    SchemaContextImpl(Set<Module> modules) {
        this.modules = modules;
    }

    public Set<DataSchemaNode> getDataDefinitions() {
        HashSet<DataSchemaNode> dataDefs = new HashSet<DataSchemaNode>();
        for (Module m : this.modules) {
            dataDefs.addAll(m.getChildNodes());
        }
        return dataDefs;
    }

    public Set<Module> getModules() {
        List<Module> sorted = ModuleDependencySort.sort(this.modules.toArray(new Module[this.modules.size()]));
        return new LinkedHashSet<Module>(sorted);
    }

    public Set<NotificationDefinition> getNotifications() {
        HashSet<NotificationDefinition> notifications = new HashSet<NotificationDefinition>();
        for (Module m : this.modules) {
            notifications.addAll(m.getNotifications());
        }
        return notifications;
    }

    public Set<RpcDefinition> getOperations() {
        HashSet<RpcDefinition> rpcs = new HashSet<RpcDefinition>();
        for (Module m : this.modules) {
            rpcs.addAll(m.getRpcs());
        }
        return rpcs;
    }

    public Set<ExtensionDefinition> getExtensions() {
        HashSet<ExtensionDefinition> extensions = new HashSet<ExtensionDefinition>();
        for (Module m : this.modules) {
            extensions.addAll(m.getExtensionSchemaNodes());
        }
        return extensions;
    }

    public Module findModuleByName(String name, Date revision) {
        if (name != null) {
            for (Module module : this.modules) {
                if (!(revision == null ? module.getName().equals(name) : module.getName().equals(name) && module.getRevision().equals(revision))) continue;
                return module;
            }
        }
        return null;
    }

    public Set<Module> findModuleByNamespace(URI namespace) {
        HashSet<Module> ret = new HashSet<Module>();
        if (namespace != null) {
            for (Module module : this.modules) {
                if (!module.getNamespace().equals(namespace)) continue;
                ret.add(module);
            }
        }
        return ret;
    }

    public Module findModuleByNamespaceAndRevision(URI namespace, Date revision) {
        if (namespace != null) {
            for (Module module : this.modules) {
                if (!module.getNamespace().equals(namespace) || !module.getRevision().equals(revision)) continue;
                return module;
            }
        }
        return null;
    }

    public boolean isAugmenting() {
        return false;
    }

    public boolean isAddedByUses() {
        return false;
    }

    public boolean isConfiguration() {
        return false;
    }

    public ConstraintDefinition getConstraints() {
        return null;
    }

    public QName getQName() {
        return SchemaContext.NAME;
    }

    public SchemaPath getPath() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getReference() {
        return null;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        ArrayList result = new ArrayList();
        for (Module module : this.modules) {
            result.addAll(module.getUnknownSchemaNodes());
        }
        return Collections.unmodifiableList(result);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.modules) {
            result.addAll(module.getTypeDefinitions());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<DataSchemaNode> getChildNodes() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.modules) {
            result.addAll(module.getChildNodes());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<GroupingDefinition> getGroupings() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.modules) {
            result.addAll(module.getGroupings());
        }
        return Collections.unmodifiableSet(result);
    }

    public DataSchemaNode getDataChildByName(QName name) {
        Module module;
        DataSchemaNode result = null;
        Iterator<Module> i$ = this.modules.iterator();
        while (i$.hasNext() && (result = (module = i$.next()).getDataChildByName(name)) == null) {
        }
        return result;
    }

    public DataSchemaNode getDataChildByName(String name) {
        Module module;
        DataSchemaNode result = null;
        Iterator<Module> i$ = this.modules.iterator();
        while (i$.hasNext() && (result = (module = i$.next()).getDataChildByName(name)) == null) {
        }
        return result;
    }

    public Set<UsesNode> getUses() {
        return Collections.emptySet();
    }

    public boolean isPresenceContainer() {
        return false;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return Collections.emptySet();
    }
}

