/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class UsesNodeBuilderImpl
extends AbstractBuilder
implements UsesNodeBuilder {
    private boolean isBuilt;
    private UsesNodeImpl instance;
    private DataNodeContainerBuilder parentBuilder;
    private final String groupingPathString;
    private SchemaPath groupingPath;
    private GroupingDefinition groupingDefinition;
    private GroupingBuilder groupingBuilder;
    private boolean addedByUses;
    private boolean augmenting;
    private boolean resolved;
    private final Set<AugmentationSchema> augments = new HashSet<AugmentationSchema>();
    private final Set<AugmentationSchemaBuilder> addedAugments = new HashSet<AugmentationSchemaBuilder>();
    private final List<SchemaNodeBuilder> refineBuilders = new ArrayList<SchemaNodeBuilder>();
    private final List<RefineHolder> refines = new ArrayList<RefineHolder>();

    public UsesNodeBuilderImpl(String moduleName, int line, String groupingName) {
        super(moduleName, line);
        this.groupingPathString = groupingName;
    }

    @Override
    public UsesNode build() {
        if (!this.isBuilt) {
            this.instance = new UsesNodeImpl(this.groupingPath);
            this.instance.setAddedByUses(this.addedByUses);
            for (AugmentationSchemaBuilder builder : this.addedAugments) {
                this.augments.add(builder.build());
            }
            this.instance.setAugmentations(this.augments);
            HashMap<SchemaPath, SchemaNode> refineNodes = new HashMap<SchemaPath, SchemaNode>();
            for (SchemaNodeBuilder refineBuilder : this.refineBuilders) {
                SchemaNode refineNode = refineBuilder.build();
                refineNodes.put(refineNode.getPath(), refineNode);
            }
            this.instance.setRefines(refineNodes);
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            this.instance.setUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public DataNodeContainerBuilder getParent() {
        return this.parentBuilder;
    }

    @Override
    public void setParent(Builder parent) {
        if (!(parent instanceof DataNodeContainerBuilder)) {
            throw new YangParseException(this.moduleName, this.line, "Parent of 'uses' has to be instance of DataNodeContainerBuilder, but was: '" + parent + "'.");
        }
        this.parentBuilder = (DataNodeContainerBuilder)parent;
    }

    @Override
    public SchemaPath getGroupingPath() {
        return this.groupingPath;
    }

    @Override
    public GroupingDefinition getGroupingDefinition() {
        return this.groupingDefinition;
    }

    @Override
    public void setGroupingDefinition(GroupingDefinition groupingDefinition) {
        this.groupingDefinition = groupingDefinition;
        if (groupingDefinition != null) {
            this.groupingPath = groupingDefinition.getPath();
        }
    }

    @Override
    public GroupingBuilder getGroupingBuilder() {
        return this.groupingBuilder;
    }

    @Override
    public void setGrouping(GroupingBuilder grouping) {
        this.groupingBuilder = grouping;
        if (this.groupingBuilder != null) {
            this.groupingPath = this.groupingBuilder.getPath();
        }
    }

    @Override
    public String getGroupingPathAsString() {
        return this.groupingPathString;
    }

    @Override
    public Set<AugmentationSchemaBuilder> getAugmentations() {
        return this.addedAugments;
    }

    @Override
    public void addAugment(AugmentationSchemaBuilder augmentBuilder) {
        this.addedAugments.add(augmentBuilder);
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public boolean isAugmenting() {
        return this.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.augmenting = augmenting;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public List<SchemaNodeBuilder> getRefineNodes() {
        return this.refineBuilders;
    }

    @Override
    public void addRefineNode(DataSchemaNodeBuilder refineNode) {
        this.refineBuilders.add(refineNode);
    }

    @Override
    public List<RefineHolder> getRefines() {
        return this.refines;
    }

    @Override
    public void addRefine(RefineHolder refine) {
        this.refines.add(refine);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupingPathString == null ? 0 : this.groupingPathString.hashCode());
        result = 31 * result + (this.parentBuilder == null ? 0 : this.parentBuilder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsesNodeBuilderImpl other = (UsesNodeBuilderImpl)obj;
        if (this.groupingPathString == null ? other.groupingPathString != null : !this.groupingPathString.equals(other.groupingPathString)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "uses '" + this.groupingPathString + "'";
    }

    public final class UsesNodeImpl
    implements UsesNode {
        private final SchemaPath groupingPath;
        private Set<AugmentationSchema> augmentations = Collections.emptySet();
        private boolean addedByUses;
        private Map<SchemaPath, SchemaNode> refines = Collections.emptyMap();
        private List<UnknownSchemaNode> unknownNodes = Collections.emptyList();

        private UsesNodeImpl(SchemaPath groupingPath) {
            this.groupingPath = groupingPath;
        }

        public SchemaPath getGroupingPath() {
            return this.groupingPath;
        }

        public Set<AugmentationSchema> getAugmentations() {
            return this.augmentations;
        }

        private void setAugmentations(Set<AugmentationSchema> augmentations) {
            if (augmentations != null) {
                this.augmentations = augmentations;
            }
        }

        public boolean isAugmenting() {
            return false;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        private void setAddedByUses(boolean addedByUses) {
            this.addedByUses = addedByUses;
        }

        public Map<SchemaPath, SchemaNode> getRefines() {
            return this.refines;
        }

        private void setRefines(Map<SchemaPath, SchemaNode> refines) {
            if (refines != null) {
                this.refines = refines;
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes = unknownSchemaNodes;
            }
        }

        public UsesNodeBuilder toBuilder() {
            return UsesNodeBuilderImpl.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.groupingPath == null ? 0 : this.groupingPath.hashCode());
            result = 31 * result + (this.augmentations == null ? 0 : this.augmentations.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsesNodeImpl other = (UsesNodeImpl)obj;
            if (this.groupingPath == null ? other.groupingPath != null : !this.groupingPath.equals((Object)other.groupingPath)) {
                return false;
            }
            return !(this.augmentations == null ? other.augmentations != null : !this.augmentations.equals(other.augmentations));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(UsesNodeImpl.class.getSimpleName());
            sb.append("[groupingPath=");
            sb.append(this.groupingPath);
            sb.append("]");
            return sb.toString();
        }
    }
}

