/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;

public final class UnknownSchemaNodeBuilder
extends AbstractSchemaNodeBuilder {
    private boolean isBuilt;
    private final UnknownSchemaNodeImpl instance;
    private QName nodeType;
    private String nodeParameter;
    private ExtensionDefinition extensionDefinition;
    private ExtensionBuilder extensionBuilder;

    public UnknownSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new UnknownSchemaNodeImpl(qname, path);
    }

    public UnknownSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, UnknownSchemaNode base) {
        super(moduleName, line, base.getQName());
        this.schemaPath = path;
        this.instance = new UnknownSchemaNodeImpl(qname, path);
        this.instance.nodeType = base.getNodeType();
        this.instance.nodeParameter = base.getNodeParameter();
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.extension = base.getExtensionDefinition();
        this.instance.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.nodeParameter == null ? 0 : this.nodeParameter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownSchemaNodeBuilder other = (UnknownSchemaNodeBuilder)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType)) {
            return false;
        }
        return !(this.nodeParameter == null ? other.nodeParameter != null : !this.nodeParameter.equals(other.nodeParameter));
    }

    public UnknownSchemaNode build() {
        if (!this.isBuilt) {
            this.instance.setNodeType(this.nodeType);
            this.instance.setNodeParameter(this.nodeParameter);
            if (this.extensionDefinition != null) {
                this.instance.setExtensionDefinition(this.extensionDefinition);
            } else if (this.extensionBuilder != null) {
                this.instance.setExtensionDefinition(this.extensionBuilder.build());
            }
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.setUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    public QName getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(QName nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeParameter() {
        return this.nodeParameter;
    }

    public void setNodeParameter(String nodeParameter) {
        this.nodeParameter = nodeParameter;
    }

    public ExtensionDefinition getExtensionDefinition() {
        return this.extensionDefinition;
    }

    public void setExtensionDefinition(ExtensionDefinition extensionDefinition) {
        this.extensionDefinition = extensionDefinition;
    }

    public ExtensionBuilder getExtensionBuilder() {
        return this.extensionBuilder;
    }

    public void setExtensionBuilder(ExtensionBuilder extension) {
        this.extensionBuilder = extension;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeType.getPrefix());
        sb.append(":");
        sb.append(this.nodeType.getLocalName());
        sb.append(" ");
        sb.append(this.nodeParameter);
        return sb.toString();
    }

    private final class UnknownSchemaNodeImpl
    implements UnknownSchemaNode {
        private final QName qname;
        private final SchemaPath path;
        private ExtensionDefinition extension;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
        private QName nodeType;
        private String nodeParameter;
        private boolean addedByUses;

        private UnknownSchemaNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public ExtensionDefinition getExtensionDefinition() {
            return this.extension;
        }

        private void setExtensionDefinition(ExtensionDefinition extension) {
            this.extension = extension;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public QName getNodeType() {
            return this.nodeType;
        }

        private void setNodeType(QName nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeParameter() {
            return this.nodeParameter;
        }

        private void setNodeParameter(String nodeParameter) {
            this.nodeParameter = nodeParameter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.nodeType.getPrefix());
            sb.append(":");
            sb.append(this.nodeType.getLocalName());
            sb.append(" ");
            sb.append(this.nodeParameter);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (UnknownSchemaNodeBuilder.this.schemaPath == null ? 0 : UnknownSchemaNodeBuilder.this.schemaPath.hashCode());
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            result = 31 * result + (this.nodeParameter == null ? 0 : this.nodeParameter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnknownSchemaNodeImpl other = (UnknownSchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                return false;
            }
            if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals((Object)other.nodeType)) {
                return false;
            }
            return !(this.nodeParameter == null ? other.nodeParameter != null : !this.nodeParameter.equals(other.nodeParameter));
        }
    }
}

