/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.UnknownType;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractTypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class TypeDefinitionBuilderImpl
extends AbstractTypeAwareBuilder
implements TypeDefinitionBuilder {
    private final SchemaPath schemaPath;
    private List<RangeConstraint> ranges = Collections.emptyList();
    private List<LengthConstraint> lengths = Collections.emptyList();
    private List<PatternConstraint> patterns = Collections.emptyList();
    private Integer fractionDigits = null;
    private String description;
    private String reference;
    private Status status = Status.CURRENT;
    private String units;
    private Object defaultValue;
    private boolean addedByUses;

    public TypeDefinitionBuilderImpl(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
    }

    public TypeDefinitionBuilderImpl(String moduleName, int line, QName qname, SchemaPath path, ExtendedType base) {
        super(moduleName, line, base.getQName());
        this.schemaPath = path;
        this.type = base.getBaseType();
        this.description = base.getDescription();
        this.reference = base.getReference();
        this.status = base.getStatus();
        this.units = base.getUnits();
        this.defaultValue = base.getDefaultValue();
        ExtendedType ext = base;
        this.addedByUses = ext.isAddedByUses();
        this.ranges = ext.getRangeConstraints();
        this.lengths = ext.getLengthConstraints();
        this.patterns = ext.getPatternConstraints();
        this.fractionDigits = ext.getFractionDigits();
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public TypeDefinition<? extends TypeDefinition<?>> build() {
        ExtendedType result = null;
        ExtendedType.Builder typeBuilder = null;
        if ((this.type == null || this.type instanceof UnknownType) && this.typedef == null) {
            throw new YangParseException("Unresolved type: '" + this.qname.getLocalName() + "'.");
        }
        if (this.type == null || this.type instanceof UnknownType) {
            this.type = this.typedef.build();
        }
        typeBuilder = new ExtendedType.Builder(this.qname, this.type, this.description, this.reference, this.schemaPath);
        typeBuilder.status(this.status);
        typeBuilder.units(this.units);
        typeBuilder.defaultValue(this.defaultValue);
        typeBuilder.addedByUses(this.addedByUses);
        typeBuilder.ranges(this.ranges);
        typeBuilder.lengths(this.lengths);
        typeBuilder.patterns(this.patterns);
        typeBuilder.fractionDigits(this.fractionDigits);
        for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
            this.unknownNodes.add(b.build());
        }
        Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
        typeBuilder.unknownSchemaNodes(this.unknownNodes);
        result = typeBuilder.build();
        return result;
    }

    @Override
    public void setQName(QName qname) {
        this.qname = qname;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.status = status;
        }
    }

    @Override
    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.addedByUses = addedByUses;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public List<UnknownSchemaNodeBuilder> getUnknownNodes() {
        return Collections.emptyList();
    }

    @Override
    public List<RangeConstraint> getRanges() {
        return this.ranges;
    }

    @Override
    public void setRanges(List<RangeConstraint> ranges) {
        if (ranges != null) {
            this.ranges = ranges;
        }
    }

    @Override
    public List<LengthConstraint> getLengths() {
        return this.lengths;
    }

    @Override
    public void setLengths(List<LengthConstraint> lengths) {
        if (lengths != null) {
            this.lengths = lengths;
        }
    }

    @Override
    public List<PatternConstraint> getPatterns() {
        return this.patterns;
    }

    @Override
    public void setPatterns(List<PatternConstraint> patterns) {
        if (patterns != null) {
            this.patterns = patterns;
        }
    }

    @Override
    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public void setFractionDigits(Integer fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String toString() {
        return "typedef " + this.qname.getLocalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TypeDefinitionBuilderImpl other = (TypeDefinitionBuilderImpl)obj;
        return !(this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath));
    }
}

