/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;

public final class RpcDefinitionBuilder
extends AbstractSchemaNodeBuilder {
    private boolean isBuilt;
    private final RpcDefinitionImpl instance;
    private ContainerSchemaNodeBuilder inputBuilder;
    private ContainerSchemaNodeBuilder outputBuilder;
    private final Set<TypeDefinition<?>> typedefs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<TypeDefinitionBuilder> addedTypedefs = new HashSet<TypeDefinitionBuilder>();
    private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<GroupingBuilder> addedGroupings = new HashSet<GroupingBuilder>();

    public ContainerSchemaNodeBuilder getInput() {
        return this.inputBuilder;
    }

    public ContainerSchemaNodeBuilder getOutput() {
        return this.outputBuilder;
    }

    RpcDefinitionBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new RpcDefinitionImpl(qname, path);
    }

    public RpcDefinition build() {
        if (!this.isBuilt) {
            ContainerSchemaNode input = this.inputBuilder == null ? null : this.inputBuilder.build();
            ContainerSchemaNode output = this.outputBuilder == null ? null : this.outputBuilder.build();
            this.instance.setInput(input);
            this.instance.setOutput(output);
            for (TypeDefinitionBuilder typeDefinitionBuilder : this.addedTypedefs) {
                this.typedefs.add(typeDefinitionBuilder.build());
            }
            this.instance.setTypeDefinitions(this.typedefs);
            for (GroupingBuilder groupingBuilder : this.addedGroupings) {
                this.groupings.add(groupingBuilder.build());
            }
            this.instance.setGroupings(this.groupings);
            for (UnknownSchemaNodeBuilder unknownSchemaNodeBuilder : this.addedUnknownNodes) {
                this.unknownNodes.add(unknownSchemaNodeBuilder.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.setUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    void setInput(ContainerSchemaNodeBuilder inputBuilder) {
        this.inputBuilder = inputBuilder;
    }

    void setOutput(ContainerSchemaNodeBuilder outputBuilder) {
        this.outputBuilder = outputBuilder;
    }

    public Set<TypeDefinitionBuilder> getTypeDefinitions() {
        return this.addedTypedefs;
    }

    public void addTypedef(TypeDefinitionBuilder type) {
        this.addedTypedefs.add(type);
    }

    public Set<GroupingBuilder> getGroupings() {
        return this.addedGroupings;
    }

    public void addGrouping(GroupingBuilder grouping) {
        this.addedGroupings.add(grouping);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RpcDefinitionBuilder)) {
            return false;
        }
        RpcDefinitionBuilder other = (RpcDefinitionBuilder)obj;
        if (other.qname == null ? this.qname != null : !other.qname.equals((Object)this.qname)) {
            return false;
        }
        return !(other.schemaPath == null ? this.schemaPath != null : !other.schemaPath.equals((Object)this.schemaPath));
    }

    public String toString() {
        return "rpc " + this.qname.getLocalName();
    }

    private final class RpcDefinitionImpl
    implements RpcDefinition {
        private final QName qname;
        private final SchemaPath path;
        private String description;
        private String reference;
        private Status status;
        private ContainerSchemaNode input;
        private ContainerSchemaNode output;
        private final Set<TypeDefinition<?>> typeDefinitions = new HashSet();
        private final Set<GroupingDefinition> groupings = new HashSet<GroupingDefinition>();
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private RpcDefinitionImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public ContainerSchemaNode getInput() {
            return this.input;
        }

        private void setInput(ContainerSchemaNode input) {
            this.input = input;
        }

        public ContainerSchemaNode getOutput() {
            return this.output;
        }

        private void setOutput(ContainerSchemaNode output) {
            this.output = output;
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.unmodifiableSet(this.typeDefinitions);
        }

        private void setTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            this.typeDefinitions.addAll(typeDefinitions);
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.unmodifiableSet(this.groupings);
        }

        private void setGroupings(Set<GroupingDefinition> groupings) {
            this.groupings.addAll(groupings);
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RpcDefinitionImpl other = (RpcDefinitionImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(RpcDefinitionImpl.class.getSimpleName());
            sb.append("[");
            sb.append("qname=");
            sb.append(this.qname);
            sb.append(", path=");
            sb.append(this.path);
            sb.append(", input=");
            sb.append(this.input);
            sb.append(", output=");
            sb.append(this.output);
            sb.append("]");
            return sb.toString();
        }
    }
}

