/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class NotificationBuilder
extends AbstractDataNodeContainerBuilder
implements SchemaNodeBuilder,
AugmentationTargetBuilder {
    private boolean isBuilt;
    private final NotificationDefinitionImpl instance;
    private SchemaPath schemaPath;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    NotificationBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new NotificationDefinitionImpl(qname, path);
    }

    NotificationBuilder(String moduleName, int line, QName qname, SchemaPath path, NotificationDefinition base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new NotificationDefinitionImpl(qname, path);
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmentations.addAll(base.getAvailableAugmentations());
        URI ns = qname.getNamespace();
        Date rev = qname.getRevision();
        String pref = qname.getPrefix();
        this.addedChildNodes.addAll(ParserUtils.wrapChildNodes(moduleName, line, base.getChildNodes(), path, ns, rev, pref));
        this.addedGroupings.addAll(ParserUtils.wrapGroupings(moduleName, line, base.getGroupings(), path, ns, rev, pref));
        this.instance.groupings.addAll(base.getGroupings());
        this.instance.typeDefinitions.addAll(base.getTypeDefinitions());
        this.instance.uses.addAll(base.getUses());
        this.instance.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public NotificationDefinition build() {
        if (!(this.parentBuilder instanceof ModuleBuilder)) {
            throw new YangParseException(this.moduleName, this.line, "Notification can be defined only under module (was " + this.parentBuilder + ")");
        }
        if (!this.isBuilt) {
            for (DataSchemaNodeBuilder dataSchemaNodeBuilder : this.addedChildNodes) {
                this.childNodes.add(dataSchemaNodeBuilder.build());
            }
            this.instance.setChildNodes(this.childNodes);
            for (GroupingBuilder groupingBuilder : this.addedGroupings) {
                this.groupings.add(groupingBuilder.build());
            }
            this.instance.setGroupings(this.groupings);
            for (TypeDefinitionBuilder typeDefinitionBuilder : this.addedTypedefs) {
                this.typedefs.add(typeDefinitionBuilder.build());
            }
            this.instance.setTypeDefinitions(this.typedefs);
            for (UsesNodeBuilder usesNodeBuilder : this.addedUsesNodes) {
                this.usesNodes.add(usesNodeBuilder.build());
            }
            this.instance.setUses(this.usesNodes);
            for (AugmentationSchemaBuilder augmentationSchemaBuilder : this.augmentationBuilders) {
                this.augmentations.add(augmentationSchemaBuilder.build());
            }
            this.instance.setAvailableAugmentations(new HashSet<AugmentationSchema>(this.augmentations));
            for (UnknownSchemaNodeBuilder unknownSchemaNodeBuilder : this.addedUnknownNodes) {
                this.unknownNodes.add(unknownSchemaNodeBuilder.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.setUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        this.addedTypedefs.add(type);
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public String toString() {
        return "notification " + this.getQName().getLocalName();
    }

    public final class NotificationDefinitionImpl
    implements NotificationDefinition {
        private final QName qname;
        private final SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<GroupingDefinition> groupings = new HashSet<GroupingDefinition>();
        private final Set<TypeDefinition<?>> typeDefinitions = new HashSet();
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private NotificationDefinitionImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void setChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.unmodifiableSet(this.groupings);
        }

        private void setGroupings(Set<GroupingDefinition> groupings) {
            if (groupings != null) {
                this.groupings.addAll(groupings);
            }
        }

        public Set<UsesNode> getUses() {
            return Collections.unmodifiableSet(this.uses);
        }

        private void setUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.unmodifiableSet(this.typeDefinitions);
        }

        private void setTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            if (typeDefinitions != null) {
                this.typeDefinitions.addAll(typeDefinitions);
            }
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return Collections.unmodifiableSet(this.augmentations);
        }

        private void setAvailableAugmentations(Set<AugmentationSchema> augmentations) {
            if (augmentations != null) {
                this.augmentations.addAll(augmentations);
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return NotificationBuilder.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return NotificationBuilder.this.getChildNode(this.childNodes, name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotificationDefinitionImpl other = (NotificationDefinitionImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(NotificationDefinitionImpl.class.getSimpleName());
            sb.append("[qname=" + this.qname + ", path=" + this.path + "]");
            return sb.toString();
        }
    }
}

