/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.SchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AnyXmlBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.AugmentationSchemaBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ContainerSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.DeviationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ExtensionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.FeatureBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.GroupingBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentitySchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.LeafSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ListSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.NotificationBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.RpcDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.TypeDefinitionBuilderImpl;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UsesNodeBuilderImpl;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ModuleImportImpl;
import org.opendaylight.yangtools.yang.parser.util.RefineHolder;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public class ModuleBuilder
extends AbstractDataNodeContainerBuilder {
    private final ModuleImpl instance;
    private final String name;
    private final String sourcePath;
    private final SchemaPath schemaPath;
    private URI namespace;
    private String prefix;
    private Date revision;
    private final boolean submodule;
    private String belongsTo;
    private ModuleBuilder parent;
    private final Deque<Builder> actualPath = new LinkedList<Builder>();
    private final Set<TypeAwareBuilder> dirtyNodes = new HashSet<TypeAwareBuilder>();
    private final Set<ModuleImport> imports = new HashSet<ModuleImport>();
    private final Set<AugmentationSchema> augments = new HashSet<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentBuilders = new ArrayList<AugmentationSchemaBuilder>();
    private final List<AugmentationSchemaBuilder> allAugments = new ArrayList<AugmentationSchemaBuilder>();
    private final List<GroupingBuilder> allGroupings = new ArrayList<GroupingBuilder>();
    private final List<UsesNodeBuilder> allUsesNodes = new ArrayList<UsesNodeBuilder>();
    private final Set<RpcDefinition> rpcs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<RpcDefinitionBuilder> addedRpcs = new HashSet<RpcDefinitionBuilder>();
    private final Set<NotificationDefinition> notifications = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<NotificationBuilder> addedNotifications = new HashSet<NotificationBuilder>();
    private final Set<IdentitySchemaNode> identities = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<IdentitySchemaNodeBuilder> addedIdentities = new HashSet<IdentitySchemaNodeBuilder>();
    private final Set<FeatureDefinition> features = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<FeatureBuilder> addedFeatures = new HashSet<FeatureBuilder>();
    private final Set<Deviation> deviations = new HashSet<Deviation>();
    private final Set<DeviationBuilder> deviationBuilders = new HashSet<DeviationBuilder>();
    private final List<ExtensionDefinition> extensions = new ArrayList<ExtensionDefinition>();
    private final List<ExtensionBuilder> addedExtensions = new ArrayList<ExtensionBuilder>();
    private final List<UnknownSchemaNodeBuilder> allUnknownNodes = new ArrayList<UnknownSchemaNodeBuilder>();
    private final List<ListSchemaNodeBuilder> allLists = new ArrayList<ListSchemaNodeBuilder>();

    @Override
    public ModuleBuilder getParent() {
        return this.parent;
    }

    public void setParent(ModuleBuilder parent) {
        this.parent = parent;
    }

    public ModuleBuilder(String name, String sourcePath) {
        this(name, false, sourcePath);
    }

    public ModuleBuilder(String name, boolean submodule, String sourcePath) {
        super(name, 0, null);
        this.name = name;
        this.sourcePath = sourcePath;
        this.schemaPath = new SchemaPath(Collections.emptyList(), true);
        this.submodule = submodule;
        this.instance = new ModuleImpl(name, sourcePath);
        this.actualPath.push(this);
    }

    public ModuleBuilder(Module base) {
        super(base.getName(), 0, null);
        this.name = base.getName();
        this.sourcePath = base.getModuleSourcePath();
        this.schemaPath = new SchemaPath(Collections.emptyList(), true);
        this.submodule = false;
        this.instance = new ModuleImpl(base.getName(), base.getModuleSourcePath());
        this.actualPath.push(this);
        this.namespace = base.getNamespace();
        this.prefix = base.getPrefix();
        this.revision = base.getRevision();
        for (DataSchemaNode childNode : base.getChildNodes()) {
            this.childNodes.add(childNode);
        }
        this.typedefs.addAll(base.getTypeDefinitions());
        this.groupings.addAll(base.getGroupings());
        this.usesNodes.addAll(base.getUses());
        this.augments.addAll(base.getAugmentations());
        this.rpcs.addAll(base.getRpcs());
        this.notifications.addAll(base.getNotifications());
        this.identities.addAll(base.getIdentities());
        this.features.addAll(base.getFeatures());
        this.deviations.addAll(base.getDeviations());
        this.extensions.addAll(base.getExtensionSchemaNodes());
        this.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public Module build() {
        this.instance.setPrefix(this.prefix);
        this.instance.setRevision(this.revision);
        this.instance.setImports(this.imports);
        this.instance.setNamespace(this.namespace);
        for (TypeDefinitionBuilder typeDefinitionBuilder : this.addedTypedefs) {
            this.typedefs.add(typeDefinitionBuilder.build());
        }
        this.instance.setTypeDefinitions(this.typedefs);
        for (DataSchemaNodeBuilder dataSchemaNodeBuilder : this.addedChildNodes) {
            this.childNodes.add(dataSchemaNodeBuilder.build());
        }
        this.instance.addChildNodes(this.childNodes);
        for (GroupingBuilder groupingBuilder : this.addedGroupings) {
            this.groupings.add(groupingBuilder.build());
        }
        this.instance.setGroupings(this.groupings);
        for (UsesNodeBuilder usesNodeBuilder : this.addedUsesNodes) {
            this.usesNodes.add(usesNodeBuilder.build());
        }
        this.instance.setUses(this.usesNodes);
        for (FeatureBuilder featureBuilder : this.addedFeatures) {
            this.features.add(featureBuilder.build());
        }
        this.instance.setFeatures(this.features);
        for (NotificationBuilder notificationBuilder : this.addedNotifications) {
            this.notifications.add(notificationBuilder.build());
        }
        this.instance.setNotifications(this.notifications);
        for (AugmentationSchemaBuilder augmentationSchemaBuilder : this.augmentBuilders) {
            this.augments.add(augmentationSchemaBuilder.build());
        }
        this.instance.setAugmentations(this.augments);
        for (RpcDefinitionBuilder rpcDefinitionBuilder : this.addedRpcs) {
            this.rpcs.add(rpcDefinitionBuilder.build());
        }
        this.instance.setRpcs(this.rpcs);
        for (DeviationBuilder deviationBuilder : this.deviationBuilders) {
            this.deviations.add(deviationBuilder.build());
        }
        this.instance.setDeviations(this.deviations);
        for (ExtensionBuilder extensionBuilder : this.addedExtensions) {
            this.extensions.add(extensionBuilder.build());
        }
        Collections.sort(this.extensions, Comparators.SCHEMA_NODE_COMP);
        this.instance.setExtensionSchemaNodes(this.extensions);
        for (IdentitySchemaNodeBuilder identitySchemaNodeBuilder : this.addedIdentities) {
            this.identities.add(identitySchemaNodeBuilder.build());
        }
        this.instance.setIdentities(this.identities);
        for (UnknownSchemaNodeBuilder unknownSchemaNodeBuilder : this.addedUnknownNodes) {
            this.unknownNodes.add(unknownSchemaNodeBuilder.build());
        }
        Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
        this.instance.setUnknownSchemaNodes(this.unknownNodes);
        return this.instance;
    }

    public String getModuleSourcePath() {
        return this.sourcePath;
    }

    @Override
    public void setParent(Builder parent) {
        throw new YangParseException(this.name, 0, "Can not set parent to module");
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    public void enterNode(Builder node) {
        this.actualPath.push(node);
    }

    public void exitNode() {
        this.actualPath.pop();
    }

    public Builder getActualNode() {
        if (this.actualPath.isEmpty()) {
            return null;
        }
        return this.actualPath.peekFirst();
    }

    public Builder getActualParent() {
        if (this.actualPath.size() < 2) {
            return null;
        }
        Builder builderChild = this.actualPath.removeFirst();
        Builder builderParent = this.actualPath.peekFirst();
        this.actualPath.addFirst(builderChild);
        return builderParent;
    }

    public Set<TypeAwareBuilder> getDirtyNodes() {
        return this.dirtyNodes;
    }

    public Set<AugmentationSchema> getAugments() {
        return this.augments;
    }

    public List<AugmentationSchemaBuilder> getAugmentBuilders() {
        return this.augmentBuilders;
    }

    public List<AugmentationSchemaBuilder> getAllAugments() {
        return this.allAugments;
    }

    public Set<IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public Set<IdentitySchemaNodeBuilder> getAddedIdentities() {
        return this.addedIdentities;
    }

    public Set<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Set<FeatureBuilder> getAddedFeatures() {
        return this.addedFeatures;
    }

    public List<GroupingBuilder> getAllGroupings() {
        return this.allGroupings;
    }

    public List<UsesNodeBuilder> getAllUsesNodes() {
        return this.allUsesNodes;
    }

    public Set<Deviation> getDeviations() {
        return this.deviations;
    }

    public Set<DeviationBuilder> getDeviationBuilders() {
        return this.deviationBuilders;
    }

    public List<ExtensionDefinition> getExtensions() {
        return this.extensions;
    }

    public List<ExtensionBuilder> getAddedExtensions() {
        return this.addedExtensions;
    }

    public List<UnknownSchemaNodeBuilder> getAllUnknownNodes() {
        return this.allUnknownNodes;
    }

    public List<ListSchemaNodeBuilder> getAllLists() {
        return this.allLists;
    }

    public String getName() {
        return this.name;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public void setNamespace(URI namespace) {
        this.namespace = namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Date getRevision() {
        return this.revision;
    }

    public boolean isSubmodule() {
        return this.submodule;
    }

    public String getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(String belongsTo) {
        this.belongsTo = belongsTo;
    }

    public void markActualNodeDirty() {
        TypeAwareBuilder nodeBuilder = (TypeAwareBuilder)this.getActualNode();
        this.dirtyNodes.add(nodeBuilder);
    }

    public void setRevision(Date revision) {
        this.revision = revision;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setYangVersion(String yangVersion) {
        this.instance.setYangVersion(yangVersion);
    }

    public void setDescription(String description) {
        this.instance.setDescription(description);
    }

    public void setReference(String reference) {
        this.instance.setReference(reference);
    }

    public void setOrganization(String organization) {
        this.instance.setOrganization(organization);
    }

    public void setContact(String contact) {
        this.instance.setContact(contact);
    }

    public boolean addModuleImport(String moduleName, Date revision, String prefix) {
        ModuleImport moduleImport = this.createModuleImport(moduleName, revision, prefix);
        return this.imports.add(moduleImport);
    }

    public Set<ModuleImport> getModuleImports() {
        return this.imports;
    }

    public ExtensionBuilder addExtension(QName qname, int line, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "extension can be defined only in module or submodule");
        }
        String extName = qname.getLocalName();
        for (ExtensionBuilder addedExtension : this.addedExtensions) {
            if (!addedExtension.getQName().getLocalName().equals(extName)) continue;
            this.raiseYangParserException("extension", "node", extName, line, addedExtension.getLine());
        }
        ExtensionBuilder builder = new ExtensionBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        this.addedExtensions.add(builder);
        return builder;
    }

    public ContainerSchemaNodeBuilder addContainerNode(int line, QName qname, SchemaPath schemaPath) {
        ContainerSchemaNodeBuilder builder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        return builder;
    }

    public ListSchemaNodeBuilder addListNode(int line, QName qname, SchemaPath schemaPath) {
        ListSchemaNodeBuilder builder = new ListSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        this.allLists.add(builder);
        return builder;
    }

    public LeafSchemaNodeBuilder addLeafNode(int line, QName qname, SchemaPath schemaPath) {
        LeafSchemaNodeBuilder builder = new LeafSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        return builder;
    }

    public LeafListSchemaNodeBuilder addLeafListNode(int line, QName qname, SchemaPath schemaPath) {
        LeafListSchemaNodeBuilder builder = new LeafListSchemaNodeBuilder(this.name, line, qname, schemaPath);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        return builder;
    }

    public GroupingBuilder addGrouping(int line, QName qname, SchemaPath path) {
        GroupingBuilderImpl builder = new GroupingBuilderImpl(this.name, line, qname, path);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        String groupingName = qname.getLocalName();
        if (parent.equals(this)) {
            for (GroupingBuilder addedGrouping : this.addedGroupings) {
                if (!addedGrouping.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", "Grouping", groupingName, line, addedGrouping.getLine());
            }
            this.addedGroupings.add(builder);
        } else if (parent instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parent;
            for (GroupingBuilder addedGrouping : parentNode.getGroupingBuilders()) {
                if (!addedGrouping.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", "Grouping", groupingName, line, addedGrouping.getLine());
            }
            parentNode.addGrouping(builder);
        } else if (parent instanceof RpcDefinitionBuilder) {
            RpcDefinitionBuilder parentNode = (RpcDefinitionBuilder)parent;
            for (GroupingBuilder child : parentNode.getGroupings()) {
                if (!child.getQName().getLocalName().equals(groupingName)) continue;
                this.raiseYangParserException("", "Grouping", groupingName, line, child.getLine());
            }
            parentNode.addGrouping(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of grouping " + groupingName);
        }
        this.allGroupings.add(builder);
        return builder;
    }

    public AugmentationSchemaBuilder addAugment(int line, String augmentTargetStr) {
        AugmentationSchemaBuilderImpl builder = new AugmentationSchemaBuilderImpl(this.name, line, augmentTargetStr);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        if (parent.equals(this)) {
            if (!augmentTargetStr.startsWith("/")) {
                throw new YangParseException(this.name, line, "If the 'augment' statement is on the top level in a module, the absolute form of a schema node identifier MUST be used.");
            }
            this.augmentBuilders.add(builder);
        } else if (parent instanceof UsesNodeBuilder) {
            if (augmentTargetStr.startsWith("/")) {
                throw new YangParseException(this.name, line, "If 'augment' statement is a substatement to the 'uses' statement, it cannot contain absolute path (" + augmentTargetStr + ")");
            }
            ((UsesNodeBuilder)parent).addAugment(builder);
        } else {
            throw new YangParseException(this.name, line, "Augment can be declared only under module or uses statement.");
        }
        this.allAugments.add(builder);
        return builder;
    }

    @Override
    public void addUsesNode(UsesNodeBuilder usesBuilder) {
        this.addedUsesNodes.add(usesBuilder);
        this.allUsesNodes.add(usesBuilder);
    }

    public UsesNodeBuilder addUsesNode(int line, String groupingPathStr) {
        UsesNodeBuilderImpl usesBuilder = new UsesNodeBuilderImpl(this.name, line, groupingPathStr);
        Builder parent = this.getActualNode();
        usesBuilder.setParent(parent);
        if (parent.equals(this)) {
            this.addedUsesNodes.add(usesBuilder);
        } else {
            if (!(parent instanceof DataNodeContainerBuilder)) {
                throw new YangParseException(this.name, line, "Unresolved parent of uses '" + groupingPathStr + "'.");
            }
            ((DataNodeContainerBuilder)parent).addUsesNode(usesBuilder);
        }
        if (parent instanceof AugmentationSchemaBuilder) {
            usesBuilder.setAugmenting(true);
        }
        this.allUsesNodes.add(usesBuilder);
        return usesBuilder;
    }

    public void addRefine(RefineHolder refine) {
        Builder parent = this.getActualNode();
        if (!(parent instanceof UsesNodeBuilder)) {
            throw new YangParseException(this.name, refine.getLine(), "refine can be defined only in uses statement");
        }
        ((UsesNodeBuilder)parent).addRefine(refine);
        refine.setParent(parent);
    }

    public RpcDefinitionBuilder addRpc(int line, QName qname, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "rpc can be defined only in module or submodule");
        }
        RpcDefinitionBuilder rpcBuilder = new RpcDefinitionBuilder(this.name, line, qname, path);
        rpcBuilder.setParent(parent);
        String rpcName = qname.getLocalName();
        for (RpcDefinitionBuilder rpc : this.addedRpcs) {
            if (!rpc.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("", "rpc", rpcName, line, rpc.getLine());
        }
        for (DataSchemaNodeBuilder addedChild : this.addedChildNodes) {
            if (!addedChild.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("rpc", "node", rpcName, line, addedChild.getLine());
        }
        for (NotificationBuilder addedNotification : this.addedNotifications) {
            if (!addedNotification.getQName().getLocalName().equals(rpcName)) continue;
            this.raiseYangParserException("rpc", "notification", rpcName, line, addedNotification.getLine());
        }
        this.addedRpcs.add(rpcBuilder);
        return rpcBuilder;
    }

    public ContainerSchemaNodeBuilder addRpcInput(int line, QName qname, SchemaPath schemaPath) {
        Builder parent = this.getActualNode();
        if (!(parent instanceof RpcDefinitionBuilder)) {
            throw new YangParseException(this.name, line, "input can be defined only in rpc statement");
        }
        RpcDefinitionBuilder rpc = (RpcDefinitionBuilder)parent;
        ContainerSchemaNodeBuilder inputBuilder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        inputBuilder.setParent(rpc);
        rpc.setInput(inputBuilder);
        return inputBuilder;
    }

    public ContainerSchemaNodeBuilder addRpcOutput(SchemaPath schemaPath, QName qname, int line) {
        Builder parent = this.getActualNode();
        if (!(parent instanceof RpcDefinitionBuilder)) {
            throw new YangParseException(this.name, line, "output can be defined only in rpc statement");
        }
        RpcDefinitionBuilder rpc = (RpcDefinitionBuilder)parent;
        ContainerSchemaNodeBuilder outputBuilder = new ContainerSchemaNodeBuilder(this.name, line, qname, schemaPath);
        outputBuilder.setParent(rpc);
        rpc.setOutput(outputBuilder);
        return outputBuilder;
    }

    public void addNotification(NotificationDefinition notification) {
        this.notifications.add(notification);
    }

    public NotificationBuilder addNotification(int line, QName qname, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "notification can be defined only in module or submodule");
        }
        String notificationName = qname.getLocalName();
        for (NotificationBuilder nb : this.addedNotifications) {
            if (!nb.getQName().equals((Object)qname)) continue;
            this.raiseYangParserException("", "notification", notificationName, line, nb.getLine());
        }
        for (RpcDefinitionBuilder rpc : this.addedRpcs) {
            if (!rpc.getQName().getLocalName().equals(notificationName)) continue;
            this.raiseYangParserException("notification", "rpc", notificationName, line, rpc.getLine());
        }
        for (DataSchemaNodeBuilder addedChild : this.addedChildNodes) {
            if (!addedChild.getQName().getLocalName().equals(notificationName)) continue;
            this.raiseYangParserException("notification", "node", notificationName, line, addedChild.getLine());
        }
        NotificationBuilder builder = new NotificationBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        this.addedNotifications.add(builder);
        return builder;
    }

    public FeatureBuilder addFeature(int line, QName qname, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "feature can be defined only in module or submodule");
        }
        FeatureBuilder builder = new FeatureBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        String featureName = qname.getLocalName();
        for (FeatureBuilder addedFeature : this.addedFeatures) {
            if (!addedFeature.getQName().getLocalName().equals(featureName)) continue;
            this.raiseYangParserException("", "feature", featureName, line, addedFeature.getLine());
        }
        this.addedFeatures.add(builder);
        return builder;
    }

    public ChoiceBuilder addChoice(int line, QName qname, SchemaPath path) {
        ChoiceBuilder builder = new ChoiceBuilder(this.name, line, qname, path);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        return builder;
    }

    public ChoiceCaseBuilder addCase(int line, QName qname, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (parent == null || parent.equals(this)) {
            throw new YangParseException(this.name, line, "'case' parent not found");
        }
        ChoiceCaseBuilder builder = new ChoiceCaseBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        if (parent instanceof ChoiceBuilder) {
            ((ChoiceBuilder)parent).addCase(builder);
        } else if (parent instanceof AugmentationSchemaBuilder) {
            ((AugmentationSchemaBuilder)parent).addChildNode(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of 'case' " + qname.getLocalName());
        }
        return builder;
    }

    public AnyXmlBuilder addAnyXml(int line, QName qname, SchemaPath schemaPath) {
        AnyXmlBuilder builder = new AnyXmlBuilder(this.name, line, qname, schemaPath);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        this.addChildToParent(parent, builder, qname.getLocalName());
        return builder;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder typedefBuilder) {
        String nodeName = typedefBuilder.getQName().getLocalName();
        for (TypeDefinitionBuilder tdb : this.addedTypedefs) {
            if (!tdb.getQName().getLocalName().equals(nodeName)) continue;
            this.raiseYangParserException("", "typedef", nodeName, typedefBuilder.getLine(), tdb.getLine());
        }
        this.addedTypedefs.add(typedefBuilder);
    }

    public TypeDefinitionBuilderImpl addTypedef(int line, QName qname, SchemaPath path) {
        TypeDefinitionBuilderImpl builder = new TypeDefinitionBuilderImpl(this.name, line, qname, path);
        Builder parent = this.getActualNode();
        builder.setParent(parent);
        String typedefName = qname.getLocalName();
        if (parent.equals(this)) {
            for (TypeDefinitionBuilder tdb : this.addedTypedefs) {
                if (!tdb.getQName().getLocalName().equals(typedefName)) continue;
                this.raiseYangParserException("", "typedef", typedefName, line, tdb.getLine());
            }
            this.addedTypedefs.add(builder);
        } else if (parent instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parent;
            for (TypeDefinitionBuilder child : parentNode.getTypeDefinitionBuilders()) {
                if (!child.getQName().getLocalName().equals(typedefName)) continue;
                this.raiseYangParserException("", "typedef", typedefName, line, child.getLine());
            }
            parentNode.addTypedef(builder);
        } else if (parent instanceof RpcDefinitionBuilder) {
            RpcDefinitionBuilder rpcParent = (RpcDefinitionBuilder)parent;
            for (TypeDefinitionBuilder tdb : rpcParent.getTypeDefinitions()) {
                if (!tdb.getQName().getLocalName().equals(builder.getQName().getLocalName())) continue;
                this.raiseYangParserException("", "typedef", typedefName, line, tdb.getLine());
            }
            rpcParent.addTypedef(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of typedef " + typedefName);
        }
        return builder;
    }

    public void setType(TypeDefinition<?> type) {
        Builder parent = this.getActualNode();
        if (!(parent instanceof TypeAwareBuilder)) {
            throw new YangParseException("Failed to set type '" + type.getQName().getLocalName() + "'. Invalid parent node: " + parent);
        }
        ((TypeAwareBuilder)parent).setType(type);
    }

    public UnionTypeBuilder addUnionType(int line, URI namespace, Date revision) {
        Builder parent = this.getActualNode();
        if (parent == null) {
            throw new YangParseException(this.name, line, "Unresolved parent of union type");
        }
        UnionTypeBuilder union = new UnionTypeBuilder(this.name, line);
        if (parent instanceof TypeAwareBuilder) {
            ((TypeAwareBuilder)parent).setTypedef(union);
            return union;
        }
        throw new YangParseException(this.name, line, "Invalid parent of union type.");
    }

    public void addIdentityrefType(int line, SchemaPath schemaPath, String baseString) {
        IdentityrefTypeBuilder identityref = new IdentityrefTypeBuilder(this.name, line, baseString, schemaPath);
        Builder parent = this.getActualNode();
        if (parent == null) {
            throw new YangParseException(this.name, line, "Unresolved parent of identityref type.");
        }
        if (!(parent instanceof TypeAwareBuilder)) {
            throw new YangParseException(this.name, line, "Invalid parent of identityref type.");
        }
        TypeAwareBuilder typeParent = (TypeAwareBuilder)parent;
        typeParent.setTypedef(identityref);
        this.dirtyNodes.add(typeParent);
    }

    public DeviationBuilder addDeviation(int line, String targetPath) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "deviation can be defined only in module or submodule");
        }
        DeviationBuilder builder = new DeviationBuilder(this.name, line, targetPath);
        builder.setParent(parent);
        this.deviationBuilders.add(builder);
        return builder;
    }

    public IdentitySchemaNodeBuilder addIdentity(QName qname, int line, SchemaPath path) {
        Builder parent = this.getActualNode();
        if (!parent.equals(this)) {
            throw new YangParseException(this.name, line, "identity can be defined only in module or submodule");
        }
        String identityName = qname.getLocalName();
        for (IdentitySchemaNodeBuilder idBuilder : this.addedIdentities) {
            if (!idBuilder.getQName().equals((Object)qname)) continue;
            this.raiseYangParserException("", "identity", identityName, line, idBuilder.getLine());
        }
        IdentitySchemaNodeBuilder builder = new IdentitySchemaNodeBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        this.addedIdentities.add(builder);
        return builder;
    }

    @Override
    public void addUnknownNodeBuilder(UnknownSchemaNodeBuilder builder) {
        this.addedUnknownNodes.add(builder);
        this.allUnknownNodes.add(builder);
    }

    public UnknownSchemaNodeBuilder addUnknownSchemaNode(int line, QName qname, SchemaPath path) {
        Builder parent = this.getActualNode();
        UnknownSchemaNodeBuilder builder = new UnknownSchemaNodeBuilder(this.name, line, qname, path);
        builder.setParent(parent);
        this.allUnknownNodes.add(builder);
        if (parent.equals(this)) {
            this.addedUnknownNodes.add(builder);
        } else if (parent instanceof SchemaNodeBuilder) {
            ((SchemaNodeBuilder)parent).addUnknownNodeBuilder(builder);
        } else if (parent instanceof DataNodeContainerBuilder) {
            ((DataNodeContainerBuilder)parent).addUnknownNodeBuilder(builder);
        } else if (parent instanceof RefineHolder) {
            ((RefineHolder)parent).addUnknownNodeBuilder(builder);
        } else {
            throw new YangParseException(this.name, line, "Unresolved parent of unknown node '" + qname.getLocalName() + "'");
        }
        return builder;
    }

    public Set<RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Set<RpcDefinitionBuilder> getAddedRpcs() {
        return this.addedRpcs;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Set<NotificationBuilder> getAddedNotifications() {
        return this.addedNotifications;
    }

    public String toString() {
        return "module " + this.name;
    }

    private void addChildToParent(Builder parent, DataSchemaNodeBuilder child, String childName) {
        int lineNum = child.getLine();
        if (parent.equals(this)) {
            this.addChildToModule(child, childName, lineNum);
        } else {
            this.addChildToSubnodeOfModule(parent, child, childName, lineNum);
        }
    }

    private void addChildToModule(DataSchemaNodeBuilder child, String childName, int lineNum) {
        for (DataSchemaNodeBuilder childNode : this.addedChildNodes) {
            if (!childNode.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, childNode.getLine());
        }
        for (RpcDefinitionBuilder rpc : this.addedRpcs) {
            if (!rpc.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "rpc", childName, lineNum, rpc.getLine());
        }
        for (NotificationBuilder notification : this.addedNotifications) {
            if (!notification.getQName().getLocalName().equals(childName)) continue;
            this.raiseYangParserException("'" + child + "'", "notification", childName, lineNum, notification.getLine());
        }
        this.addedChildNodes.add(child);
    }

    private void addChildToSubnodeOfModule(Builder parent, DataSchemaNodeBuilder child, String childName, int lineNum) {
        if (parent instanceof DataNodeContainerBuilder) {
            DataNodeContainerBuilder parentNode = (DataNodeContainerBuilder)parent;
            for (DataSchemaNodeBuilder childNode : parentNode.getChildNodeBuilders()) {
                if (!childNode.getQName().getLocalName().equals(childName)) continue;
                this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, childNode.getLine());
            }
            parentNode.addChildNode(child);
        } else if (parent instanceof ChoiceBuilder) {
            ChoiceBuilder parentNode = (ChoiceBuilder)parent;
            for (ChoiceCaseBuilder caseBuilder : parentNode.getCases()) {
                if (!caseBuilder.getQName().getLocalName().equals(childName)) continue;
                this.raiseYangParserException("'" + child + "'", "node", childName, lineNum, caseBuilder.getLine());
            }
            parentNode.addCase(child);
        } else {
            throw new YangParseException(this.name, lineNum, "Unresolved parent of node '" + childName + "'.");
        }
    }

    private ModuleImport createModuleImport(String moduleName, Date revision, String prefix) {
        ModuleImportImpl moduleImport = new ModuleImportImpl(moduleName, revision, prefix);
        return moduleImport;
    }

    private void raiseYangParserException(String cantAddType, String type, String name, int currentLine, int duplicateLine) {
        StringBuilder msgPrefix = new StringBuilder("");
        if (cantAddType != null && !cantAddType.isEmpty()) {
            msgPrefix.append("Can not add ");
            msgPrefix.append(cantAddType);
            msgPrefix.append(": ");
        }
        String msg = String.format("%s%s with same name '%s' already declared at line %d.", msgPrefix, type, name, duplicateLine);
        throw new YangParseException(this.moduleName, currentLine, msg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleBuilder other = (ModuleBuilder)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    private final class ModuleImpl
    implements Module {
        private URI namespace;
        private final String name;
        private final String sourcePath;
        private Date revision;
        private String prefix;
        private String yangVersion;
        private String description;
        private String reference;
        private String organization;
        private String contact;
        private final Set<ModuleImport> imports = new HashSet<ModuleImport>();
        private final Set<FeatureDefinition> features = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<TypeDefinition<?>> typeDefinitions = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<NotificationDefinition> notifications = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
        private final Set<RpcDefinition> rpcs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<Deviation> deviations = new HashSet<Deviation>();
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private final List<ExtensionDefinition> extensionNodes = new ArrayList<ExtensionDefinition>();
        private final Set<IdentitySchemaNode> identities = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private ModuleImpl(String name, String sourcePath) {
            this.name = name;
            this.sourcePath = sourcePath;
        }

        public String getModuleSourcePath() {
            return this.sourcePath;
        }

        public URI getNamespace() {
            return this.namespace;
        }

        private void setNamespace(URI namespace) {
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public Date getRevision() {
            return this.revision;
        }

        private void setRevision(Date revision) {
            this.revision = revision;
        }

        public String getPrefix() {
            return this.prefix;
        }

        private void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getYangVersion() {
            return this.yangVersion;
        }

        private void setYangVersion(String yangVersion) {
            this.yangVersion = yangVersion;
        }

        public String getDescription() {
            return this.description;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        public String getReference() {
            return this.reference;
        }

        private void setReference(String reference) {
            this.reference = reference;
        }

        public String getOrganization() {
            return this.organization;
        }

        private void setOrganization(String organization) {
            this.organization = organization;
        }

        public String getContact() {
            return this.contact;
        }

        private void setContact(String contact) {
            this.contact = contact;
        }

        public Set<ModuleImport> getImports() {
            return this.imports;
        }

        private void setImports(Set<ModuleImport> imports) {
            if (imports != null) {
                this.imports.addAll(imports);
            }
        }

        public Set<FeatureDefinition> getFeatures() {
            return this.features;
        }

        private void setFeatures(Set<FeatureDefinition> features) {
            if (features != null) {
                this.features.addAll(features);
            }
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return this.typeDefinitions;
        }

        private void setTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            if (typeDefinitions != null) {
                this.typeDefinitions.addAll(typeDefinitions);
            }
        }

        public Set<NotificationDefinition> getNotifications() {
            return this.notifications;
        }

        private void setNotifications(Set<NotificationDefinition> notifications) {
            if (notifications != null) {
                this.notifications.addAll(notifications);
            }
        }

        public Set<AugmentationSchema> getAugmentations() {
            return this.augmentations;
        }

        private void setAugmentations(Set<AugmentationSchema> augmentations) {
            if (augmentations != null) {
                this.augmentations.addAll(augmentations);
            }
        }

        public Set<RpcDefinition> getRpcs() {
            return this.rpcs;
        }

        private void setRpcs(Set<RpcDefinition> rpcs) {
            if (rpcs != null) {
                this.rpcs.addAll(rpcs);
            }
        }

        public Set<Deviation> getDeviations() {
            return this.deviations;
        }

        private void setDeviations(Set<Deviation> deviations) {
            if (deviations != null) {
                this.deviations.addAll(deviations);
            }
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void addChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return this.groupings;
        }

        private void setGroupings(Set<GroupingDefinition> groupings) {
            if (groupings != null) {
                this.groupings.addAll(groupings);
            }
        }

        public Set<UsesNode> getUses() {
            return this.uses;
        }

        private void setUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public List<ExtensionDefinition> getExtensionSchemaNodes() {
            Collections.sort(this.extensionNodes, Comparators.SCHEMA_NODE_COMP);
            return this.extensionNodes;
        }

        private void setExtensionSchemaNodes(List<ExtensionDefinition> extensionNodes) {
            if (extensionNodes != null) {
                this.extensionNodes.addAll(extensionNodes);
            }
        }

        public Set<IdentitySchemaNode> getIdentities() {
            return this.identities;
        }

        private void setIdentities(Set<IdentitySchemaNode> identities) {
            if (identities != null) {
                this.identities.addAll(identities);
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.unknownNodes;
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return ModuleBuilder.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return ModuleBuilder.this.getChildNode(this.childNodes, name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.yangVersion == null ? 0 : this.yangVersion.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleImpl other = (ModuleImpl)obj;
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.revision == null ? other.revision != null : !this.revision.equals(other.revision)) {
                return false;
            }
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            return !(this.yangVersion == null ? other.yangVersion != null : !this.yangVersion.equals(other.yangVersion));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ModuleImpl.class.getSimpleName());
            sb.append("[");
            sb.append("name=" + this.name);
            sb.append(", namespace=" + this.namespace);
            sb.append(", revision=" + this.revision);
            sb.append(", prefix=" + this.prefix);
            sb.append(", yangVersion=" + this.yangVersion);
            sb.append("]");
            return sb.toString();
        }
    }
}

