/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ListSchemaNodeBuilder
extends AbstractDataNodeContainerBuilder
implements DataSchemaNodeBuilder,
AugmentationTargetBuilder {
    private boolean isBuilt;
    private final ListSchemaNodeImpl instance;
    private List<String> keys;
    private SchemaPath schemaPath;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    public ListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new ListSchemaNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line);
    }

    public ListSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, ListSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new ListSchemaNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line, base.getConstraints());
        this.instance.keyDefinition = base.getKeyDefinition();
        this.instance.userOrdered = base.isUserOrdered();
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmenting = base.isAugmenting();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.configuration = base.isConfiguration();
        this.instance.constraints = base.getConstraints();
        this.instance.augmentations.addAll(base.getAvailableAugmentations());
        URI ns = qname.getNamespace();
        Date rev = qname.getRevision();
        String pref = qname.getPrefix();
        this.addedChildNodes.addAll(ParserUtils.wrapChildNodes(moduleName, line, base.getChildNodes(), path, ns, rev, pref));
        this.addedGroupings.addAll(ParserUtils.wrapGroupings(moduleName, line, base.getGroupings(), path, ns, rev, pref));
        this.addedTypedefs.addAll(ParserUtils.wrapTypedefs(moduleName, line, (DataNodeContainer)base, path, ns, rev, pref));
        this.addedUnknownNodes.addAll(ParserUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, ns, rev, pref));
        this.instance.uses.addAll(base.getUses());
    }

    public ListSchemaNode build() {
        if (!this.isBuilt) {
            for (DataSchemaNodeBuilder dataSchemaNodeBuilder : this.addedChildNodes) {
                this.childNodes.add(dataSchemaNodeBuilder.build());
            }
            this.instance.addChildNodes(this.childNodes);
            if (this.keys == null) {
                this.instance.keyDefinition = Collections.emptyList();
            } else {
                ArrayList<QName> qnames = new ArrayList<QName>();
                for (String key : this.keys) {
                    qnames.add(this.instance.getDataChildByName(key).getQName());
                }
                this.instance.keyDefinition = qnames;
            }
            for (TypeDefinitionBuilder typeDefinitionBuilder : this.addedTypedefs) {
                this.typedefs.add(typeDefinitionBuilder.build());
            }
            this.instance.addTypeDefinitions(this.typedefs);
            for (UsesNodeBuilder usesNodeBuilder : this.addedUsesNodes) {
                this.usesNodes.add(usesNodeBuilder.build());
            }
            this.instance.addUses(this.usesNodes);
            for (GroupingBuilder groupingBuilder : this.addedGroupings) {
                this.groupings.add(groupingBuilder.build());
            }
            this.instance.addGroupings(this.groupings);
            for (AugmentationSchemaBuilder augmentationSchemaBuilder : this.augmentationBuilders) {
                this.augmentations.add(augmentationSchemaBuilder.build());
            }
            this.instance.addAvailableAugmentations(new HashSet<AugmentationSchema>(this.augmentations));
            for (UnknownSchemaNodeBuilder unknownSchemaNodeBuilder : this.addedUnknownNodes) {
                this.unknownNodes.add(unknownSchemaNodeBuilder.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.instance.setConstraints(this.constraints.build());
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        String typeName = type.getQName().getLocalName();
        for (TypeDefinitionBuilder addedTypedef : this.addedTypedefs) {
            if (!addedTypedef.getQName().getLocalName().equals(typeName)) continue;
            throw new YangParseException(this.moduleName, type.getLine(), "Can not add typedef '" + typeName + "': typedef with same name already declared at line " + addedTypedef.getLine());
        }
        this.addedTypedefs.add(type);
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.instance.path = path;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    @Override
    public boolean isAugmenting() {
        return this.instance.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.instance.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    @Override
    public Boolean isConfiguration() {
        return this.instance.configuration;
    }

    @Override
    public void setConfiguration(Boolean configuration) {
        this.instance.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    public boolean isUserOrdered() {
        return this.instance.userOrdered;
    }

    public void setUserOrdered(boolean userOrdered) {
        this.instance.userOrdered = userOrdered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListSchemaNodeBuilder other = (ListSchemaNodeBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "list " + this.qname.getLocalName();
    }

    public final class ListSchemaNodeImpl
    implements ListSchemaNode {
        private final QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private List<QName> keyDefinition = Collections.emptyList();
        private boolean augmenting;
        private boolean addedByUses;
        private boolean configuration;
        private ConstraintDefinition constraints;
        private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<TypeDefinition<?>> typeDefinitions = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private boolean userOrdered;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private ListSchemaNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public List<QName> getKeyDefinition() {
            return this.keyDefinition;
        }

        public boolean isAugmenting() {
            return this.augmenting;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public boolean isConfiguration() {
            return this.configuration;
        }

        public ConstraintDefinition getConstraints() {
            return this.constraints;
        }

        private void setConstraints(ConstraintDefinition constraints) {
            this.constraints = constraints;
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return Collections.unmodifiableSet(this.augmentations);
        }

        private void addAvailableAugmentations(Set<AugmentationSchema> augmentations) {
            if (augmentations != null) {
                this.augmentations.addAll(augmentations);
            }
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void addChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.unmodifiableSet(this.groupings);
        }

        private void addGroupings(Set<GroupingDefinition> groupings) {
            if (groupings != null) {
                this.groupings.addAll(groupings);
            }
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.unmodifiableSet(this.typeDefinitions);
        }

        private void addTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            if (typeDefinitions != null) {
                this.typeDefinitions.addAll(typeDefinitions);
            }
        }

        public Set<UsesNode> getUses() {
            return Collections.unmodifiableSet(this.uses);
        }

        private void addUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return ListSchemaNodeBuilder.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return ListSchemaNodeBuilder.this.getChildNode(this.childNodes, name);
        }

        public boolean isUserOrdered() {
            return this.userOrdered;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListSchemaNodeImpl other = (ListSchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            return "list " + this.qname.getLocalName();
        }
    }
}

