/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractTypeAwareBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class LeafSchemaNodeBuilder
extends AbstractTypeAwareBuilder
implements DataSchemaNodeBuilder {
    private boolean isBuilt;
    private final LeafSchemaNodeImpl instance;
    private SchemaPath schemaPath;
    private final ConstraintsBuilder constraints;

    public LeafSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath schemaPath) {
        super(moduleName, line, qname);
        this.schemaPath = schemaPath;
        this.instance = new LeafSchemaNodeImpl(qname, schemaPath);
        this.constraints = new ConstraintsBuilder(moduleName, line);
    }

    public LeafSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, LeafSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new LeafSchemaNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line, base.getConstraints());
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmenting = base.isAugmenting();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.configuration = base.isConfiguration();
        this.instance.constraintsDef = base.getConstraints();
        this.type = base.getType();
        this.instance.unknownNodes.addAll(base.getUnknownSchemaNodes());
        this.instance.defaultStr = base.getDefault();
        this.instance.unitsStr = base.getUnits();
    }

    public LeafSchemaNode build() {
        if (!this.isBuilt) {
            this.instance.setConstraints(this.constraints.build());
            if (this.type == null && this.typedef == null) {
                throw new YangParseException(this.moduleName, this.line, "Failed to resolve leaf type.");
            }
            if (this.type == null) {
                this.instance.setType(this.typedef.build());
            } else {
                this.instance.setType(this.type);
            }
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.instance.path = path;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public boolean isAugmenting() {
        return this.instance.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.instance.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    @Override
    public Boolean isConfiguration() {
        return this.instance.configuration;
    }

    @Override
    public void setConfiguration(Boolean configuration) {
        this.instance.configuration = configuration;
    }

    public String getDefaultStr() {
        return this.instance.defaultStr;
    }

    public void setDefaultStr(String defaultStr) {
        this.instance.defaultStr = defaultStr;
    }

    public String getUnits() {
        return this.instance.unitsStr;
    }

    public void setUnits(String unitsStr) {
        this.instance.unitsStr = unitsStr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafSchemaNodeBuilder other = (LeafSchemaNodeBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "leaf " + this.qname.getLocalName();
    }

    private final class LeafSchemaNodeImpl
    implements LeafSchemaNode {
        private final QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private boolean augmenting;
        private boolean addedByUses;
        private boolean configuration;
        private ConstraintDefinition constraintsDef;
        private TypeDefinition<?> type;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
        private String defaultStr;
        private String unitsStr;

        private LeafSchemaNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAugmenting() {
            return this.augmenting;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public boolean isConfiguration() {
            return this.configuration;
        }

        public ConstraintDefinition getConstraints() {
            return this.constraintsDef;
        }

        private void setConstraints(ConstraintDefinition constraintsDef) {
            this.constraintsDef = constraintsDef;
        }

        public TypeDefinition<?> getType() {
            return this.type;
        }

        private void setType(TypeDefinition<? extends TypeDefinition<?>> type) {
            this.type = type;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public String getDefault() {
            return this.defaultStr;
        }

        public String getUnits() {
            return this.unitsStr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LeafSchemaNodeImpl other = (LeafSchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(LeafSchemaNodeImpl.class.getSimpleName());
            sb.append("[");
            sb.append("qname=" + this.qname);
            sb.append(", path=" + this.path);
            sb.append("]");
            return sb.toString();
        }
    }
}

