/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class IdentitySchemaNodeBuilder
extends AbstractSchemaNodeBuilder {
    private boolean isBuilt;
    private final IdentitySchemaNodeImpl instance;
    private IdentitySchemaNode baseIdentity;
    private IdentitySchemaNodeBuilder baseIdentityBuilder;
    private final Set<IdentitySchemaNode> derivedIdentities = new HashSet<IdentitySchemaNode>();
    private String baseIdentityName;

    IdentitySchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new IdentitySchemaNodeImpl(qname, path, this.derivedIdentities);
    }

    public IdentitySchemaNode build() {
        if (!this.isBuilt) {
            if (!(this.parentBuilder instanceof ModuleBuilder)) {
                throw new YangParseException(this.moduleName, this.line, "Identity can be defined only under module (was" + this.parentBuilder + ")");
            }
            if (this.baseIdentity == null) {
                if (this.baseIdentityBuilder != null) {
                    this.baseIdentityBuilder.addDerivedIdentity(this.instance);
                    this.baseIdentity = this.baseIdentityBuilder.build();
                }
            } else if (this.baseIdentity instanceof IdentitySchemaNodeImpl) {
                ((IdentitySchemaNodeImpl)this.baseIdentity).toBuilder().addDerivedIdentity(this.instance);
            }
            this.instance.setBaseIdentity(this.baseIdentity);
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    public String getBaseIdentityName() {
        return this.baseIdentityName;
    }

    public void setBaseIdentityName(String baseIdentityName) {
        this.baseIdentityName = baseIdentityName;
    }

    public void setBaseIdentity(IdentitySchemaNodeBuilder baseType) {
        this.baseIdentityBuilder = baseType;
    }

    public void setBaseIdentity(IdentitySchemaNode baseType) {
        this.baseIdentity = baseType;
    }

    public void addDerivedIdentity(IdentitySchemaNode derivedIdentity) {
        if (derivedIdentity != null) {
            this.derivedIdentities.add(derivedIdentity);
        }
    }

    public String toString() {
        return "identity " + this.qname.getLocalName();
    }

    public final class IdentitySchemaNodeImpl
    implements IdentitySchemaNode {
        private final QName qname;
        private final SchemaPath path;
        private IdentitySchemaNode baseIdentity;
        private final Set<IdentitySchemaNode> derivedIdentities;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private IdentitySchemaNodeImpl(QName qname, SchemaPath path, Set<IdentitySchemaNode> derivedIdentities) {
            this.qname = qname;
            this.path = path;
            this.derivedIdentities = derivedIdentities;
        }

        public QName getQName() {
            return this.qname;
        }

        public IdentitySchemaNode getBaseIdentity() {
            return this.baseIdentity;
        }

        private void setBaseIdentity(IdentitySchemaNode baseIdentity) {
            this.baseIdentity = baseIdentity;
        }

        public Set<IdentitySchemaNode> getDerivedIdentities() {
            return Collections.unmodifiableSet(this.derivedIdentities);
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes.addAll(unknownSchemaNodes);
            }
        }

        public IdentitySchemaNodeBuilder toBuilder() {
            return IdentitySchemaNodeBuilder.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdentitySchemaNodeImpl other = (IdentitySchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(IdentitySchemaNodeImpl.class.getSimpleName());
            sb.append("[");
            sb.append("base=" + this.baseIdentity);
            sb.append(", qname=" + this.qname);
            sb.append("]");
            return sb.toString();
        }
    }
}

