/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.Builder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingMember;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.CopyUtils;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class GroupingBuilderImpl
extends AbstractDataNodeContainerBuilder
implements GroupingBuilder {
    private boolean isBuilt;
    private final GroupingDefinitionImpl instance;
    private SchemaPath schemaPath;

    public GroupingBuilderImpl(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new GroupingDefinitionImpl(qname, path);
    }

    public GroupingBuilderImpl(String moduleName, int line, QName qname, SchemaPath path, GroupingDefinition base) {
        super(moduleName, line, base.getQName());
        this.schemaPath = path;
        this.instance = new GroupingDefinitionImpl(qname, path);
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.addedByUses = base.isAddedByUses();
        URI ns = qname.getNamespace();
        Date rev = qname.getRevision();
        String pref = qname.getPrefix();
        this.addedChildNodes.addAll(ParserUtils.wrapChildNodes(moduleName, line, base.getChildNodes(), path, ns, rev, pref));
        this.addedGroupings.addAll(ParserUtils.wrapGroupings(moduleName, line, base.getGroupings(), path, ns, rev, pref));
        this.addedTypedefs.addAll(ParserUtils.wrapTypedefs(moduleName, line, (DataNodeContainer)base, path, ns, rev, pref));
        this.addedUnknownNodes.addAll(ParserUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, ns, rev, pref));
        this.instance.uses.addAll(base.getUses());
    }

    @Override
    public GroupingDefinition build() {
        if (!this.isBuilt) {
            for (DataSchemaNodeBuilder node : this.addedChildNodes) {
                this.childNodes.add(node.build());
            }
            this.instance.addChildNodes(this.childNodes);
            for (GroupingMember builder : this.addedGroupings) {
                this.groupings.add(builder.build());
            }
            this.instance.addGroupings(this.groupings);
            for (TypeDefinitionBuilder entry : this.addedTypedefs) {
                this.typedefs.add(entry.build());
            }
            this.instance.addTypeDefinitions(this.typedefs);
            for (GroupingMember builder : this.addedUsesNodes) {
                this.usesNodes.add(builder.build());
            }
            this.instance.addUses(this.usesNodes);
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public Set<DataSchemaNodeBuilder> instantiateChildNodes(Builder newParent) {
        HashSet<DataSchemaNodeBuilder> nodes = new HashSet<DataSchemaNodeBuilder>();
        for (DataSchemaNodeBuilder node : this.addedChildNodes) {
            DataSchemaNodeBuilder copy = CopyUtils.copy(node, newParent, true);
            ParserUtils.setNodeAddedByUses(copy);
            if (newParent instanceof DataSchemaNodeBuilder) {
                ParserUtils.setNodeConfig(copy, ((DataSchemaNodeBuilder)newParent).isConfiguration());
            }
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<TypeDefinitionBuilder> instantiateTypedefs(Builder newParent) {
        HashSet<TypeDefinitionBuilder> nodes = new HashSet<TypeDefinitionBuilder>();
        for (TypeDefinitionBuilder node : this.addedTypedefs) {
            TypeDefinitionBuilder copy = CopyUtils.copy(node, newParent, true);
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<GroupingBuilder> instantiateGroupings(Builder newParent) {
        HashSet<GroupingBuilder> nodes = new HashSet<GroupingBuilder>();
        for (GroupingBuilder node : this.addedGroupings) {
            GroupingBuilder copy = CopyUtils.copy(node, newParent, true);
            copy.setAddedByUses(true);
            for (DataSchemaNodeBuilder childNode : copy.getChildNodeBuilders()) {
                ParserUtils.setNodeAddedByUses(childNode);
            }
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<UnknownSchemaNodeBuilder> instantiateUnknownNodes(Builder newParent) {
        HashSet<UnknownSchemaNodeBuilder> nodes = new HashSet<UnknownSchemaNodeBuilder>();
        for (UnknownSchemaNodeBuilder node : this.addedUnknownNodes) {
            UnknownSchemaNodeBuilder copy = CopyUtils.copy(node, newParent, true);
            copy.setAddedByUses(true);
            nodes.add(copy);
        }
        return nodes;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        String typeName = type.getQName().getLocalName();
        Iterator i$ = this.addedTypedefs.iterator();
        if (i$.hasNext()) {
            TypeDefinitionBuilder addedTypedef = (TypeDefinitionBuilder)i$.next();
            throw new YangParseException(this.moduleName, type.getLine(), "Can not add typedef '" + typeName + "': typedef with same name already declared at line " + addedTypedef.getLine());
        }
        this.addedTypedefs.add(type);
    }

    @Override
    public SchemaPath getPath() {
        return this.schemaPath;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    public String toString() {
        return "grouping " + this.qname.getLocalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentBuilder == null ? 0 : this.parentBuilder.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GroupingBuilderImpl other = (GroupingBuilderImpl)obj;
        if (this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder)) {
            return false;
        }
        return !(this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath));
    }

    private final class GroupingDefinitionImpl
    implements GroupingDefinition {
        private final QName qname;
        private final SchemaPath path;
        private String description;
        private String reference;
        private Status status;
        private boolean addedByUses;
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<TypeDefinition<?>> typeDefinitions = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private GroupingDefinitionImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void addChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.unmodifiableSet(this.groupings);
        }

        private void addGroupings(Set<GroupingDefinition> groupings) {
            if (groupings != null) {
                this.groupings.addAll(groupings);
            }
        }

        public Set<UsesNode> getUses() {
            return Collections.unmodifiableSet(this.uses);
        }

        private void addUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.unmodifiableSet(this.typeDefinitions);
        }

        private void addTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            if (typeDefinitions != null) {
                this.typeDefinitions.addAll(typeDefinitions);
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return GroupingBuilderImpl.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return GroupingBuilderImpl.this.getChildNode(this.childNodes, name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupingDefinitionImpl other = (GroupingDefinitionImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(GroupingDefinitionImpl.class.getSimpleName());
            sb.append("[");
            sb.append("qname=" + this.qname);
            sb.append("]");
            return sb.toString();
        }
    }
}

