/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;

public final class ExtensionBuilder
extends AbstractSchemaNodeBuilder {
    private boolean isBuilt;
    private final ExtensionDefinitionImpl instance;

    ExtensionBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new ExtensionDefinitionImpl(qname, path);
    }

    public ExtensionDefinition build() {
        if (!this.isBuilt) {
            for (UnknownSchemaNodeBuilder un : this.addedUnknownNodes) {
                this.unknownNodes.add(un.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.schemaPath;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    public void setYinElement(boolean yin) {
        this.instance.yin = yin;
    }

    public void setArgument(String argument) {
        this.instance.argument = argument;
    }

    public String toString() {
        return "extension " + this.qname.getLocalName();
    }

    private final class ExtensionDefinitionImpl
    implements ExtensionDefinition {
        private final QName qname;
        private String argument;
        private final SchemaPath schemaPath;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
        private boolean yin;

        private ExtensionDefinitionImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.schemaPath = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.schemaPath;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public String getArgument() {
            return this.argument;
        }

        public boolean isYinElement() {
            return this.yin;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtensionDefinitionImpl other = (ExtensionDefinitionImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ExtensionDefinitionImpl.class.getSimpleName());
            sb.append("[");
            sb.append("argument=" + this.argument);
            sb.append(", qname=" + this.qname);
            sb.append(", schemaPath=" + this.schemaPath);
            sb.append(", extensionSchemaNodes=" + this.unknownNodes);
            sb.append(", yin=" + this.yin);
            sb.append("]");
            return sb.toString();
        }
    }
}

