/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class DeviationBuilder
extends AbstractBuilder {
    private boolean isBuilt;
    private final DeviationImpl instance;
    private final String targetPathStr;
    private SchemaPath targetPath;

    DeviationBuilder(String moduleName, int line, String targetPathStr) {
        super(moduleName, line);
        if (!targetPathStr.startsWith("/")) {
            throw new YangParseException(moduleName, line, "Deviation argument string must be an absolute schema node identifier.");
        }
        this.targetPathStr = targetPathStr;
        this.targetPath = ParserUtils.parseXPathString(targetPathStr);
        this.instance = new DeviationImpl();
    }

    public Deviation build() {
        if (this.targetPath == null) {
            throw new YangParseException(this.moduleName, this.line, "Unresolved deviation target");
        }
        if (!this.isBuilt) {
            this.instance.setTargetPath(this.targetPath);
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(SchemaPath targetPath) {
        this.targetPath = targetPath;
    }

    public void setDeviate(String deviate) {
        if ("not-supported".equals(deviate)) {
            this.instance.setDeviate(Deviation.Deviate.NOT_SUPPORTED);
        } else if ("add".equals(deviate)) {
            this.instance.setDeviate(Deviation.Deviate.ADD);
        } else if ("replace".equals(deviate)) {
            this.instance.setDeviate(Deviation.Deviate.REPLACE);
        } else if ("delete".equals(deviate)) {
            this.instance.setDeviate(Deviation.Deviate.DELETE);
        } else {
            throw new YangParseException(this.moduleName, this.line, "Unsupported type of 'deviate' statement: " + deviate);
        }
    }

    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    public String toString() {
        return "deviation " + this.targetPathStr;
    }

    private final class DeviationImpl
    implements Deviation {
        private SchemaPath targetPath;
        private Deviation.Deviate deviate;
        private String reference;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private DeviationImpl() {
        }

        public SchemaPath getTargetPath() {
            return this.targetPath;
        }

        private void setTargetPath(SchemaPath targetPath) {
            this.targetPath = targetPath;
        }

        public Deviation.Deviate getDeviate() {
            return this.deviate;
        }

        private void setDeviate(Deviation.Deviate deviate) {
            this.deviate = deviate;
        }

        public String getReference() {
            return this.reference;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes.addAll(unknownSchemaNodes);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
            result = 31 * result + (this.deviate == null ? 0 : this.deviate.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviationImpl other = (DeviationImpl)obj;
            if (this.targetPath == null ? other.targetPath != null : !this.targetPath.equals((Object)other.targetPath)) {
                return false;
            }
            if (this.deviate == null ? other.deviate != null : !this.deviate.equals((Object)other.deviate)) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(DeviationImpl.class.getSimpleName());
            sb.append("[");
            sb.append("targetPath=" + this.targetPath);
            sb.append(", deviate=" + this.deviate);
            sb.append(", reference=" + this.reference);
            sb.append("]");
            return sb.toString();
        }
    }
}

