/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.YangNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingMember;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ContainerSchemaNodeBuilder
extends AbstractDataNodeContainerBuilder
implements AugmentationTargetBuilder,
DataSchemaNodeBuilder {
    private boolean isBuilt;
    private final ContainerSchemaNodeImpl instance;
    private YangNode parent;
    private final SchemaPath path;
    private Boolean configuration;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();

    public ContainerSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.path = path;
        this.instance = new ContainerSchemaNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line);
    }

    public ContainerSchemaNodeBuilder(String moduleName, int line, QName qname, SchemaPath path, ContainerSchemaNode base) {
        super(moduleName, line, qname);
        this.path = path;
        this.instance = new ContainerSchemaNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line, base.getConstraints());
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmenting = base.isAugmenting();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.configuration = base.isConfiguration();
        this.instance.constraints = base.getConstraints();
        this.instance.augmentations.addAll(base.getAvailableAugmentations());
        URI ns = qname.getNamespace();
        Date rev = qname.getRevision();
        String pref = qname.getPrefix();
        this.addedChildNodes.addAll(ParserUtils.wrapChildNodes(moduleName, line, base.getChildNodes(), path, ns, rev, pref));
        this.addedGroupings.addAll(ParserUtils.wrapGroupings(moduleName, line, base.getGroupings(), path, ns, rev, pref));
        this.addedTypedefs.addAll(ParserUtils.wrapTypedefs(moduleName, line, (DataNodeContainer)base, path, ns, rev, pref));
        this.addedUnknownNodes.addAll(ParserUtils.wrapUnknownNodes(moduleName, line, base.getUnknownSchemaNodes(), path, ns, rev, pref));
        this.instance.uses.addAll(base.getUses());
        this.instance.presence = base.isPresenceContainer();
        this.instance.configuration = base.isConfiguration();
        this.configuration = base.isConfiguration();
    }

    public ContainerSchemaNode build() {
        if (!this.isBuilt) {
            if (this.configuration == null) {
                this.configuration = false;
            }
            this.instance.setConfiguration(this.configuration);
            for (GroupingMember builder : this.addedUsesNodes) {
                this.usesNodes.add(builder.build());
            }
            this.instance.addUses(this.usesNodes);
            for (DataSchemaNodeBuilder node : this.addedChildNodes) {
                this.childNodes.add(node.build());
            }
            this.instance.addChildNodes(this.childNodes);
            for (GroupingMember builder : this.addedGroupings) {
                this.groupings.add(builder.build());
            }
            this.instance.addGroupings(this.groupings);
            for (TypeDefinitionBuilder entry : this.addedTypedefs) {
                this.typedefs.add(entry.build());
            }
            this.instance.addTypeDefinitions(this.typedefs);
            ArrayList<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
            for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
                augmentations.add(builder.build());
            }
            this.instance.addAvailableAugmentations(new HashSet(augmentations));
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            if (this.constraints != null) {
                this.instance.setConstraints(this.constraints.build());
            }
            this.isBuilt = true;
        }
        return this.instance;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return this.addedTypedefs;
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        String typeName = type.getQName().getLocalName();
        for (TypeDefinitionBuilder addedTypedef : this.addedTypedefs) {
            if (!addedTypedef.getQName().getLocalName().equals(typeName)) continue;
            throw new YangParseException(this.moduleName, type.getLine(), "Can not add typedef '" + typeName + "': typedef with same name already declared at line " + addedTypedef.getLine());
        }
        this.addedTypedefs.add(type);
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.instance.path = path;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public boolean isAugmenting() {
        return this.instance.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.instance.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    @Override
    public Boolean isConfiguration() {
        return this.instance.configuration;
    }

    @Override
    public void setConfiguration(Boolean configuration) {
        this.instance.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    public boolean isPresence() {
        return this.instance.presence;
    }

    public void setPresence(boolean presence) {
        this.instance.presence = presence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerSchemaNodeBuilder other = (ContainerSchemaNodeBuilder)obj;
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return "container " + this.qname.getLocalName();
    }

    public final class ContainerSchemaNodeImpl
    implements ContainerSchemaNode {
        private final QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private boolean augmenting;
        private boolean addedByUses;
        private boolean configuration;
        private ConstraintDefinition constraints;
        private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<TypeDefinition<?>> typeDefinitions = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
        private boolean presence;

        private ContainerSchemaNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAugmenting() {
            return this.augmenting;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public boolean isConfiguration() {
            return this.configuration;
        }

        private void setConfiguration(boolean configuration) {
            this.configuration = configuration;
        }

        public ConstraintDefinition getConstraints() {
            return this.constraints;
        }

        private void setConstraints(ConstraintDefinition constraints) {
            this.constraints = constraints;
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return Collections.unmodifiableSet(this.augmentations);
        }

        private void addAvailableAugmentations(Set<AugmentationSchema> augmentations) {
            if (augmentations != null) {
                this.augmentations.addAll(augmentations);
            }
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void addChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.unmodifiableSet(this.groupings);
        }

        private void addGroupings(Set<GroupingDefinition> groupings) {
            if (groupings != null) {
                this.groupings.addAll(groupings);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return ContainerSchemaNodeBuilder.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return ContainerSchemaNodeBuilder.this.getChildNode(this.childNodes, name);
        }

        public Set<UsesNode> getUses() {
            return Collections.unmodifiableSet(this.uses);
        }

        private void addUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public boolean isPresenceContainer() {
            return this.presence;
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.unmodifiableSet(this.typeDefinitions);
        }

        private void addTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
            if (typeDefinitions != null) {
                this.typeDefinitions.addAll(typeDefinitions);
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes.addAll(unknownSchemaNodes);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerSchemaNodeImpl other = (ContainerSchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            return "container " + this.qname.getLocalName();
        }
    }
}

