/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;

public final class ConstraintsBuilder {
    private static final int HASH_IF_BOOL_TRUE = 1231;
    private static final int HASH_IF_BOOL_FALSE = 1237;
    private final String moduleName;
    private final int line;
    private final ConstraintDefinitionImpl instance;
    private final Set<MustDefinition> mustDefinitions;
    private RevisionAwareXPath whenStmt;
    private String whenCondition;
    private boolean mandatory;
    private Integer min;
    private Integer max;

    public ConstraintsBuilder(String moduleName, int line) {
        this.moduleName = moduleName;
        this.line = line;
        this.instance = new ConstraintDefinitionImpl();
        this.mustDefinitions = new HashSet<MustDefinition>();
    }

    ConstraintsBuilder(ConstraintsBuilder b) {
        this.moduleName = b.getModuleName();
        this.line = b.getLine();
        this.instance = new ConstraintDefinitionImpl();
        this.mustDefinitions = new HashSet<MustDefinition>(b.getMustDefinitions());
        this.whenCondition = b.getWhenCondition();
        this.mandatory = b.isMandatory();
        this.min = b.getMinElements();
        this.max = b.getMaxElements();
    }

    ConstraintsBuilder(String moduleName, int line, ConstraintDefinition base) {
        this.moduleName = moduleName;
        this.line = line;
        this.instance = new ConstraintDefinitionImpl();
        this.whenStmt = base.getWhenCondition();
        this.mustDefinitions = new HashSet<MustDefinition>(base.getMustConstraints());
        this.mandatory = base.isMandatory();
        this.min = base.getMinElements();
        this.max = base.getMaxElements();
    }

    public ConstraintDefinition build() {
        if (this.whenStmt == null) {
            this.whenStmt = this.whenCondition == null ? null : new RevisionAwareXPathImpl(this.whenCondition, false);
        }
        this.instance.setWhenCondition(this.whenStmt);
        this.instance.setMustConstraints(this.mustDefinitions);
        this.instance.setMandatory(this.mandatory);
        this.instance.setMinElements(this.min);
        this.instance.setMaxElements(this.max);
        return this.instance;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getLine() {
        return this.line;
    }

    public Integer getMinElements() {
        return this.min;
    }

    public void setMinElements(Integer minElements) {
        this.min = minElements;
    }

    public Integer getMaxElements() {
        return this.max;
    }

    public void setMaxElements(Integer maxElements) {
        this.max = maxElements;
    }

    public Set<MustDefinition> getMustDefinitions() {
        return this.mustDefinitions;
    }

    public void addMustDefinition(MustDefinition must) {
        this.mustDefinitions.add(must);
    }

    public String getWhenCondition() {
        return this.whenCondition;
    }

    public void addWhenCondition(String whenCondition) {
        this.whenCondition = whenCondition;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    private final class ConstraintDefinitionImpl
    implements ConstraintDefinition {
        private RevisionAwareXPath whenCondition;
        private Set<MustDefinition> mustConstraints;
        private boolean mandatory;
        private Integer minElements;
        private Integer maxElements;

        private ConstraintDefinitionImpl() {
        }

        public RevisionAwareXPath getWhenCondition() {
            return this.whenCondition;
        }

        private void setWhenCondition(RevisionAwareXPath whenCondition) {
            this.whenCondition = whenCondition;
        }

        public Set<MustDefinition> getMustConstraints() {
            if (this.mustConstraints == null) {
                return Collections.emptySet();
            }
            return this.mustConstraints;
        }

        private void setMustConstraints(Set<MustDefinition> mustConstraints) {
            if (mustConstraints != null) {
                this.mustConstraints = mustConstraints;
            }
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        private void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }

        public Integer getMinElements() {
            return this.minElements;
        }

        private void setMinElements(Integer minElements) {
            this.minElements = minElements;
        }

        public Integer getMaxElements() {
            return this.maxElements;
        }

        private void setMaxElements(Integer maxElements) {
            this.maxElements = maxElements;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
            result = 31 * result + (this.mustConstraints == null ? 0 : this.mustConstraints.hashCode());
            result = 31 * result + (this.minElements == null ? 0 : this.minElements.hashCode());
            result = 31 * result + (this.maxElements == null ? 0 : this.maxElements.hashCode());
            result = 31 * result + (this.mandatory ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstraintDefinitionImpl other = (ConstraintDefinitionImpl)obj;
            if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
                return false;
            }
            if (this.mustConstraints == null ? other.mustConstraints != null : !this.mustConstraints.equals(other.mustConstraints)) {
                return false;
            }
            if (this.mandatory != other.mandatory) {
                return false;
            }
            if (this.minElements == null ? other.minElements != null : !this.minElements.equals(other.minElements)) {
                return false;
            }
            return !(this.maxElements == null ? other.maxElements != null : !this.maxElements.equals(other.maxElements));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ConstraintDefinitionImpl.class.getSimpleName());
            sb.append("[");
            sb.append("whenCondition=" + this.whenCondition);
            sb.append(", mustConstraints=" + this.mustConstraints);
            sb.append(", mandatory=" + this.mandatory);
            sb.append(", minElements=" + this.minElements);
            sb.append(", maxElements=" + this.maxElements);
            sb.append("]");
            return sb.toString();
        }
    }
}

