/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationTargetBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ChoiceCaseBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class ChoiceBuilder
extends AbstractSchemaNodeBuilder
implements DataSchemaNodeBuilder,
AugmentationTargetBuilder {
    private boolean isBuilt;
    private final ChoiceNodeImpl instance;
    private final ConstraintsBuilder constraints;
    private final List<AugmentationSchema> augmentations = new ArrayList<AugmentationSchema>();
    private final List<AugmentationSchemaBuilder> augmentationBuilders = new ArrayList<AugmentationSchemaBuilder>();
    private Set<ChoiceCaseNode> cases = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    private final Set<ChoiceCaseBuilder> caseBuilders = new HashSet<ChoiceCaseBuilder>();
    private String defaultCase;

    public ChoiceBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new ChoiceNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line);
    }

    public ChoiceBuilder(String moduleName, int line, QName qname, SchemaPath path, ChoiceNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new ChoiceNodeImpl(qname, path);
        this.constraints = new ConstraintsBuilder(moduleName, line, base.getConstraints());
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmenting = base.isAugmenting();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.configuration = base.isConfiguration();
        this.instance.constraints = base.getConstraints();
        this.instance.augmentations.addAll(base.getAvailableAugmentations());
        URI ns = qname.getNamespace();
        Date rev = qname.getRevision();
        String pref = qname.getPrefix();
        Set<DataSchemaNodeBuilder> wrapped = ParserUtils.wrapChildNodes(moduleName, line, new HashSet<DataSchemaNode>(base.getCases()), path, ns, rev, pref);
        for (DataSchemaNodeBuilder wrap : wrapped) {
            if (!(wrap instanceof ChoiceCaseBuilder)) continue;
            this.caseBuilders.add((ChoiceCaseBuilder)wrap);
        }
        this.instance.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public ChoiceNode build() {
        if (!this.isBuilt) {
            this.instance.setConstraints(this.constraints.build());
            this.instance.setDefaultCase(this.defaultCase);
            for (ChoiceCaseBuilder caseBuilder : this.caseBuilders) {
                this.cases.add(caseBuilder.build());
            }
            this.instance.addCases(this.cases);
            for (AugmentationSchemaBuilder builder : this.augmentationBuilders) {
                this.augmentations.add(builder.build());
            }
            this.instance.addAvailableAugmentations(new HashSet<AugmentationSchema>(this.augmentations));
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.isBuilt = true;
        }
        return this.instance;
    }

    public Set<ChoiceCaseBuilder> getCases() {
        return this.caseBuilders;
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.instance.path = path;
    }

    public ChoiceCaseBuilder getCaseNodeByName(String caseName) {
        for (ChoiceCaseBuilder addedCase : this.caseBuilders) {
            if (!addedCase.getQName().getLocalName().equals(caseName)) continue;
            return addedCase;
        }
        return null;
    }

    public void addCase(DataSchemaNodeBuilder caseNode) {
        QName caseQName = caseNode.getQName();
        String caseName = caseQName.getLocalName();
        for (ChoiceCaseBuilder addedCase : this.caseBuilders) {
            if (!addedCase.getQName().getLocalName().equals(caseName)) continue;
            throw new YangParseException(caseNode.getModuleName(), caseNode.getLine(), "Can not add '" + caseNode + "' to node '" + this.qname.getLocalName() + "' in module '" + this.moduleName + "': case with same name already declared at line " + addedCase.getLine());
        }
        if (caseNode instanceof ChoiceCaseBuilder) {
            this.caseBuilders.add((ChoiceCaseBuilder)caseNode);
        } else {
            ChoiceCaseBuilder caseBuilder = new ChoiceCaseBuilder(caseNode.getModuleName(), caseNode.getLine(), caseQName, caseNode.getPath());
            if (caseNode.isAugmenting()) {
                caseBuilder.setAugmenting(true);
                caseNode.setAugmenting(false);
            }
            SchemaPath newPath = ParserUtils.createSchemaPath(caseNode.getPath(), caseQName);
            caseNode.setPath(newPath);
            caseBuilder.addChildNode(caseNode);
            this.caseBuilders.add(caseBuilder);
        }
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public boolean isAugmenting() {
        return this.instance.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.instance.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    @Override
    public Boolean isConfiguration() {
        return this.instance.configuration;
    }

    @Override
    public void setConfiguration(Boolean configuration) {
        this.instance.configuration = configuration;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public void addAugmentation(AugmentationSchemaBuilder augment) {
        this.augmentationBuilders.add(augment);
    }

    public List<AugmentationSchemaBuilder> getAugmentationBuilders() {
        return this.augmentationBuilders;
    }

    public String getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(String defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceBuilder other = (ChoiceBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "choice " + this.qname.getLocalName();
    }

    public final class ChoiceNodeImpl
    implements ChoiceNode {
        private final QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private boolean augmenting;
        private boolean addedByUses;
        private boolean configuration;
        private ConstraintDefinition constraints;
        private final Set<ChoiceCaseNode> cases = new HashSet<ChoiceCaseNode>();
        private final Set<AugmentationSchema> augmentations = new HashSet<AugmentationSchema>();
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();
        private String defaultCase;

        private ChoiceNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAugmenting() {
            return this.augmenting;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public boolean isConfiguration() {
            return this.configuration;
        }

        public ConstraintDefinition getConstraints() {
            return this.constraints;
        }

        private void setConstraints(ConstraintDefinition constraints) {
            this.constraints = constraints;
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return Collections.unmodifiableSet(this.augmentations);
        }

        private void addAvailableAugmentations(Set<AugmentationSchema> availableAugmentations) {
            if (availableAugmentations != null) {
                this.augmentations.addAll(availableAugmentations);
            }
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes.addAll(unknownSchemaNodes);
            }
        }

        public Set<ChoiceCaseNode> getCases() {
            return Collections.unmodifiableSet(this.cases);
        }

        public ChoiceCaseNode getCaseNodeByName(QName name) {
            if (name == null) {
                throw new IllegalArgumentException("Choice Case QName cannot be NULL!");
            }
            for (ChoiceCaseNode caseNode : this.cases) {
                if (caseNode == null || !name.equals((Object)caseNode.getQName())) continue;
                return caseNode;
            }
            return null;
        }

        public ChoiceCaseNode getCaseNodeByName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Choice Case string Name cannot be NULL!");
            }
            for (ChoiceCaseNode caseNode : this.cases) {
                if (caseNode == null || caseNode.getQName() == null || !name.equals(caseNode.getQName().getLocalName())) continue;
                return caseNode;
            }
            return null;
        }

        private void addCases(Set<ChoiceCaseNode> cases) {
            if (cases != null) {
                this.cases.addAll(cases);
            }
        }

        public String getDefaultCase() {
            return this.defaultCase;
        }

        private void setDefaultCase(String defaultCase) {
            this.defaultCase = defaultCase;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChoiceNodeImpl other = (ChoiceNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ChoiceNodeImpl.class.getSimpleName());
            sb.append("[");
            sb.append("qname=" + this.qname);
            sb.append("]");
            return sb.toString();
        }
    }
}

