/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractDataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.AugmentationSchemaBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.ParserUtils;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public final class AugmentationSchemaBuilderImpl
extends AbstractDataNodeContainerBuilder
implements AugmentationSchemaBuilder {
    private boolean built;
    private final AugmentationSchemaImpl instance;
    private String whenCondition;
    private final String augmentTargetStr;
    private SchemaPath targetPath;
    private SchemaPath targetNodeSchemaPath;
    private boolean resolved;

    public AugmentationSchemaBuilderImpl(String moduleName, int line, String augmentTargetStr) {
        super(moduleName, line, null);
        this.augmentTargetStr = augmentTargetStr;
        this.targetPath = ParserUtils.parseXPathString(augmentTargetStr);
        this.instance = new AugmentationSchemaImpl(this.targetPath);
    }

    @Override
    public Set<GroupingDefinition> getGroupings() {
        return Collections.emptySet();
    }

    @Override
    public Set<GroupingBuilder> getGroupingBuilders() {
        return Collections.emptySet();
    }

    @Override
    public void addGrouping(GroupingBuilder grouping) {
        throw new YangParseException(this.moduleName, this.line, "augment can not contains grouping statement");
    }

    @Override
    public SchemaPath getPath() {
        return this.targetNodeSchemaPath;
    }

    @Override
    public AugmentationSchema build() {
        if (!this.built) {
            this.instance.setTargetPath(this.targetNodeSchemaPath);
            RevisionAwareXPathImpl whenStmt = this.whenCondition == null ? null : new RevisionAwareXPathImpl(this.whenCondition, false);
            this.instance.setWhenCondition(whenStmt);
            for (DataSchemaNodeBuilder node : this.addedChildNodes) {
                DataSchemaNode child = node.build();
                this.childNodes.add(child);
            }
            this.instance.addChildNodes(this.childNodes);
            for (UsesNodeBuilder builder : this.addedUsesNodes) {
                this.usesNodes.add(builder.build());
            }
            this.instance.addUses(this.usesNodes);
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.addUnknownSchemaNodes(this.unknownNodes);
            this.built = true;
        }
        return this.instance;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public String getWhenCondition() {
        return this.whenCondition;
    }

    @Override
    public void addWhenCondition(String whenCondition) {
        this.whenCondition = whenCondition;
    }

    @Override
    public Set<TypeDefinitionBuilder> getTypeDefinitionBuilders() {
        return Collections.emptySet();
    }

    @Override
    public void addTypedef(TypeDefinitionBuilder type) {
        throw new YangParseException(this.moduleName, this.line, "Augmentation can not contains typedef statement.");
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public String getTargetPathAsString() {
        return this.augmentTargetStr;
    }

    @Override
    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    @Override
    public SchemaPath getTargetNodeSchemaPath() {
        return this.targetNodeSchemaPath;
    }

    @Override
    public void setTargetNodeSchemaPath(SchemaPath path) {
        this.targetNodeSchemaPath = path;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.augmentTargetStr == null ? 0 : this.augmentTargetStr.hashCode());
        result = 17 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
        result = 17 * result + (this.addedChildNodes == null ? 0 : this.addedChildNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AugmentationSchemaBuilderImpl other = (AugmentationSchemaBuilderImpl)obj;
        if (this.augmentTargetStr == null ? other.augmentTargetStr != null : !this.augmentTargetStr.equals(other.augmentTargetStr)) {
            return false;
        }
        if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
            return false;
        }
        return !(this.addedChildNodes == null ? other.addedChildNodes != null : !this.addedChildNodes.equals(other.addedChildNodes));
    }

    public String toString() {
        return "augment " + this.augmentTargetStr;
    }

    private final class AugmentationSchemaImpl
    implements AugmentationSchema {
        private SchemaPath targetPath;
        private RevisionAwareXPath whenCondition;
        private final Set<DataSchemaNode> childNodes = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
        private final Set<UsesNode> uses = new HashSet<UsesNode>();
        private String description;
        private String reference;
        private Status status;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private AugmentationSchemaImpl(SchemaPath targetPath) {
            this.targetPath = targetPath;
        }

        public SchemaPath getTargetPath() {
            return this.targetPath;
        }

        private void setTargetPath(SchemaPath path) {
            this.targetPath = path;
        }

        public RevisionAwareXPath getWhenCondition() {
            return this.whenCondition;
        }

        private void setWhenCondition(RevisionAwareXPath whenCondition) {
            this.whenCondition = whenCondition;
        }

        public Set<DataSchemaNode> getChildNodes() {
            return Collections.unmodifiableSet(this.childNodes);
        }

        private void addChildNodes(Set<DataSchemaNode> childNodes) {
            if (childNodes != null) {
                this.childNodes.addAll(childNodes);
            }
        }

        public Set<GroupingDefinition> getGroupings() {
            return Collections.emptySet();
        }

        public Set<UsesNode> getUses() {
            return Collections.unmodifiableSet(this.uses);
        }

        private void addUses(Set<UsesNode> uses) {
            if (uses != null) {
                this.uses.addAll(uses);
            }
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return Collections.emptySet();
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void addUnknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            if (unknownSchemaNodes != null) {
                this.unknownNodes.addAll(unknownSchemaNodes);
            }
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return AugmentationSchemaBuilderImpl.this.getChildNode(this.childNodes, name);
        }

        public DataSchemaNode getDataChildByName(String name) {
            return AugmentationSchemaBuilderImpl.this.getChildNode(this.childNodes, name);
        }

        public int hashCode() {
            int prime = 17;
            int result = 1;
            result = 17 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
            result = 17 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
            result = 17 * result + (this.childNodes == null ? 0 : this.childNodes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AugmentationSchemaImpl other = (AugmentationSchemaImpl)obj;
            if (this.targetPath == null ? other.targetPath != null : !this.targetPath.equals((Object)other.targetPath)) {
                return false;
            }
            if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
                return false;
            }
            return !(this.childNodes == null ? other.childNodes != null : !this.childNodes.equals(other.childNodes));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(AugmentationSchemaImpl.class.getSimpleName());
            sb.append("[");
            sb.append("targetPath=" + this.targetPath);
            sb.append(", when=" + this.whenCondition);
            sb.append("]");
            return sb.toString();
        }
    }
}

