/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.ConstraintsBuilder;
import org.opendaylight.yangtools.yang.parser.builder.impl.UnknownSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;

public final class AnyXmlBuilder
extends AbstractSchemaNodeBuilder
implements DataSchemaNodeBuilder {
    private boolean built;
    private final AnyXmlSchemaNodeImpl instance;
    private final ConstraintsBuilder constraints;

    public AnyXmlBuilder(String moduleName, int line, QName qname, SchemaPath path) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new AnyXmlSchemaNodeImpl(qname, this.schemaPath);
        this.constraints = new ConstraintsBuilder(moduleName, line);
    }

    public AnyXmlBuilder(String moduleName, int line, QName qname, SchemaPath path, AnyXmlSchemaNode base) {
        super(moduleName, line, qname);
        this.schemaPath = path;
        this.instance = new AnyXmlSchemaNodeImpl(qname, this.schemaPath);
        this.constraints = new ConstraintsBuilder(moduleName, line, base.getConstraints());
        this.instance.description = base.getDescription();
        this.instance.reference = base.getReference();
        this.instance.status = base.getStatus();
        this.instance.augmenting = base.isAugmenting();
        this.instance.addedByUses = base.isAddedByUses();
        this.instance.configuration = base.isConfiguration();
        this.instance.constraintsDef = base.getConstraints();
        this.instance.unknownNodes.addAll(base.getUnknownSchemaNodes());
    }

    public AnyXmlSchemaNode build() {
        if (!this.built) {
            this.instance.setConstraints(this.constraints.build());
            for (UnknownSchemaNodeBuilder b : this.addedUnknownNodes) {
                this.unknownNodes.add(b.build());
            }
            Collections.sort(this.unknownNodes, Comparators.SCHEMA_NODE_COMP);
            this.instance.setUnknownSchemaNodes(this.unknownNodes);
            this.built = true;
        }
        return this.instance;
    }

    @Override
    public SchemaPath getPath() {
        return this.instance.path;
    }

    @Override
    public void setPath(SchemaPath path) {
        this.instance.path = path;
    }

    @Override
    public ConstraintsBuilder getConstraints() {
        return this.constraints;
    }

    @Override
    public String getDescription() {
        return this.instance.description;
    }

    @Override
    public void setDescription(String description) {
        this.instance.description = description;
    }

    @Override
    public String getReference() {
        return this.instance.reference;
    }

    @Override
    public void setReference(String reference) {
        this.instance.reference = reference;
    }

    @Override
    public Status getStatus() {
        return this.instance.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status != null) {
            this.instance.status = status;
        }
    }

    @Override
    public List<UnknownSchemaNodeBuilder> getUnknownNodes() {
        return this.addedUnknownNodes;
    }

    @Override
    public boolean isAugmenting() {
        return this.instance.augmenting;
    }

    @Override
    public void setAugmenting(boolean augmenting) {
        this.instance.augmenting = augmenting;
    }

    @Override
    public boolean isAddedByUses() {
        return this.instance.addedByUses;
    }

    @Override
    public void setAddedByUses(boolean addedByUses) {
        this.instance.addedByUses = addedByUses;
    }

    @Override
    public Boolean isConfiguration() {
        return this.instance.configuration;
    }

    @Override
    public void setConfiguration(Boolean configuration) {
        this.instance.configuration = configuration;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyXmlBuilder other = (AnyXmlBuilder)obj;
        if (this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath)) {
            return false;
        }
        return !(this.parentBuilder == null ? other.parentBuilder != null : !this.parentBuilder.equals(other.parentBuilder));
    }

    public String toString() {
        return "anyxml " + this.qname.getLocalName();
    }

    private final class AnyXmlSchemaNodeImpl
    implements AnyXmlSchemaNode {
        private final QName qname;
        private SchemaPath path;
        private String description;
        private String reference;
        private Status status = Status.CURRENT;
        private boolean configuration;
        private ConstraintDefinition constraintsDef;
        private boolean augmenting;
        private boolean addedByUses;
        private final List<UnknownSchemaNode> unknownNodes = new ArrayList<UnknownSchemaNode>();

        private AnyXmlSchemaNodeImpl(QName qname, SchemaPath path) {
            this.qname = qname;
            this.path = path;
        }

        public QName getQName() {
            return this.qname;
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAugmenting() {
            return this.augmenting;
        }

        public boolean isAddedByUses() {
            return this.addedByUses;
        }

        public boolean isConfiguration() {
            return this.configuration;
        }

        public ConstraintDefinition getConstraints() {
            return this.constraintsDef;
        }

        private void setConstraints(ConstraintDefinition constraintsDef) {
            this.constraintsDef = constraintsDef;
        }

        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return Collections.unmodifiableList(this.unknownNodes);
        }

        private void setUnknownSchemaNodes(List<UnknownSchemaNode> unknownNodes) {
            if (unknownNodes != null) {
                this.unknownNodes.addAll(unknownNodes);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnyXmlSchemaNodeImpl other = (AnyXmlSchemaNodeImpl)obj;
            if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(AnyXmlSchemaNodeImpl.class.getSimpleName());
            sb.append("[");
            sb.append("qname=" + this.qname);
            sb.append(", path=" + this.path);
            sb.append("]");
            return sb.toString();
        }
    }
}

