/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.builder.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.parser.builder.api.AbstractBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataNodeContainerBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.DataSchemaNodeBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.GroupingBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.TypeDefinitionBuilder;
import org.opendaylight.yangtools.yang.parser.builder.api.UsesNodeBuilder;
import org.opendaylight.yangtools.yang.parser.util.Comparators;
import org.opendaylight.yangtools.yang.parser.util.YangParseException;

public abstract class AbstractDataNodeContainerBuilder
extends AbstractBuilder
implements DataNodeContainerBuilder {
    protected QName qname;
    protected final Set<DataSchemaNode> childNodes = new HashSet<DataSchemaNode>();
    protected final Set<DataSchemaNodeBuilder> addedChildNodes = new HashSet<DataSchemaNodeBuilder>();
    protected final Set<GroupingDefinition> groupings = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    protected final Set<GroupingBuilder> addedGroupings = new HashSet<GroupingBuilder>();
    protected final Set<TypeDefinition<?>> typedefs = new TreeSet<SchemaNode>(Comparators.SCHEMA_NODE_COMP);
    protected final Set<TypeDefinitionBuilder> addedTypedefs = new HashSet<TypeDefinitionBuilder>();
    protected final Set<UsesNode> usesNodes = new HashSet<UsesNode>();
    protected final Set<UsesNodeBuilder> addedUsesNodes = new HashSet<UsesNodeBuilder>();

    protected AbstractDataNodeContainerBuilder(String moduleName, int line, QName qname) {
        super(moduleName, line);
        this.qname = qname;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    public Set<DataSchemaNode> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public Set<DataSchemaNodeBuilder> getChildNodeBuilders() {
        return this.addedChildNodes;
    }

    @Override
    public DataSchemaNodeBuilder getDataChildByName(String name) {
        for (DataSchemaNodeBuilder child : this.addedChildNodes) {
            if (!child.getQName().getLocalName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void addChildNode(DataSchemaNodeBuilder child) {
        QName childName = child.getQName();
        for (DataSchemaNodeBuilder addedChildNode : this.addedChildNodes) {
            if (!addedChildNode.getQName().equals((Object)childName)) continue;
            throw new YangParseException(child.getModuleName(), child.getLine(), "Can not add '" + child + "' to '" + this + "' in module '" + this.moduleName + "': node with same name already declared at line " + addedChildNode.getLine());
        }
        this.addedChildNodes.add(child);
    }

    @Override
    public void addChildNodeToContext(DataSchemaNodeBuilder child) {
        this.addedChildNodes.add(child);
    }

    @Override
    public void addChildNode(DataSchemaNode child) {
        QName childName = child.getQName();
        for (DataSchemaNode childNode : this.childNodes) {
            if (!childNode.getQName().equals((Object)childName)) continue;
            throw new YangParseException(this.moduleName, this.line, "Can not add '" + child + "' to '" + this + "' in module '" + this.moduleName + "': node with same name already declared");
        }
        this.childNodes.add(child);
    }

    @Override
    public Set<GroupingDefinition> getGroupings() {
        if (this.groupings == null) {
            return Collections.emptySet();
        }
        return this.groupings;
    }

    @Override
    public Set<GroupingBuilder> getGroupingBuilders() {
        return this.addedGroupings;
    }

    @Override
    public void addGrouping(GroupingBuilder grouping) {
        QName groupingName = grouping.getQName();
        for (GroupingBuilder addedGrouping : this.addedGroupings) {
            if (!addedGrouping.getQName().equals((Object)groupingName)) continue;
            throw new YangParseException(grouping.getModuleName(), grouping.getLine(), "Can not add '" + grouping + "': grouping with same name already declared in module '" + this.moduleName + "' at line " + addedGrouping.getLine());
        }
        this.addedGroupings.add(grouping);
    }

    @Override
    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typedefs;
    }

    public Set<UsesNode> getUsesNodes() {
        return this.usesNodes;
    }

    @Override
    public Set<UsesNodeBuilder> getUsesNodeBuilders() {
        return this.addedUsesNodes;
    }

    @Override
    public void addUsesNode(UsesNodeBuilder usesNode) {
        this.addedUsesNodes.add(usesNode);
    }

    public DataSchemaNode getChildNode(Set<DataSchemaNode> childNodes, QName name) {
        for (DataSchemaNode node : childNodes) {
            if (!node.getQName().equals((Object)name)) continue;
            return node;
        }
        return null;
    }

    public DataSchemaNode getChildNode(Set<DataSchemaNode> childNodes, String name) {
        for (DataSchemaNode node : childNodes) {
            if (!node.getQName().getLocalName().equals(name)) continue;
            return node;
        }
        return null;
    }
}

