/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteToFile {
    protected static final Logger logger = LoggerFactory.getLogger(WriteToFile.class);
    private FileWriter fstream;
    private BufferedWriter bufferOut;

    public WriteToFile(String fileName) throws IOException {
        this.fstream = new FileWriter(fileName);
        this.bufferOut = new BufferedWriter(this.fstream);
    }

    public void save(ArrayList<String> entryList) throws IOException {
        for (String entry : entryList) {
            this.bufferOut.write(entry);
            this.bufferOut.append('\n');
        }
        try {
            this.bufferOut.flush();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public boolean close() {
        try {
            this.bufferOut.close();
            this.fstream.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

