/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.io.Serializable;
import org.opendaylight.controller.sal.utils.StatusCode;

public class Status
implements Serializable {
    private static final long serialVersionUID = 0L;
    private StatusCode code;
    private String description;
    private long requestId;

    public Status(StatusCode errorCode, String description) {
        this.code = errorCode != null ? errorCode : StatusCode.UNDEFINED;
        this.description = description != null ? description : this.code.toString();
        this.requestId = 0L;
    }

    public Status(StatusCode errorCode) {
        this.code = errorCode != null ? errorCode : StatusCode.UNDEFINED;
        this.description = this.description != null ? this.description : this.code.toString();
        this.requestId = 0L;
    }

    public Status(StatusCode errorCode, long requestId) {
        this.code = errorCode != null ? errorCode : StatusCode.UNDEFINED;
        this.description = this.description != null ? this.description : this.code.toString();
        this.requestId = requestId;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSuccess() {
        return this.code == StatusCode.SUCCESS || this.code == StatusCode.CREATED;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String toString() {
        return (Object)((Object)this.code) + ": " + this.description + " (" + this.requestId + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.calculateConsistentHashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return this.code == other.code;
    }
}

