/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonTask {
    protected static Logger logger = LoggerFactory.getLogger(SingletonTask.class);
    protected SingletonTaskContext context = new SingletonTaskContext();
    protected Runnable task;
    protected ScheduledExecutorService ses;

    public SingletonTask(ScheduledExecutorService ses, Runnable task) {
        this.task = task;
        this.ses = ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(long delay, TimeUnit unit) {
        boolean needQueue = true;
        SingletonTaskWorker stw = null;
        SingletonTaskContext singletonTaskContext = this.context;
        synchronized (singletonTaskContext) {
            if (this.context.taskRunning || this.context.taskShouldRun) {
                if (this.context.taskRunning) {
                    if (delay > 0L) {
                        long then;
                        long now = System.nanoTime();
                        this.context.waitingTask.nextschedule = then = now + TimeUnit.NANOSECONDS.convert(delay, unit);
                    } else {
                        this.context.waitingTask.nextschedule = 0L;
                    }
                    needQueue = false;
                } else {
                    this.context.waitingTask.canceled = true;
                    this.context.waitingTask = null;
                }
            }
            this.context.taskShouldRun = true;
            if (needQueue) {
                stw = this.context.waitingTask = new SingletonTaskWorker(this);
            }
        }
        if (needQueue) {
            if (delay <= 0L) {
                this.ses.execute(stw);
            } else {
                this.ses.schedule(stw, delay, unit);
            }
        }
    }

    protected static class SingletonTaskWorker
    implements Runnable {
        SingletonTask parent;
        boolean canceled = false;
        long nextschedule = 0L;

        public SingletonTaskWorker(SingletonTask parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SingletonTaskContext singletonTaskContext = this.parent.context;
            synchronized (singletonTaskContext) {
                if (this.canceled || !this.parent.context.taskShouldRun) {
                    return;
                }
                this.parent.context.taskRunning = true;
                this.parent.context.taskShouldRun = false;
            }
            try {
                this.parent.task.run();
            }
            catch (Exception e) {
                logger.error("Exception while executing task", (Throwable)e);
            }
            singletonTaskContext = this.parent.context;
            synchronized (singletonTaskContext) {
                this.parent.context.taskRunning = false;
                if (this.parent.context.taskShouldRun) {
                    long now = System.nanoTime();
                    if (this.nextschedule <= 0L || this.nextschedule - now <= 0L) {
                        this.parent.ses.execute(this);
                    } else {
                        this.parent.ses.schedule(this, this.nextschedule - now, TimeUnit.NANOSECONDS);
                    }
                }
            }
        }
    }

    protected static class SingletonTaskContext {
        protected boolean taskShouldRun = false;
        protected boolean taskRunning = false;
        protected SingletonTaskWorker waitingTask = null;

        protected SingletonTaskContext() {
        }
    }
}

