/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ServiceHelper.class);

    public static boolean registerService(Class<?> clazz, String containerName, Object instance, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        properties.put("containerName", containerName);
        return ServiceHelper.registerGlobalService(clazz, instance, properties);
    }

    public static boolean registerGlobalService(Class<?> clazz, Object instance, Dictionary<String, Object> properties) {
        ServiceRegistration<?> registration = ServiceHelper.registerGlobalServiceWReg(clazz, instance, properties);
        if (registration == null) {
            logger.error("Failed to register {} for instance {}", clazz, instance);
            return false;
        }
        return true;
    }

    public static ServiceRegistration<?> registerServiceWReg(Class<?> clazz, String containerName, Object instance, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        properties.put("containerName", containerName);
        return ServiceHelper.registerGlobalServiceWReg(clazz, instance, properties);
    }

    public static ServiceRegistration<?> registerGlobalServiceWReg(Class<?> clazz, Object instance, Dictionary<String, Object> properties) {
        try {
            BundleContext bCtx = FrameworkUtil.getBundle(instance.getClass()).getBundleContext();
            if (bCtx == null) {
                logger.error("Could not retrieve the BundleContext");
                return null;
            }
            ServiceRegistration registration = bCtx.registerService(clazz.getName(), instance, properties);
            return registration;
        }
        catch (Exception e) {
            logger.error("Exception {} while registering the service {}", (Object)e.getMessage(), (Object)instance.toString());
            return null;
        }
    }

    public static Object getInstance(Class<?> clazz, String containerName, Object bundle) {
        return ServiceHelper.getInstance(clazz, containerName.toLowerCase(), bundle, null);
    }

    public static Object getGlobalInstance(Class<?> clazz, Object bundle) {
        return ServiceHelper.getGlobalInstance(clazz, bundle, null);
    }

    public static Object getInstance(Class<?> clazz, String containerName, Object bundle, String serviceFilter) {
        Object[] instances = ServiceHelper.getInstances(clazz, containerName, bundle, serviceFilter);
        if (instances != null) {
            return instances[0];
        }
        return null;
    }

    public static Object getGlobalInstance(Class<?> clazz, Object bundle, String serviceFilter) {
        Object[] instances = ServiceHelper.getGlobalInstances(clazz, bundle, serviceFilter);
        if (instances != null) {
            return instances[0];
        }
        return null;
    }

    public static Object[] getInstances(Class<?> clazz, String containerName, Object bundle, String serviceFilter) {
        Object[] instances = null;
        try {
            BundleContext bCtx = FrameworkUtil.getBundle(bundle.getClass()).getBundleContext();
            ServiceReference[] services = null;
            services = serviceFilter != null ? bCtx.getServiceReferences(clazz.getName(), "(&(containerName=" + containerName + ")" + serviceFilter + ")") : bCtx.getServiceReferences(clazz.getName(), "(containerName=" + containerName + ")");
            if (services != null) {
                instances = new Object[services.length];
                for (int i = 0; i < services.length; ++i) {
                    instances[i] = bCtx.getService(services[i]);
                }
            }
        }
        catch (Exception e) {
            logger.error("Instance reference is NULL");
        }
        return instances;
    }

    public static Object[] getGlobalInstances(Class<?> clazz, Object bundle, String serviceFilter) {
        Object[] instances = null;
        try {
            BundleContext bCtx = FrameworkUtil.getBundle(bundle.getClass()).getBundleContext();
            ServiceReference[] services = bCtx.getServiceReferences(clazz.getName(), serviceFilter);
            if (services != null) {
                instances = new Object[services.length];
                for (int i = 0; i < services.length; ++i) {
                    instances[i] = bCtx.getService(services[i]);
                }
            }
        }
        catch (Exception e) {
            logger.error("Instance reference is NULL");
        }
        return instances;
    }
}

