/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectWriter {
    private static Logger logger = LoggerFactory.getLogger(ObjectWriter.class);
    private FileOutputStream fos = null;
    private ObjectOutputStream oos = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status write(Object obj, String file) {
        try {
            this.fos = new FileOutputStream(file);
            this.oos = new ObjectOutputStream(this.fos);
            this.oos.writeObject(obj);
        }
        catch (FileNotFoundException fex) {
            logger.error("Cannot create {} for writing", (Object)file);
            Status status = new Status(StatusCode.INTERNALERROR, "IO Error");
            return status;
        }
        catch (IOException ioex) {
            logger.error("Failed to write to {}", (Object)file);
            Status status = new Status(StatusCode.INTERNALERROR, "IO Error");
            return status;
        }
        finally {
            if (this.oos != null) {
                try {
                    this.oos.close();
                }
                catch (IOException ioex) {
                    logger.error("Failed to close object output stream: {}", (Object)file);
                }
            }
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (IOException ioex) {
                    logger.error("Failed to close output file stream: {}", (Object)file);
                }
            }
        }
        return new Status(StatusCode.SUCCESS);
    }
}

